/*
 * Decompiled with CFR 0.152.
 */
package gregtech.core.network.packets;

import gregtech.api.network.IPacket;
import gregtech.api.network.IServerExecutor;
import gregtech.api.util.input.KeyBind;
import java.util.List;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class PacketKeysPressed
implements IPacket,
IServerExecutor {
    private List<KeyBind> clientKeysUpdated;
    private int[] serverKeysUpdated;
    private boolean[] serverKeysPressed;
    private boolean[] serverKeysDown;

    public PacketKeysPressed() {
    }

    public PacketKeysPressed(@NotNull List<KeyBind> clientKeysUpdated) {
        this.clientKeysUpdated = clientKeysUpdated;
    }

    @Override
    public void encode(@NotNull PacketBuffer buf) {
        buf.func_150787_b(this.clientKeysUpdated.size());
        for (KeyBind keyBind : this.clientKeysUpdated) {
            buf.writeByte(keyBind.ordinal());
            buf.writeBoolean(keyBind.isPressed());
            buf.writeBoolean(keyBind.isKeyDown());
        }
    }

    @Override
    public void decode(@NotNull PacketBuffer buf) {
        int size = buf.func_150792_a();
        this.serverKeysUpdated = new int[size];
        this.serverKeysPressed = new boolean[size];
        this.serverKeysDown = new boolean[size];
        for (int i = 0; i < size; ++i) {
            this.serverKeysUpdated[i] = buf.readByte();
            this.serverKeysPressed[i] = buf.readBoolean();
            this.serverKeysDown[i] = buf.readBoolean();
        }
    }

    @Override
    public void executeServer(NetHandlerPlayServer handler) {
        if (this.serverKeysUpdated == null) {
            throw new IllegalStateException("PacketKeysPressed called executeServer() before decode()");
        }
        for (int i = 0; i < this.serverKeysUpdated.length; ++i) {
            KeyBind.VALUES[i].updateServerState(handler.field_147369_b, this.serverKeysPressed[i], this.serverKeysDown[i]);
        }
    }
}

