/*
 * Decompiled with CFR 0.152.
 */
package gregtech.core.advancement.internal;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import gregtech.api.advancement.IAdvancementCriterion;
import gregtech.api.advancement.IAdvancementTrigger;
import gregtech.api.util.GTUtility;
import gregtech.core.advancement.internal.AdvancementListeners;
import java.util.Map;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class AdvancementTrigger<T extends IAdvancementCriterion>
implements IAdvancementTrigger<T> {
    private final ResourceLocation id;
    private final T criterion;
    private final Map<PlayerAdvancements, AdvancementListeners<T>> listeners = Maps.newHashMap();

    public AdvancementTrigger(String name, @NotNull T criterion) {
        this.id = GTUtility.gregtechId(name);
        this.criterion = criterion;
    }

    @NotNull
    public ResourceLocation func_192163_a() {
        return this.id;
    }

    public void func_192165_a(@NotNull PlayerAdvancements playerAdvancementsIn, @NotNull ICriterionTrigger.Listener<T> listener) {
        AdvancementListeners<T> gtListener = this.listeners.get(playerAdvancementsIn);
        if (gtListener == null) {
            gtListener = new AdvancementListeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, gtListener);
        }
        gtListener.add(listener);
    }

    public void func_192164_b(@NotNull PlayerAdvancements playerAdvancementsIn, @NotNull ICriterionTrigger.Listener<T> listener) {
        AdvancementListeners<T> gtListener = this.listeners.get(playerAdvancementsIn);
        if (gtListener != null) {
            gtListener.remove(listener);
            if (gtListener.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(@NotNull PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    @NotNull
    public T deserializeInstance(@NotNull JsonObject json, @NotNull JsonDeserializationContext context) {
        return this.criterion;
    }

    @Override
    public void trigger(EntityPlayerMP player) {
        AdvancementListeners<T> listener = this.listeners.get(player.func_192039_O());
        if (listener != null) {
            listener.trigger(player);
        }
    }
}

