/*
 * Decompiled with CFR 0.152.
 */
package gregtech.core;

import gregtech.api.GregTechAPI;
import gregtech.api.GregTechAPIInternal;
import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.capability.SimpleCapabilityManager;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverUIFactory;
import gregtech.api.fluids.GTFluidRegistration;
import gregtech.api.gui.UIFactory;
import gregtech.api.items.gui.PlayerInventoryUIFactory;
import gregtech.api.metatileentity.MetaTileEntityUIFactory;
import gregtech.api.metatileentity.registry.MTEManager;
import gregtech.api.metatileentity.registry.MTERegistry;
import gregtech.api.modules.GregTechModule;
import gregtech.api.modules.IGregTechModule;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuiTheme;
import gregtech.api.mui.GTGuis;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.properties.impl.TemperatureProperty;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.event.MaterialEvent;
import gregtech.api.unification.material.event.MaterialRegistryEvent;
import gregtech.api.unification.material.event.PostMaterialEvent;
import gregtech.api.unification.material.registry.MarkerMaterialRegistry;
import gregtech.api.util.CapesRegistry;
import gregtech.api.util.Mods;
import gregtech.api.util.oreglob.OreGlob;
import gregtech.api.util.virtualregistry.VirtualEnderRegistry;
import gregtech.api.worldgen.bedrockFluids.BedrockFluidVeinHandler;
import gregtech.api.worldgen.bedrockFluids.BedrockFluidVeinSaveData;
import gregtech.api.worldgen.config.WorldGenRegistry;
import gregtech.common.CommonProxy;
import gregtech.common.ConfigHolder;
import gregtech.common.MetaEntities;
import gregtech.common.blocks.BlockBatteryPart;
import gregtech.common.blocks.BlockCleanroomCasing;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.command.CommandHand;
import gregtech.common.command.CommandRecipeCheck;
import gregtech.common.command.CommandShaders;
import gregtech.common.command.worldgen.CommandWorldgen;
import gregtech.common.covers.CoverBehaviors;
import gregtech.common.covers.filter.oreglob.impl.OreGlobParser;
import gregtech.common.items.MetaItems;
import gregtech.common.items.ToolItems;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.common.worldgen.LootTableHelper;
import gregtech.core.advancement.AdvancementTriggers;
import gregtech.core.advancement.internal.AdvancementManager;
import gregtech.core.command.internal.CommandManager;
import gregtech.core.network.internal.NetworkHandler;
import gregtech.core.network.packets.PacketBlockParticle;
import gregtech.core.network.packets.PacketClipboard;
import gregtech.core.network.packets.PacketClipboardNBTUpdate;
import gregtech.core.network.packets.PacketClipboardUIWidgetUpdate;
import gregtech.core.network.packets.PacketFluidVeinList;
import gregtech.core.network.packets.PacketKeysPressed;
import gregtech.core.network.packets.PacketNotifyCapeChange;
import gregtech.core.network.packets.PacketPluginSynced;
import gregtech.core.network.packets.PacketRecoverMTE;
import gregtech.core.network.packets.PacketReloadShaders;
import gregtech.core.network.packets.PacketToolbeltSelectionChange;
import gregtech.core.network.packets.PacketUIClientAction;
import gregtech.core.network.packets.PacketUIOpen;
import gregtech.core.network.packets.PacketUIWidgetUpdate;
import gregtech.core.sound.GTSoundEvents;
import gregtech.core.sound.internal.SoundManager;
import gregtech.core.unification.material.internal.MaterialRegistryManager;
import gregtech.datafix.command.CommandDataFix;
import gregtech.integration.bq.BQuDataFixer;
import gregtech.loaders.dungeon.DungeonLootLoader;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.classloading.FMLForgePlugin;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@GregTechModule(moduleID="core", containerID="gregtech", name="GregTech Core", description="Core GregTech content. Disabling this disables the entire mod and all its addons.", coreModule=true)
public class CoreModule
implements IGregTechModule {
    public static final Logger logger = LogManager.getLogger((String)"GregTech Core");
    @SidedProxy(modId="gregtech", clientSide="gregtech.client.ClientProxy", serverSide="gregtech.common.CommonProxy")
    public static CommonProxy proxy;

    public CoreModule() {
        GregTechAPI.networkHandler = NetworkHandler.getInstance();
        GregTechAPI.materialManager = MaterialRegistryManager.getInstance();
        OreGlob.setCompiler((expr, ignoreCase) -> new OreGlobParser(expr, ignoreCase).compile());
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return logger;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        GregTechAPIInternal.preInit();
        GregTechAPI.advancementManager = AdvancementManager.getInstance();
        AdvancementTriggers.register();
        GregTechAPI.soundManager = SoundManager.getInstance();
        GTSoundEvents.register();
        GTGuis.registerFactories();
        GTGuiTextures.init();
        GTGuiTheme.registerThemes();
        GregTechAPI.UI_FACTORY_REGISTRY.unfreeze();
        logger.info("Registering GTCEu UI Factories");
        MetaTileEntityUIFactory.INSTANCE.init();
        PlayerInventoryUIFactory.INSTANCE.init();
        CoverUIFactory.INSTANCE.init();
        logger.info("Registering addon UI Factories");
        MinecraftForge.EVENT_BUS.post(new GregTechAPI.RegisterEvent<UIFactory>(GregTechAPI.UI_FACTORY_REGISTRY, UIFactory.class));
        GregTechAPI.UI_FACTORY_REGISTRY.freeze();
        SimpleCapabilityManager.init();
        GregTechAPI.markerMaterialRegistry = MarkerMaterialRegistry.getInstance();
        MaterialRegistryManager managerInternal = (MaterialRegistryManager)GregTechAPI.materialManager;
        logger.info("Registering material registries");
        MinecraftForge.EVENT_BUS.post((Event)new MaterialRegistryEvent());
        managerInternal.unfreezeRegistries();
        MaterialEvent materialEvent = new MaterialEvent();
        logger.info("Registering GTCEu Materials");
        Materials.register();
        MaterialRegistryManager.getInstance().getRegistry("gregtech").setFallbackMaterial(Materials.Aluminium);
        logger.info("Registering addon Materials");
        MinecraftForge.EVENT_BUS.post((Event)materialEvent);
        managerInternal.closeRegistries();
        MinecraftForge.EVENT_BUS.post((Event)new PostMaterialEvent());
        managerInternal.freezeRegistries();
        GregTechAPI.mteManager = MTEManager.getInstance();
        MinecraftForge.EVENT_BUS.post((Event)new MTEManager.MTERegistryEvent());
        OreDictUnifier.init();
        MetaBlocks.init();
        MetaItems.init();
        ToolItems.init();
        GTFluidRegistration.INSTANCE.register();
        for (MTERegistry registry : GregTechAPI.mteManager.getRegistries()) {
            registry.unfreeze();
        }
        logger.info("Registering GTCEu Meta Tile Entities");
        MetaTileEntities.init();
        MetaEntities.init();
        for (BlockWireCoil.CoilType coilType : BlockWireCoil.CoilType.values()) {
            GregTechAPI.HEATING_COILS.put((Object)MetaBlocks.WIRE_COIL.getState(coilType), (Object)coilType);
        }
        for (Enum enum_ : BlockBatteryPart.BatteryPartType.values()) {
            GregTechAPI.PSS_BATTERIES.put((Object)MetaBlocks.BATTERY_BLOCK.getState(enum_), (Object)enum_);
        }
        for (Enum enum_ : BlockCleanroomCasing.CasingType.values()) {
            GregTechAPI.CLEANROOM_FILTERS.put((Object)MetaBlocks.CLEANROOM_CASING.getState(enum_), (Object)enum_);
        }
        proxy.onPreLoad();
    }

    @Override
    public void registerPackets() {
        GregTechAPI.networkHandler.registerPacket(PacketUIOpen.class);
        GregTechAPI.networkHandler.registerPacket(PacketUIWidgetUpdate.class);
        GregTechAPI.networkHandler.registerPacket(PacketUIClientAction.class);
        GregTechAPI.networkHandler.registerPacket(PacketBlockParticle.class);
        GregTechAPI.networkHandler.registerPacket(PacketClipboard.class);
        GregTechAPI.networkHandler.registerPacket(PacketClipboardUIWidgetUpdate.class);
        GregTechAPI.networkHandler.registerPacket(PacketPluginSynced.class);
        GregTechAPI.networkHandler.registerPacket(PacketRecoverMTE.class);
        GregTechAPI.networkHandler.registerPacket(PacketKeysPressed.class);
        GregTechAPI.networkHandler.registerPacket(PacketFluidVeinList.class);
        GregTechAPI.networkHandler.registerPacket(PacketNotifyCapeChange.class);
        GregTechAPI.networkHandler.registerPacket(PacketReloadShaders.class);
        GregTechAPI.networkHandler.registerPacket(PacketClipboardNBTUpdate.class);
        GregTechAPI.networkHandler.registerPacket(PacketToolbeltSelectionChange.Server.class);
        GregTechAPI.networkHandler.registerPacket(PacketToolbeltSelectionChange.Client.class);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        for (MTERegistry registry : GregTechAPI.mteManager.getRegistries()) {
            registry.freeze();
        }
        proxy.onLoad();
        if (RecipeMap.isFoundInvalidRecipe()) {
            logger.fatal("Seems like invalid recipe was found.");
            if (!ConfigHolder.misc.ignoreErrorOrInvalidRecipes || !FMLForgePlugin.RUNTIME_DEOBF) {
                logger.fatal("Loading cannot continue. Either fix or report invalid recipes, or enable ignoreErrorOrInvalidRecipes in the config as a temporary solution");
                throw new LoaderException("Found at least one invalid recipe. Please read the log above for more details.");
            }
            logger.fatal("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            logger.fatal("Ignoring invalid recipes and continuing loading");
            logger.fatal("Some things may lack recipes or have invalid ones, proceed at your own risk");
            logger.fatal("Report to GTCEu GitHub to get more help and fix the problem");
            logger.fatal("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
        WorldGenRegistry.INSTANCE.initializeRegistry();
        LootTableHelper.initialize();
        GregTechAPI.COVER_REGISTRY.unfreeze();
        CoverBehaviors.init();
        MinecraftForge.EVENT_BUS.post(new GregTechAPI.RegisterEvent<CoverDefinition>(GregTechAPI.COVER_REGISTRY, CoverDefinition.class));
        GregTechAPI.COVER_REGISTRY.freeze();
        DungeonLootLoader.init();
        MetaBlocks.registerWalkingSpeedBonus();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        proxy.onPostLoad();
        BedrockFluidVeinHandler.recalculateChances(true);
        for (Map.Entry entry : GregTechAPI.HEATING_COILS.entrySet()) {
            IHeatingCoilBlockStats value = (IHeatingCoilBlockStats)entry.getValue();
            if (value == null) continue;
            String name = ((IBlockState)entry.getKey()).func_177230_c().func_149739_a();
            if (!name.endsWith(".name")) {
                name = String.format("%s.name", name);
            }
            TemperatureProperty.registerCoilType(value.getCoilTemperature(), value.getMaterial(), name);
        }
        ModHandler.postInit();
    }

    @Override
    public void loadComplete(FMLLoadCompleteEvent event) {
        proxy.onLoadComplete();
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
        CommandManager commandManager = CommandManager.getInstance();
        GregTechAPI.commandManager = commandManager;
        commandManager.registerServerCommand(event);
        GregTechAPI.commandManager.addCommand((ICommand)new CommandWorldgen());
        GregTechAPI.commandManager.addCommand((ICommand)new CommandHand());
        GregTechAPI.commandManager.addCommand((ICommand)new CommandRecipeCheck());
        GregTechAPI.commandManager.addCommand((ICommand)new CommandShaders());
        GregTechAPI.commandManager.addCommand((ICommand)new CommandDataFix());
        CapesRegistry.load();
        if (Mods.BetterQuestingUnofficial.isModLoaded()) {
            BQuDataFixer.onServerStarting((ICommandSender)event.getServer());
        }
    }

    @Override
    public void serverStarted(FMLServerStartedEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            World world = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_();
            if (!world.field_72995_K) {
                BedrockFluidVeinSaveData saveData = (BedrockFluidVeinSaveData)world.func_72943_a(BedrockFluidVeinSaveData.class, "gregtech.bedrockFluidVeinData");
                if (saveData == null) {
                    saveData = new BedrockFluidVeinSaveData("gregtech.bedrockFluidVeinData");
                    world.func_72823_a("gregtech.bedrockFluidVeinData", (WorldSavedData)saveData);
                    BedrockFluidVeinHandler.saveDataVersion = 2;
                }
                BedrockFluidVeinSaveData.setInstance(saveData);
            }
        }
    }

    @Override
    public void serverStopped(FMLServerStoppedEvent event) {
        VirtualEnderRegistry.clearMaps();
        CapesRegistry.clearMaps();
    }
}

