/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.worldgen;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.common.worldgen.AbstractItemLootEntry;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.ForgeHooks;

public class LootEntryMetaItem
extends AbstractItemLootEntry {
    private final MetaItem.MetaValueItem metaValueItem;

    protected LootEntryMetaItem(MetaItem.MetaValueItem metaValueItem, int weightIn, int qualityIn, LootFunction[] functionsIn, LootCondition[] conditionsIn, String entryName) {
        super(weightIn, qualityIn, functionsIn, conditionsIn, entryName);
        this.metaValueItem = metaValueItem;
    }

    @Override
    protected ItemStack createItemStack() {
        return this.metaValueItem == null ? ItemStack.field_190927_a : this.metaValueItem.getStackForm();
    }

    public static MetaItem.MetaValueItem getMetaItem(String name) {
        return MetaItem.getMetaItems().stream().flatMap(item -> item.getAllItems().stream()).map(item -> item).filter(item -> item.unlocalizedName.equals(name)).findFirst().orElse(null);
    }

    public static LootEntryMetaItem deserialize(JsonObject object, JsonDeserializationContext context, int weight, int quality, LootCondition[] conditions) {
        String entryName = ForgeHooks.readLootEntryName((JsonObject)object, (String)"item");
        LootFunction[] lootFunctions = object.has("functions") ? (LootFunction[])JsonUtils.func_188174_a((JsonObject)object, (String)"functions", (JsonDeserializationContext)context, LootFunction[].class) : new LootFunction[]{};
        String metaItemName = JsonUtils.func_151200_h((JsonObject)object, (String)"name");
        MetaItem.MetaValueItem metaValueItem = LootEntryMetaItem.getMetaItem(metaItemName);
        if (metaValueItem == null) {
            throw new IllegalArgumentException("Unknown meta item: '" + metaItemName + "'");
        }
        return new LootEntryMetaItem(metaValueItem, weight, quality, lootFunctions, conditions, entryName);
    }
}

