/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.optical.net;

import gregtech.api.capability.IDataAccessHatch;
import gregtech.api.capability.IOpticalComputationProvider;
import gregtech.api.capability.IOpticalDataAccessHatch;
import gregtech.api.recipes.Recipe;
import gregtech.common.pipelike.optical.net.OpticalPipeNet;
import gregtech.common.pipelike.optical.net.OpticalRoutePath;
import gregtech.common.pipelike.optical.tile.TileEntityOpticalPipe;
import java.util.Collection;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpticalNetHandler
implements IDataAccessHatch,
IOpticalComputationProvider {
    private final TileEntityOpticalPipe pipe;
    private final World world;
    private final EnumFacing facing;
    private OpticalPipeNet net;

    public OpticalNetHandler(OpticalPipeNet net, @NotNull TileEntityOpticalPipe pipe, @Nullable EnumFacing facing) {
        this.net = net;
        this.pipe = pipe;
        this.facing = facing;
        this.world = pipe.func_145831_w();
    }

    public void updateNetwork(OpticalPipeNet net) {
        this.net = net;
    }

    public OpticalPipeNet getNet() {
        return this.net;
    }

    @Override
    public boolean isRecipeAvailable(@NotNull Recipe recipe, @NotNull Collection<IDataAccessHatch> seen) {
        boolean isAvailable = this.traverseRecipeAvailable(recipe, seen);
        if (isAvailable) {
            this.setPipesActive();
        }
        return isAvailable;
    }

    @Override
    public boolean isCreative() {
        return false;
    }

    @Override
    public int requestCWUt(int cwut, boolean simulate, @NotNull Collection<IOpticalComputationProvider> seen) {
        int provided = this.traverseRequestCWUt(cwut, simulate, seen);
        if (provided > 0) {
            this.setPipesActive();
        }
        return provided;
    }

    @Override
    public int getMaxCWUt(@NotNull Collection<IOpticalComputationProvider> seen) {
        return this.traverseMaxCWUt(seen);
    }

    @Override
    public boolean canBridge(@NotNull Collection<IOpticalComputationProvider> seen) {
        return this.traverseCanBridge(seen);
    }

    private void setPipesActive() {
        for (BlockPos pos : this.net.getAllNodes().keySet()) {
            TileEntity tileEntity = this.world.func_175625_s(pos);
            if (!(tileEntity instanceof TileEntityOpticalPipe)) continue;
            TileEntityOpticalPipe opticalPipe = (TileEntityOpticalPipe)tileEntity;
            opticalPipe.setActive(true, 100);
        }
    }

    private boolean isNetInvalidForTraversal() {
        return this.net == null || this.pipe == null || this.pipe.func_145837_r();
    }

    private boolean traverseRecipeAvailable(@NotNull Recipe recipe, @NotNull Collection<IDataAccessHatch> seen) {
        if (this.isNetInvalidForTraversal()) {
            return false;
        }
        OpticalRoutePath inv = this.net.getNetData(this.pipe.getPipePos(), this.facing);
        if (inv == null) {
            return false;
        }
        IOpticalDataAccessHatch hatch = inv.getDataHatch();
        if (hatch == null || seen.contains(hatch)) {
            return false;
        }
        if (hatch.isTransmitter()) {
            return hatch.isRecipeAvailable(recipe, seen);
        }
        return false;
    }

    private int traverseRequestCWUt(int cwut, boolean simulate, @NotNull Collection<IOpticalComputationProvider> seen) {
        IOpticalComputationProvider provider = this.getComputationProvider(seen);
        if (provider == null) {
            return 0;
        }
        return provider.requestCWUt(cwut, simulate, seen);
    }

    private int traverseMaxCWUt(@NotNull Collection<IOpticalComputationProvider> seen) {
        IOpticalComputationProvider provider = this.getComputationProvider(seen);
        if (provider == null) {
            return 0;
        }
        return provider.getMaxCWUt(seen);
    }

    private boolean traverseCanBridge(@NotNull Collection<IOpticalComputationProvider> seen) {
        IOpticalComputationProvider provider = this.getComputationProvider(seen);
        if (provider == null) {
            return true;
        }
        return provider.canBridge(seen);
    }

    @Nullable
    private IOpticalComputationProvider getComputationProvider(@NotNull Collection<IOpticalComputationProvider> seen) {
        if (this.isNetInvalidForTraversal()) {
            return null;
        }
        OpticalRoutePath inv = this.net.getNetData(this.pipe.getPipePos(), this.facing);
        if (inv == null) {
            return null;
        }
        IOpticalComputationProvider hatch = inv.getComputationHatch();
        if (hatch == null || seen.contains(hatch)) {
            return null;
        }
        return hatch;
    }
}

