/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.laser.tile;

import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.ILaserContainer;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.util.TaskScheduler;
import gregtech.common.pipelike.laser.LaserPipeProperties;
import gregtech.common.pipelike.laser.LaserPipeType;
import gregtech.common.pipelike.laser.net.LaserNetHandler;
import gregtech.common.pipelike.laser.net.LaserPipeNet;
import gregtech.common.pipelike.laser.net.WorldLaserPipeNet;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityLaserPipe
extends TileEntityPipeBase<LaserPipeType, LaserPipeProperties> {
    private final EnumMap<EnumFacing, LaserNetHandler> handlers = new EnumMap(EnumFacing.class);
    private final ILaserContainer clientCapability = new DefaultLaserContainer();
    private WeakReference<LaserPipeNet> currentPipeNet = new WeakReference<Object>(null);
    private LaserNetHandler defaultHandler;
    private int ticksActive = 0;
    private int activeDuration = 0;
    private boolean isActive = false;

    @Override
    public Class<LaserPipeType> getPipeTypeClass() {
        return LaserPipeType.class;
    }

    @Override
    public boolean supportsTicking() {
        return false;
    }

    @Override
    public boolean canHaveBlockedFaces() {
        return false;
    }

    private void initHandlers() {
        LaserPipeNet net = this.getLaserPipeNet();
        if (net == null) {
            return;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.handlers.put(facing, new LaserNetHandler(net, this, facing));
        }
        this.defaultHandler = new LaserNetHandler(net, this, null);
    }

    @Override
    public <T> T getCapabilityInternal(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == GregtechTileCapabilities.CAPABILITY_LASER) {
            if (this.field_145850_b.field_72995_K) {
                return (T)GregtechTileCapabilities.CAPABILITY_LASER.cast((Object)this.clientCapability);
            }
            if (this.handlers.isEmpty()) {
                this.initHandlers();
            }
            this.checkNetwork();
            return (T)GregtechTileCapabilities.CAPABILITY_LASER.cast((Object)this.handlers.getOrDefault(facing, this.defaultHandler));
        }
        return super.getCapabilityInternal(capability, facing);
    }

    public void checkNetwork() {
        if (this.defaultHandler != null) {
            LaserPipeNet current = this.getLaserPipeNet();
            if (this.defaultHandler.getNet() != current) {
                this.defaultHandler.updateNetwork(current);
                for (LaserNetHandler handler : this.handlers.values()) {
                    handler.updateNetwork(current);
                }
            }
        }
    }

    public LaserPipeNet getLaserPipeNet() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return null;
        }
        LaserPipeNet currentPipeNet = (LaserPipeNet)this.currentPipeNet.get();
        if (currentPipeNet != null && currentPipeNet.isValid() && currentPipeNet.containsNode(this.getPipePos())) {
            return currentPipeNet;
        }
        WorldLaserPipeNet worldNet = (WorldLaserPipeNet)((Object)this.getPipeBlock().getWorldPipeNet(this.getPipeWorld()));
        currentPipeNet = (LaserPipeNet)worldNet.getNetFromPos(this.getPipePos());
        if (currentPipeNet != null) {
            this.currentPipeNet = new WeakReference<LaserPipeNet>(currentPipeNet);
        }
        return currentPipeNet;
    }

    @Override
    public void transferDataFrom(IPipeTile<LaserPipeType, LaserPipeProperties> tileEntity) {
        super.transferDataFrom(tileEntity);
        if (this.getLaserPipeNet() == null) {
            return;
        }
        TileEntityLaserPipe pipe = (TileEntityLaserPipe)tileEntity;
        if (!pipe.handlers.isEmpty() && pipe.defaultHandler != null) {
            this.handlers.clear();
            this.handlers.putAll(pipe.handlers);
            this.defaultHandler = pipe.defaultHandler;
        } else {
            this.initHandlers();
        }
    }

    @Override
    public void setConnection(EnumFacing side, boolean connected, boolean fromNeighbor) {
        if (!this.func_145831_w().field_72995_K && connected && !fromNeighbor) {
            IPipeTile pipeTile;
            int connections = this.getConnections();
            connections &= ~(1 << side.func_176745_a());
            if ((connections &= ~(1 << side.func_176734_d().func_176745_a())) != 0) {
                return;
            }
            TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(side));
            if (tile instanceof IPipeTile && (pipeTile = (IPipeTile)tile).getPipeType().getClass() == ((LaserPipeType)this.getPipeType()).getClass()) {
                connections = pipeTile.getConnections();
                connections &= ~(1 << side.func_176745_a());
                if ((connections &= ~(1 << side.func_176734_d().func_176745_a())) != 0) {
                    return;
                }
            }
        }
        super.setConnection(side, connected, fromNeighbor);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active, int duration) {
        if (this.isActive != active) {
            this.isActive = active;
            this.notifyBlockUpdate();
            this.func_70296_d();
            this.writeCustomData(GregtechDataCodes.PIPE_LASER_ACTIVE, buf -> buf.writeBoolean(this.isActive));
            if (active && duration != this.activeDuration) {
                TaskScheduler.scheduleTask(this.func_145831_w(), this::queueDisconnect);
            }
        }
        this.activeDuration = duration;
        if (duration > 0 && active) {
            this.ticksActive = 0;
        }
    }

    public boolean queueDisconnect() {
        if (++this.ticksActive % this.activeDuration == 0) {
            this.ticksActive = 0;
            this.setActive(false, -1);
            return false;
        }
        return true;
    }

    @Override
    public void receiveCustomData(int discriminator, PacketBuffer buf) {
        super.receiveCustomData(discriminator, buf);
        if (discriminator == GregtechDataCodes.PIPE_LASER_ACTIVE) {
            this.isActive = buf.readBoolean();
            this.scheduleChunkForRenderUpdate();
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isActive);
        if (this.isActive) {
            this.activeDuration = 100;
            TaskScheduler.scheduleTask(this.func_145831_w(), this::queueDisconnect);
        }
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isActive = buf.readBoolean();
        this.scheduleChunkForRenderUpdate();
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        compound.func_74757_a("Active", this.isActive);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(@NotNull NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("Active", 1)) {
            this.isActive = compound.func_74767_n("Active");
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.handlers.clear();
    }

    private static class DefaultLaserContainer
    implements ILaserContainer {
        private DefaultLaserContainer() {
        }

        @Override
        public long acceptEnergyFromNetwork(EnumFacing side, long voltage, long amperage) {
            return 0L;
        }

        @Override
        public boolean inputsEnergy(EnumFacing side) {
            return false;
        }

        @Override
        public long changeEnergy(long differenceAmount) {
            return 0L;
        }

        @Override
        public long getEnergyStored() {
            return 0L;
        }

        @Override
        public long getEnergyCapacity() {
            return 0L;
        }

        @Override
        public long getInputAmperage() {
            return 0L;
        }

        @Override
        public long getInputVoltage() {
            return 0L;
        }
    }
}

