/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.laser.net;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.ILaserContainer;
import gregtech.api.pipenet.PipeNetWalker;
import gregtech.api.util.GTUtility;
import gregtech.common.pipelike.laser.net.LaserRoutePath;
import gregtech.common.pipelike.laser.tile.TileEntityLaserPipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class LaserNetWalker
extends PipeNetWalker<TileEntityLaserPipe> {
    public static final LaserRoutePath FAILED_MARKER = new LaserRoutePath(null, null, 0);
    private static final EnumFacing[] X_AXIS_FACINGS = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST};
    private static final EnumFacing[] Y_AXIS_FACINGS = new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN};
    private static final EnumFacing[] Z_AXIS_FACINGS = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH};
    private LaserRoutePath routePath;
    private BlockPos sourcePipe;
    private EnumFacing facingToHandler;
    private EnumFacing.Axis axis;

    @Nullable
    public static LaserRoutePath createNetData(World world, BlockPos sourcePipe, EnumFacing faceToSourceHandler) {
        LaserNetWalker walker = new LaserNetWalker(world, sourcePipe, 1);
        walker.sourcePipe = sourcePipe;
        walker.facingToHandler = faceToSourceHandler;
        walker.axis = faceToSourceHandler.func_176740_k();
        walker.traversePipeNet();
        return walker.isFailed() ? FAILED_MARKER : walker.routePath;
    }

    protected LaserNetWalker(World world, BlockPos sourcePipe, int distance) {
        super(world, sourcePipe, distance);
    }

    @Override
    protected PipeNetWalker<TileEntityLaserPipe> createSubWalker(World world, EnumFacing facingToNextPos, BlockPos nextPos, int walkedBlocks) {
        LaserNetWalker walker = new LaserNetWalker(world, nextPos, walkedBlocks);
        walker.facingToHandler = this.facingToHandler;
        walker.sourcePipe = this.sourcePipe;
        walker.axis = this.axis;
        return walker;
    }

    @Override
    protected EnumFacing[] getSurroundingPipeSides() {
        EnumFacing[] enumFacingArray;
        switch (this.axis) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case X: {
                enumFacingArray = X_AXIS_FACINGS;
                break;
            }
            case Y: {
                enumFacingArray = Y_AXIS_FACINGS;
                break;
            }
            case Z: {
                enumFacingArray = Z_AXIS_FACINGS;
            }
        }
        return enumFacingArray;
    }

    @Override
    protected void checkPipe(TileEntityLaserPipe pipeTile, BlockPos pos) {
    }

    @Override
    protected void checkNeighbour(TileEntityLaserPipe pipeTile, BlockPos pipePos, EnumFacing faceToNeighbour, @Nullable TileEntity neighbourTile) {
        ILaserContainer handler;
        if (neighbourTile == null || GTUtility.arePosEqual(pipePos, this.sourcePipe) && faceToNeighbour == this.facingToHandler) {
            return;
        }
        if (((LaserNetWalker)this.root).routePath == null && (handler = (ILaserContainer)neighbourTile.getCapability(GregtechTileCapabilities.CAPABILITY_LASER, faceToNeighbour.func_176734_d())) != null) {
            ((LaserNetWalker)this.root).routePath = new LaserRoutePath(pipeTile, faceToNeighbour, this.getWalkedBlocks());
            this.stop();
        }
    }

    @Override
    protected Class<TileEntityLaserPipe> getBasePipeClass() {
        return TileEntityLaserPipe.class;
    }
}

