/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.laser;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.client.renderer.pipe.LaserPipeRenderer;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.common.creativetab.GTCreativeTabs;
import gregtech.common.pipelike.laser.ItemBlockLaserPipe;
import gregtech.common.pipelike.laser.LaserPipeProperties;
import gregtech.common.pipelike.laser.LaserPipeType;
import gregtech.common.pipelike.laser.net.WorldLaserPipeNet;
import gregtech.common.pipelike.laser.tile.TileEntityLaserPipe;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLaserPipe
extends BlockPipe<LaserPipeType, LaserPipeProperties, WorldLaserPipeNet> {
    private final LaserPipeType pipeType;
    private final LaserPipeProperties properties;

    public BlockLaserPipe(@NotNull LaserPipeType pipeType) {
        this.pipeType = pipeType;
        this.properties = LaserPipeProperties.INSTANCE;
        this.func_149647_a(GTCreativeTabs.TAB_GREGTECH_PIPES);
        this.setHarvestLevel("wirecutter", 1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected Pair<TextureAtlasSprite, Integer> getParticleTexture(World world, BlockPos blockPos) {
        return LaserPipeRenderer.INSTANCE.getParticleTexture((TileEntityLaserPipe)world.func_175625_s(blockPos));
    }

    @Override
    public Class<LaserPipeType> getPipeTypeClass() {
        return LaserPipeType.class;
    }

    @Override
    public WorldLaserPipeNet getWorldPipeNet(World world) {
        return WorldLaserPipeNet.getWorldPipeNet(world);
    }

    @Override
    public TileEntityPipeBase<LaserPipeType, LaserPipeProperties> createNewTileEntity(boolean supportsTicking) {
        return new TileEntityLaserPipe();
    }

    @Override
    public LaserPipeProperties createProperties(IPipeTile<LaserPipeType, LaserPipeProperties> pipeTile) {
        LaserPipeType pipeType = pipeTile.getPipeType();
        if (pipeType == null) {
            return this.getFallbackType();
        }
        return this.pipeType.modifyProperties(this.properties);
    }

    @Override
    public LaserPipeProperties createItemProperties(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemBlockLaserPipe) {
            ItemBlockLaserPipe pipe = (ItemBlockLaserPipe)item;
            return ((BlockLaserPipe)pipe.func_179223_d()).properties;
        }
        return null;
    }

    @Override
    public ItemStack getDropItem(IPipeTile<LaserPipeType, LaserPipeProperties> pipeTile) {
        return new ItemStack((Block)this, 1, this.pipeType.ordinal());
    }

    @Override
    protected LaserPipeProperties getFallbackType() {
        return LaserPipeProperties.INSTANCE;
    }

    @Override
    public LaserPipeType getItemPipeType(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemBlockLaserPipe) {
            ItemBlockLaserPipe pipe = (ItemBlockLaserPipe)item;
            return ((BlockLaserPipe)pipe.func_179223_d()).pipeType;
        }
        return null;
    }

    @Override
    public void setTileEntityData(TileEntityPipeBase<LaserPipeType, LaserPipeProperties> pipeTile, ItemStack itemStack) {
        pipeTile.setPipeData(this, this.pipeType);
    }

    @Override
    public void func_149666_a(@NotNull CreativeTabs itemIn, @NotNull NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, this.pipeType.ordinal()));
    }

    @Override
    protected boolean isPipeTool(@NotNull ItemStack stack) {
        return ToolHelper.isTool(stack, "wirecutter");
    }

    @Override
    public boolean canPipesConnect(IPipeTile<LaserPipeType, LaserPipeProperties> selfTile, EnumFacing side, IPipeTile<LaserPipeType, LaserPipeProperties> sideTile) {
        return selfTile instanceof TileEntityLaserPipe && sideTile instanceof TileEntityLaserPipe;
    }

    @Override
    public boolean canPipeConnectToBlock(IPipeTile<LaserPipeType, LaserPipeProperties> selfTile, EnumFacing side, @Nullable TileEntity tile) {
        return tile != null && tile.getCapability(GregtechTileCapabilities.CAPABILITY_LASER, side.func_176734_d()) != null;
    }

    @Override
    public boolean isHoldingPipe(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.func_184614_ca();
        return stack != ItemStack.field_190927_a && stack.func_77973_b() instanceof ItemBlockLaserPipe;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public EnumBlockRenderType func_149645_b(@NotNull IBlockState state) {
        return LaserPipeRenderer.INSTANCE.getBlockRenderType();
    }

    @Override
    public boolean canRenderInLayer(@NotNull IBlockState state, @NotNull BlockRenderLayer layer) {
        if (layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.CUTOUT) {
            return true;
        }
        return layer == BloomEffectUtil.getEffectiveBloomLayer();
    }
}

