/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.itempipe.longdistance;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.ItemHandlerDelegate;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.pipenet.longdist.ILDEndpoint;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.storage.MetaTileEntityLongDistanceEndpoint;
import gregtech.common.pipelike.itempipe.longdistance.LDItemPipeType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MetaTileEntityLDItemEndpoint
extends MetaTileEntityLongDistanceEndpoint {
    private static final ItemStackHandler DEFAULT_INVENTORY = new ItemStackHandler(1){

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }
    };

    public MetaTileEntityLDItemEndpoint(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, LDItemPipeType.INSTANCE);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityLDItemEndpoint(this.metaTileEntityId);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            Object t;
            EnumFacing outputFacing;
            TileEntity te;
            if (this.getWorld().field_72995_K || side != this.getFrontFacing() || !this.isInput()) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)DEFAULT_INVENTORY);
            }
            ILDEndpoint endpoint = this.getLink();
            if (endpoint != null && (te = endpoint.getNeighbor(outputFacing = endpoint.getOutputFacing())) != null && (t = te.getCapability(capability, outputFacing.func_176734_d())) != null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new ItemHandlerWrapper((IItemHandler)t));
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)DEFAULT_INVENTORY);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        IVertexOperation[] colouredPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
        Textures.VOLTAGE_CASINGS[1].render(renderState, translation, colouredPipeline);
        Textures.LD_ITEM_PIPE.renderOrientedState(renderState, translation, pipeline, this.frontFacing, false, false);
        Textures.PIPE_IN_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        Textures.ITEM_HATCH_INPUT_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        Textures.PIPE_OUT_OVERLAY.renderSided(this.getFrontFacing().func_176734_d(), renderState, translation, pipeline);
        Textures.ITEM_HATCH_OUTPUT_OVERLAY.renderSided(this.getFrontFacing().func_176734_d(), renderState, translation, pipeline);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.VOLTAGE_CASINGS[1].getParticleSprite(), (Object)0xFFFFFF);
    }

    public static class ItemHandlerWrapper
    extends ItemHandlerDelegate {
        public ItemHandlerWrapper(IItemHandler delegate) {
            super(delegate);
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }
    }
}

