/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.fluidpipe.tile;

import gregtech.api.GTValues;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.cover.Cover;
import gregtech.api.cover.CoverableView;
import gregtech.api.fluids.FluidState;
import gregtech.api.fluids.attribute.AttributedFluid;
import gregtech.api.fluids.attribute.FluidAttribute;
import gregtech.api.metatileentity.IDataInfoProvider;
import gregtech.api.unification.material.properties.FluidPipeProperties;
import gregtech.api.util.EntityDamageUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.covers.CoverPump;
import gregtech.common.pipelike.fluidpipe.net.PipeTankList;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipe;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityFluidPipeTickable
extends TileEntityFluidPipe
implements ITickable,
IDataInfoProvider {
    public byte lastReceivedFrom = 0;
    public byte oldLastReceivedFrom = 0;
    private PipeTankList pipeTankList;
    private final EnumMap<EnumFacing, PipeTankList> tankLists = new EnumMap(EnumFacing.class);
    private FluidTank[] fluidTanks;
    private long timer = 0L;
    private final int offset = GTValues.RNG.nextInt(20);

    public long getOffsetTimer() {
        return this.timer + (long)this.offset;
    }

    @Override
    @Nullable
    public <T> T getCapabilityInternal(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            PipeTankList tankList = this.getTankList(facing);
            if (tankList == null) {
                return null;
            }
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)tankList);
        }
        return super.getCapabilityInternal(capability, facing);
    }

    public void func_73660_a() {
        ++this.timer;
        this.getCoverableImplementation().update();
        if (!this.field_145850_b.field_72995_K && this.getOffsetTimer() % 5L == 0L) {
            this.lastReceivedFrom = (byte)(this.lastReceivedFrom & 0x3F);
            if (this.lastReceivedFrom == 63) {
                this.lastReceivedFrom = 0;
            }
            boolean shouldDistribute = this.oldLastReceivedFrom == this.lastReceivedFrom;
            int tanks = ((FluidPipeProperties)this.getNodeData()).getTanks();
            int j = GTValues.RNG.nextInt(tanks);
            for (int i = 0; i < tanks; ++i) {
                int index = (i + j) % tanks;
                FluidTank tank = this.getFluidTanks()[index];
                FluidStack fluid = tank.getFluid();
                if (fluid == null) continue;
                if (fluid.amount <= 0) {
                    tank.setFluid(null);
                    continue;
                }
                if (!shouldDistribute) continue;
                this.distributeFluid(index, tank, fluid);
                this.lastReceivedFrom = 0;
            }
            this.oldLastReceivedFrom = this.lastReceivedFrom;
        }
    }

    @Override
    public boolean supportsTicking() {
        return true;
    }

    private void distributeFluid(int channel, FluidTank tank, FluidStack fluid) {
        ArrayList<FluidTransaction> tanks = new ArrayList<FluidTransaction>();
        int amount = fluid.amount;
        FluidStack maxFluid = fluid.copy();
        double availableCapacity = 0.0;
        byte j = (byte)GTValues.RNG.nextInt(6);
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            CoverableView coverable;
            IFluidHandler fluidHandler;
            TileEntity neighbor;
            byte side = (byte)((i + j) % 6);
            EnumFacing facing = EnumFacing.field_82609_l[side];
            if (!this.isConnected(facing) || (this.lastReceivedFrom & 1 << side) != 0 || (neighbor = this.getNeighbor(facing)) == null || (fluidHandler = (IFluidHandler)neighbor.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) == null) continue;
            FluidTank pipeTank = tank;
            Cover cover = this.getCoverableImplementation().getCoverAtSide(facing);
            if (cover == null ? (coverable = (CoverableView)neighbor.getCapability(GregtechTileCapabilities.CAPABILITY_COVER_HOLDER, facing.func_176734_d())) != null && this.checkForPumpCover(cover = coverable.getCoverAtSide(facing.func_176734_d())) : (pipeTank = (IFluidHandler)cover.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, pipeTank)) == null || this.checkForPumpCover(cover)) continue;
            FluidStack drainable = pipeTank.drain(maxFluid, false);
            if (drainable == null || drainable.amount <= 0) continue;
            int filled = Math.min(fluidHandler.fill(maxFluid, false), drainable.amount);
            if (filled > 0) {
                tanks.add(new FluidTransaction(fluidHandler, (IFluidHandler)pipeTank, filled));
                availableCapacity += (double)filled;
            }
            maxFluid.amount = amount;
        }
        if (availableCapacity <= 0.0) {
            return;
        }
        double maxAmount = Math.min(this.getCapacityPerTank() / 2, fluid.amount);
        for (FluidTransaction transaction : tanks) {
            if (availableCapacity > maxAmount) {
                transaction.amount = (int)Math.floor((double)transaction.amount * maxAmount / availableCapacity);
            }
            if (transaction.amount == 0) {
                if (tank.getFluidAmount() <= 0) break;
                transaction.amount = 1;
            } else if (transaction.amount < 0) continue;
            FluidStack toInsert = fluid.copy();
            toInsert.amount = transaction.amount;
            int inserted = transaction.target.fill(toInsert, true);
            if (inserted <= 0) continue;
            transaction.pipeTank.drain(inserted, true);
        }
    }

    private boolean checkForPumpCover(@Nullable Cover cover) {
        if (cover instanceof CoverPump) {
            CoverPump coverPump = (CoverPump)cover;
            int pipeThroughput = ((FluidPipeProperties)this.getNodeData()).getThroughput() * 20;
            if (coverPump.getTransferRate() > pipeThroughput) {
                coverPump.setTransferRate(pipeThroughput);
            }
            return true;
        }
        return false;
    }

    public void checkAndDestroy(@NotNull FluidStack stack) {
        Fluid fluid = stack.getFluid();
        FluidPipeProperties prop = (FluidPipeProperties)this.getNodeData();
        boolean burning = prop.getMaxFluidTemperature() < fluid.getTemperature(stack);
        boolean leaking = !prop.isGasProof() && fluid.isGaseous(stack);
        boolean shattering = !prop.isCryoProof() && fluid.getTemperature() < 120;
        boolean corroding = false;
        boolean melting = false;
        if (fluid instanceof AttributedFluid) {
            AttributedFluid attributedFluid = (AttributedFluid)fluid;
            FluidState state = attributedFluid.getState();
            if (!prop.canContain(state)) {
                leaking = state == FluidState.GAS;
                boolean bl = melting = state == FluidState.PLASMA;
            }
            if (burning && state == FluidState.PLASMA && prop.canContain(FluidState.PLASMA)) {
                burning = false;
            }
            for (FluidAttribute attribute : attributedFluid.getAttributes()) {
                if (prop.canContain(attribute)) continue;
                corroding = true;
            }
        }
        if (burning || leaking || corroding || shattering || melting) {
            this.destroyPipe(stack, burning, leaking, corroding, shattering, melting);
        }
    }

    public void destroyPipe(FluidStack stack, boolean isBurning, boolean isLeaking, boolean isCorroding, boolean isShattering, boolean isMelting) {
        List entities;
        if (this.getOffsetTimer() % 10L == 0L) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        if (isLeaking) {
            TileEntityFluidPipe.spawnParticles(this.field_145850_b, this.field_174879_c, EnumFacing.UP, EnumParticleTypes.SMOKE_NORMAL, 7 + GTValues.RNG.nextInt(2));
            stack.amount = Math.max(0, stack.amount * 9 / 10);
            if (this.getOffsetTimer() % 20L == 0L) {
                entities = this.getPipeWorld().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.getPipePos()).func_186662_g(2.0));
                for (EntityLivingBase entityLivingBase : entities) {
                    EntityDamageUtil.applyTemperatureDamage(entityLivingBase, stack.getFluid().getTemperature(stack), 2.0f, 10);
                }
            }
            if (GTValues.RNG.nextInt(isBurning ? 3 : 7) == 0) {
                this.doExplosion(1.0f + GTValues.RNG.nextFloat());
            }
        }
        if (isCorroding) {
            TileEntityFluidPipe.spawnParticles(this.field_145850_b, this.field_174879_c, EnumFacing.UP, EnumParticleTypes.CRIT_MAGIC, 3 + GTValues.RNG.nextInt(2));
            stack.amount = Math.max(0, stack.amount * 3 / 4);
            if (this.getOffsetTimer() % 20L == 0L) {
                entities = this.getPipeWorld().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.getPipePos()).func_186662_g(1.0));
                for (EntityLivingBase entityLivingBase : entities) {
                    EntityDamageUtil.applyChemicalDamage(entityLivingBase, 2);
                }
            }
            if (GTValues.RNG.nextInt(10) == 0) {
                stack.amount = 0;
                this.field_145850_b.func_175698_g(this.field_174879_c);
            }
        }
        if (isBurning || isMelting) {
            TileEntityFluidPipe.spawnParticles(this.field_145850_b, this.field_174879_c, EnumFacing.UP, EnumParticleTypes.FLAME, (isMelting ? 7 : 3) + GTValues.RNG.nextInt(2));
            stack.amount = Math.max(0, stack.amount / 4);
            if (GTValues.RNG.nextInt(4) == 0) {
                TileEntityFluidPipe.setNeighboursToFire(this.field_145850_b, this.field_174879_c);
            }
            if (isMelting && this.getOffsetTimer() % 20L == 0L) {
                entities = this.getPipeWorld().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.getPipePos()).func_186662_g(2.0));
                for (EntityLivingBase entityLivingBase : entities) {
                    EntityDamageUtil.applyTemperatureDamage(entityLivingBase, stack.getFluid().getTemperature(stack), 2.0f, 10);
                }
            }
            if (GTValues.RNG.nextInt(10) == 0) {
                stack.amount = 0;
                this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150480_ab.func_176223_P());
            }
        }
        if (isShattering) {
            TileEntityFluidPipe.spawnParticles(this.field_145850_b, this.field_174879_c, EnumFacing.UP, EnumParticleTypes.CLOUD, 3 + GTValues.RNG.nextInt(2));
            stack.amount = Math.max(0, stack.amount / 4);
            if (this.getOffsetTimer() % 20L == 0L) {
                entities = this.getPipeWorld().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.getPipePos()).func_186662_g(2.0));
                for (EntityLivingBase entityLivingBase : entities) {
                    EntityDamageUtil.applyTemperatureDamage(entityLivingBase, stack.getFluid().getTemperature(stack), 2.0f, 10);
                }
            }
            if (GTValues.RNG.nextInt(10) == 0) {
                stack.amount = 0;
                this.field_145850_b.func_175698_g(this.field_174879_c);
            }
        }
    }

    private IFluidHandler getFluidHandlerAt(EnumFacing facing, EnumFacing oppositeSide) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        if (tile == null) {
            return null;
        }
        return (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, oppositeSide);
    }

    public void receivedFrom(EnumFacing facing) {
        if (facing != null) {
            this.lastReceivedFrom = (byte)(this.lastReceivedFrom | 1 << facing.func_176745_a());
        }
    }

    public FluidStack getContainedFluid(int channel) {
        if (channel < 0 || channel >= this.getFluidTanks().length) {
            return null;
        }
        return this.getFluidTanks()[channel].getFluid();
    }

    private void createTanksList() {
        this.fluidTanks = new FluidTank[((FluidPipeProperties)this.getNodeData()).getTanks()];
        for (int i = 0; i < ((FluidPipeProperties)this.getNodeData()).getTanks(); ++i) {
            this.fluidTanks[i] = new FluidTank(this.getCapacityPerTank());
        }
        this.pipeTankList = new PipeTankList(this, null, this.fluidTanks);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.tankLists.put(facing, new PipeTankList(this, facing, this.fluidTanks));
        }
    }

    public PipeTankList getTankList() {
        if (this.pipeTankList == null || this.fluidTanks == null) {
            this.createTanksList();
        }
        return this.pipeTankList;
    }

    public PipeTankList getTankList(EnumFacing facing) {
        if (this.tankLists.isEmpty() || this.fluidTanks == null) {
            this.createTanksList();
        }
        return this.tankLists.getOrDefault(facing, this.pipeTankList);
    }

    public FluidTank[] getFluidTanks() {
        if (this.pipeTankList == null || this.fluidTanks == null) {
            this.createTanksList();
        }
        return this.fluidTanks;
    }

    public FluidStack[] getContainedFluids() {
        FluidStack[] fluids = new FluidStack[this.getFluidTanks().length];
        for (int i = 0; i < fluids.length; ++i) {
            fluids[i] = this.fluidTanks[i].getFluid();
        }
        return fluids;
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.getFluidTanks().length; ++i) {
            FluidStack stack1 = this.getContainedFluid(i);
            NBTTagCompound fluidTag = new NBTTagCompound();
            if (stack1 == null || stack1.amount <= 0) {
                fluidTag.func_74757_a("isNull", true);
            } else {
                stack1.writeToNBT(fluidTag);
            }
            list.func_74742_a((NBTBase)fluidTag);
        }
        nbt.func_74782_a("Fluids", (NBTBase)list);
        return nbt;
    }

    @Override
    public void func_145839_a(@NotNull NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = (NBTTagList)nbt.func_74781_a("Fluids");
        this.createTanksList();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            if (tag.func_74767_n("isNull")) continue;
            this.fluidTanks[i].setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag));
        }
    }

    @Override
    @NotNull
    public List<ITextComponent> getDataInfo() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        FluidStack[] fluids = this.getContainedFluids();
        if (fluids != null) {
            boolean allTanksEmpty = true;
            for (int i = 0; i < fluids.length; ++i) {
                if (fluids[i] == null || fluids[i].getFluid() == null) continue;
                allTanksEmpty = false;
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.tank", new Object[]{i, new TextComponentTranslation(TextFormattingUtil.formatNumbers(fluids[i].amount), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), new TextComponentTranslation(TextFormattingUtil.formatNumbers(this.getCapacityPerTank()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)), new TextComponentTranslation(fluids[i].getFluid().getLocalizedName(fluids[i]), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD))}));
            }
            if (allTanksEmpty) {
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.tanks_empty", new Object[0]));
            }
        }
        return list;
    }

    private static class FluidTransaction {
        public final IFluidHandler target;
        public final IFluidHandler pipeTank;
        public int amount;

        private FluidTransaction(IFluidHandler target, IFluidHandler pipeTank, int amount) {
            this.target = target;
            this.pipeTank = pipeTank;
            this.amount = amount;
        }
    }
}

