/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.fluidpipe.longdistance;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.FluidHandlerDelegate;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.pipenet.longdist.ILDEndpoint;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.storage.MetaTileEntityLongDistanceEndpoint;
import gregtech.common.pipelike.fluidpipe.longdistance.LDFluidPipeType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityLDFluidEndpoint
extends MetaTileEntityLongDistanceEndpoint {
    private static final FluidTank DEFAULT_TANK = new FluidTank(10000){

        public int fill(FluidStack resource, boolean doFill) {
            return 0;
        }

        @Nullable
        public FluidStack drainInternal(int maxDrain, boolean doDrain) {
            return null;
        }
    };

    public MetaTileEntityLDFluidEndpoint(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, LDFluidPipeType.INSTANCE);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityLDFluidEndpoint(this.metaTileEntityId);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            Object t;
            EnumFacing outputFacing;
            TileEntity te;
            if (this.getWorld().field_72995_K || side != this.getFrontFacing() || !this.isInput()) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)DEFAULT_TANK);
            }
            ILDEndpoint endpoint = this.getLink();
            if (endpoint != null && (te = endpoint.getNeighbor(outputFacing = endpoint.getOutputFacing())) != null && (t = te.getCapability(capability, outputFacing.func_176734_d())) != null) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper((IFluidHandler)t));
            }
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)DEFAULT_TANK);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        IVertexOperation[] colouredPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
        Textures.VOLTAGE_CASINGS[1].render(renderState, translation, colouredPipeline);
        Textures.LD_FLUID_PIPE.renderOrientedState(renderState, translation, pipeline, this.frontFacing, false, false);
        Textures.PIPE_IN_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        Textures.FLUID_HATCH_INPUT_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        Textures.PIPE_OUT_OVERLAY.renderSided(this.getOutputFacing(), renderState, translation, pipeline);
        Textures.FLUID_HATCH_OUTPUT_OVERLAY.renderSided(this.getOutputFacing(), renderState, translation, pipeline);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.VOLTAGE_CASINGS[1].getParticleSprite(), (Object)0xFFFFFF);
    }

    private static class FluidHandlerWrapper
    extends FluidHandlerDelegate {
        public FluidHandlerWrapper(@NotNull IFluidHandler delegate) {
            super(delegate);
        }

        @Override
        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Override
        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }
}

