/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.fluidpipe;

import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.pipenet.block.material.ItemBlockMaterialPipe;
import gregtech.api.unification.material.properties.FluidPipeProperties;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.ConfigHolder;
import gregtech.common.pipelike.fluidpipe.BlockFluidPipe;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBlockFluidPipe
extends ItemBlockMaterialPipe<FluidPipeType, FluidPipeProperties> {
    public ItemBlockFluidPipe(BlockFluidPipe block) {
        super(block);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        FluidPipeProperties pipeProperties = (FluidPipeProperties)this.blockPipe.createItemProperties(stack);
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{pipeProperties.getThroughput()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.capacity", (Object[])new Object[]{pipeProperties.getThroughput() * 20}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.max_temperature", (Object[])new Object[]{pipeProperties.getMaxFluidTemperature()}));
        if (pipeProperties.getTanks() > 1) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.channels", (Object[])new Object[]{pipeProperties.getTanks()}));
        }
        pipeProperties.appendTooltips(tooltip, false, false);
        if (TooltipHelper.isShiftDown()) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.connect_and_block", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.crowbar", (Object[])new Object[0]));
        }
        BlockMaterialPipe blockMaterialPipe = (BlockMaterialPipe)this.blockPipe;
        if (ConfigHolder.misc.debug) {
            tooltip.add("MetaItem Id: " + blockMaterialPipe.getPrefix().name + blockMaterialPipe.getItemMaterial(stack).toCamelCaseString());
        }
    }
}

