/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.fluidpipe;

import com.google.common.base.Preconditions;
import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.FluidPipeProperties;
import gregtech.api.unification.material.registry.MaterialRegistry;
import gregtech.api.util.EntityDamageUtil;
import gregtech.client.renderer.pipe.FluidPipeRenderer;
import gregtech.client.renderer.pipe.PipeRenderer;
import gregtech.common.creativetab.GTCreativeTabs;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import gregtech.common.pipelike.fluidpipe.ItemBlockFluidPipe;
import gregtech.common.pipelike.fluidpipe.net.WorldFluidPipeNet;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipe;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipeTickable;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class BlockFluidPipe
extends BlockMaterialPipe<FluidPipeType, FluidPipeProperties, WorldFluidPipeNet> {
    private final SortedMap<Material, FluidPipeProperties> enabledMaterials = new TreeMap<Material, FluidPipeProperties>();

    public BlockFluidPipe(FluidPipeType pipeType, MaterialRegistry registry) {
        super(pipeType, registry);
        this.func_149647_a(GTCreativeTabs.TAB_GREGTECH_PIPES);
        this.setHarvestLevel("wrench", 1);
    }

    public void addPipeMaterial(Material material, FluidPipeProperties fluidPipeProperties) {
        Preconditions.checkNotNull((Object)material, (Object)"material");
        Preconditions.checkNotNull((Object)fluidPipeProperties, (String)"material %s fluidPipeProperties was null", (Object)material);
        Preconditions.checkArgument((material.getRegistry().func_177774_c(material) != null ? 1 : 0) != 0, (String)"material %s is not registered", (Object)material);
        this.enabledMaterials.put(material, fluidPipeProperties);
    }

    public Collection<Material> getEnabledMaterials() {
        return Collections.unmodifiableSet(this.enabledMaterials.keySet());
    }

    @Override
    public Class<FluidPipeType> getPipeTypeClass() {
        return FluidPipeType.class;
    }

    @Override
    public WorldFluidPipeNet getWorldPipeNet(World world) {
        return WorldFluidPipeNet.getWorldPipeNet(world);
    }

    @Override
    protected FluidPipeProperties createProperties(FluidPipeType fluidPipeType, Material material) {
        return fluidPipeType.modifyProperties(this.enabledMaterials.getOrDefault(material, this.getFallbackType()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    public PipeRenderer getPipeRenderer() {
        return FluidPipeRenderer.INSTANCE;
    }

    @Override
    protected FluidPipeProperties getFallbackType() {
        return this.enabledMaterials.values().iterator().next();
    }

    @Override
    public void func_149666_a(@NotNull CreativeTabs itemIn, @NotNull NonNullList<ItemStack> items) {
        for (Material material : this.enabledMaterials.keySet()) {
            items.add((Object)this.getItem(material));
        }
    }

    @Override
    public void func_180663_b(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public boolean canPipesConnect(IPipeTile<FluidPipeType, FluidPipeProperties> selfTile, EnumFacing side, IPipeTile<FluidPipeType, FluidPipeProperties> sideTile) {
        return selfTile instanceof TileEntityFluidPipe && sideTile instanceof TileEntityFluidPipe;
    }

    @Override
    public boolean canPipeConnectToBlock(IPipeTile<FluidPipeType, FluidPipeProperties> selfTile, EnumFacing side, TileEntity tile) {
        return tile != null && tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d()) != null;
    }

    @Override
    public boolean isHoldingPipe(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.func_184614_ca();
        return stack != ItemStack.field_190927_a && stack.func_77973_b() instanceof ItemBlockFluidPipe;
    }

    @Override
    public void func_180634_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Entity entityIn) {
        super.func_180634_a(worldIn, pos, state, entityIn);
        if (worldIn.field_72995_K) {
            return;
        }
        IPipeTile pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        if (pipeTile == null) {
            return;
        }
        TileEntityFluidPipe pipe = (TileEntityFluidPipe)pipeTile;
        if (pipe instanceof TileEntityFluidPipeTickable && pipe.getFrameMaterial() == null && ((TileEntityFluidPipeTickable)pipe).getOffsetTimer() % 10L == 0L && entityIn instanceof EntityLivingBase) {
            if (((TileEntityFluidPipeTickable)pipe).getFluidTanks().length > 1) {
                int maxTemperature = Integer.MIN_VALUE;
                int minTemperature = Integer.MAX_VALUE;
                for (FluidTank tank : ((TileEntityFluidPipeTickable)pipe).getFluidTanks()) {
                    if (tank.getFluid() == null || tank.getFluid().amount <= 0) continue;
                    maxTemperature = Math.max(maxTemperature, tank.getFluid().getFluid().getTemperature(tank.getFluid()));
                    minTemperature = Math.min(minTemperature, tank.getFluid().getFluid().getTemperature(tank.getFluid()));
                }
                if (maxTemperature != Integer.MIN_VALUE) {
                    EntityDamageUtil.applyTemperatureDamage((EntityLivingBase)entityIn, maxTemperature, 1.0f, 5);
                }
                if (minTemperature != Integer.MAX_VALUE) {
                    EntityDamageUtil.applyTemperatureDamage((EntityLivingBase)entityIn, minTemperature, 1.0f, 5);
                }
            } else {
                FluidTank tank = ((TileEntityFluidPipeTickable)pipe).getFluidTanks()[0];
                if (tank.getFluid() != null && tank.getFluid().amount > 0) {
                    EntityDamageUtil.applyTemperatureDamage((EntityLivingBase)entityIn, tank.getFluid().getFluid().getTemperature(), 1.0f, 5);
                }
            }
        }
    }

    @Override
    public TileEntityPipeBase<FluidPipeType, FluidPipeProperties> createNewTileEntity(boolean supportsTicking) {
        return new TileEntityFluidPipeTickable();
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public EnumBlockRenderType func_149645_b(@NotNull IBlockState state) {
        return FluidPipeRenderer.INSTANCE.getBlockRenderType();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected Pair<TextureAtlasSprite, Integer> getParticleTexture(World world, BlockPos blockPos) {
        return FluidPipeRenderer.INSTANCE.getParticleTexture((IPipeTile)world.func_175625_s(blockPos));
    }
}

