/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.mui.widget.workbench;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.integration.jei.JeiIngredientProvider;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.widget.Widget;
import gregtech.api.mui.GTGuiTextures;
import gregtech.client.utils.RenderUtil;
import gregtech.common.metatileentities.storage.CraftingRecipeMemory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeMemorySlot
extends Widget<RecipeMemorySlot>
implements Interactable,
JeiIngredientProvider {
    private final CraftingRecipeMemory memory;
    private final int index;

    public RecipeMemorySlot(CraftingRecipeMemory memory, int index) {
        this.memory = memory;
        this.index = index;
        this.tooltipAutoUpdate(true);
        this.tooltipBuilder(tooltip -> {
            CraftingRecipeMemory.MemorizedRecipe recipe = memory.getRecipeAtIndex(this.index);
            if (recipe == null) {
                return;
            }
            tooltip.addFromItem(recipe.getRecipeResult());
            tooltip.spaceLine(2);
            tooltip.addLine((IDrawable)IKey.lang((String)"gregtech.recipe_memory_widget.tooltip.1"));
            tooltip.addLine((IDrawable)IKey.lang((String)"gregtech.recipe_memory_widget.tooltip.2"));
            tooltip.addLine((IDrawable)IKey.lang((String)"gregtech.recipe_memory_widget.tooltip.3"));
            tooltip.addLine((IDrawable)IKey.lang((String)"gregtech.recipe_memory_widget.tooltip.0", (Object[])new Object[]{recipe.timesUsed}).style(TextFormatting.WHITE));
        });
    }

    public void draw(ModularGuiContext context, WidgetTheme widgetTheme) {
        ItemStack itemstack = this.memory.getRecipeOutputAtIndex(this.index);
        if (itemstack.func_190926_b()) {
            return;
        }
        int cachedCount = itemstack.func_190916_E();
        itemstack.func_190920_e(1);
        RenderUtil.renderItem(itemstack, 1, 1, 16.0f, 16.0f);
        itemstack.func_190920_e(cachedCount);
        if (this.memory.getRecipeAtIndex(this.index).isRecipeLocked()) {
            GlStateManager.func_179097_i();
            GTGuiTextures.RECIPE_LOCK.draw((GuiContext)context, 10, 1, 8, 8, widgetTheme);
            GlStateManager.func_179126_j();
        }
    }

    public void drawForeground(ModularGuiContext context) {
        RichTooltip tooltip = this.getTooltip();
        if (tooltip != null && this.isHoveringFor(tooltip.getShowUpTimer())) {
            tooltip.draw((GuiContext)this.getContext(), this.memory.getRecipeOutputAtIndex(this.index));
        }
    }

    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        CraftingRecipeMemory.MemorizedRecipe recipe = this.memory.getRecipeAtIndex(this.index);
        if (recipe == null) {
            return Interactable.Result.IGNORE;
        }
        MouseData data = MouseData.create((int)mouseButton);
        this.memory.syncToServer(2, buffer -> {
            buffer.writeByte(this.index);
            data.writeToPacket(buffer);
        });
        if (data.shift && data.mouseButton == 0) {
            recipe.setRecipeLocked(!recipe.isRecipeLocked());
        } else if (data.mouseButton == 1 && !recipe.isRecipeLocked()) {
            this.memory.removeRecipe(this.index);
        }
        return Interactable.Result.ACCEPT;
    }

    @Nullable
    public Object getIngredient() {
        if (!this.memory.hasRecipe(this.index)) {
            return null;
        }
        return this.memory.getRecipeOutputAtIndex(this.index);
    }
}

