/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.mui.widget.workbench;

import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.integration.jei.JeiIngredientProvider;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.modularui.widgets.slot.SlotGroup;
import com.google.common.collect.Lists;
import gregtech.client.utils.RenderUtil;
import gregtech.common.metatileentities.storage.CraftingRecipeLogic;
import gregtech.common.metatileentities.storage.CraftingRecipeMemory;
import gregtech.common.metatileentities.storage.MetaTileEntityWorkbench;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class CraftingOutputSlot
extends Widget<CraftingOutputSlot>
implements Interactable,
JeiIngredientProvider {
    private static final int MOUSE_CLICK = 2;
    private static final int SYNC_STACK = 5;
    private final CraftingSlotSH syncHandler;

    public CraftingOutputSlot(IntSyncValue amountCrafted, MetaTileEntityWorkbench workbench) {
        this.syncHandler = new CraftingSlotSH(amountCrafted, workbench);
        this.setSyncHandler(this.syncHandler);
        this.tooltipAutoUpdate(true);
        this.tooltipBuilder(tooltip -> {
            if (!this.isSynced()) {
                return;
            }
            ItemStack stack = this.syncHandler.getOutputStack();
            if (stack.func_190926_b()) {
                return;
            }
            tooltip.addFromItem(stack);
        });
    }

    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        return syncHandler instanceof CraftingSlotSH;
    }

    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        MouseData mouseData = MouseData.create((int)mouseButton);
        if (!this.getIngredient().func_190926_b()) {
            this.syncHandler.syncToServer(2, arg_0 -> ((MouseData)mouseData).writeToPacket(arg_0));
        }
        return Interactable.Result.SUCCESS;
    }

    public void draw(ModularGuiContext context, WidgetTheme widgetTheme) {
        ItemStack itemstack = this.syncHandler.getOutputStack();
        if (itemstack.func_190926_b()) {
            return;
        }
        RenderUtil.renderItem(itemstack, 1, 1, 16.0f, 16.0f);
    }

    public void drawForeground(ModularGuiContext context) {
        RichTooltip tooltip = this.getTooltip();
        if (tooltip != null && this.isHoveringFor(tooltip.getShowUpTimer())) {
            tooltip.draw((GuiContext)this.getContext(), this.syncHandler.getOutputStack());
        }
    }

    @NotNull
    public ItemStack getIngredient() {
        return this.syncHandler.getOutputStack();
    }

    protected static class CraftingSlotSH
    extends SyncHandler {
        private final CraftingRecipeLogic recipeLogic;
        private final CraftingOutputMS slot;
        private final List<ModularSlot> shiftClickSlots = new ArrayList<ModularSlot>();

        public CraftingSlotSH(IntSyncValue amountCrafted, MetaTileEntityWorkbench workbench) {
            this.slot = new CraftingOutputMS(amountCrafted, workbench);
            this.recipeLogic = this.slot.recipeLogic;
        }

        public void init(String key, PanelSyncManager syncManager) {
            super.init(key, syncManager);
            this.getSyncManager().getSlotGroups().stream().filter(SlotGroup::allowShiftTransfer).sorted(Comparator.comparingInt(SlotGroup::getShiftClickPriority)).collect(Collectors.toList()).forEach(slotGroup -> {
                for (Slot slot : slotGroup.getSlots()) {
                    if (!(slot instanceof ModularSlot)) continue;
                    ModularSlot modularSlot = (ModularSlot)slot;
                    this.shiftClickSlots.add(modularSlot);
                }
            });
        }

        public void readOnServer(int id, PacketBuffer buf) {
            if (id == 2) {
                EntityPlayer player = this.getSyncManager().getPlayer();
                ForgeHooks.setCraftingPlayer((EntityPlayer)player);
                MouseData data = MouseData.readPacket((PacketBuffer)buf);
                if (this.recipeLogic.isRecipeValid()) {
                    ItemStack outputStack = this.getOutputStack();
                    boolean hasSpace = data.shift ? this.quickTransfer(this.getOutputStack(), true) : this.slot.func_82869_a(player);
                    if (hasSpace && this.recipeLogic.performRecipe()) {
                        this.handleItemCraft(outputStack, player);
                        if (data.shift) {
                            ItemStack finalStack = outputStack.func_77946_l();
                            while (this.quickTransfer(finalStack, true) && finalStack.func_190916_E() < outputStack.func_77976_d() && this.recipeLogic.performRecipe()) {
                                finalStack.func_190920_e(finalStack.func_190916_E() + outputStack.func_190916_E());
                                this.handleItemCraft(outputStack, player);
                            }
                            this.quickTransfer(finalStack, false);
                        } else {
                            this.syncToClient(5, this::syncCursorStack);
                        }
                    }
                }
                ForgeHooks.setCraftingPlayer(null);
            }
        }

        private boolean insertStack(ItemStack fromStack, ModularSlot toSlot, boolean simulate) {
            ItemStack toStack = toSlot.func_75211_c().func_77946_l();
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)fromStack, (ItemStack)toStack)) {
                int maxSize;
                int combined = toStack.func_190916_E() + fromStack.func_190916_E();
                if (combined <= (maxSize = Math.min(toSlot.func_75219_a(), fromStack.func_77976_d()))) {
                    if (simulate) {
                        return true;
                    }
                    fromStack.func_190920_e(0);
                    toStack.func_190920_e(combined);
                    toSlot.func_75215_d(toStack);
                } else if (toStack.func_190916_E() < maxSize) {
                    if (simulate) {
                        return true;
                    }
                    fromStack.func_190918_g(maxSize - toStack.func_190916_E());
                    toStack.func_190920_e(maxSize);
                    toSlot.func_75215_d(toStack);
                }
                return fromStack.func_190926_b();
            }
            if (toStack.func_190926_b()) {
                if (simulate) {
                    return true;
                }
                int maxSize = Math.max(toSlot.func_75219_a(), fromStack.func_190916_E());
                toSlot.func_75215_d(fromStack.func_77979_a(maxSize));
                return fromStack.func_190926_b();
            }
            return false;
        }

        public boolean quickTransfer(ItemStack fromStack, boolean simulate) {
            ArrayList<ModularSlot> emptySlots = new ArrayList<ModularSlot>();
            for (ModularSlot toSlot : this.shiftClickSlots) {
                if (!toSlot.func_111238_b() || !toSlot.func_75214_a(fromStack)) continue;
                if (toSlot.func_75211_c().func_190926_b()) {
                    emptySlots.add(toSlot);
                    continue;
                }
                if (!this.insertStack(fromStack, toSlot, simulate) || !simulate && !fromStack.func_190926_b()) continue;
                return true;
            }
            for (ModularSlot emptySlot : emptySlots) {
                if (!this.insertStack(fromStack, emptySlot, simulate) || !simulate && !fromStack.func_190926_b()) continue;
                return true;
            }
            return false;
        }

        public void readOnClient(int id, PacketBuffer buf) {
            if (id == 5 && buf.readBoolean()) {
                this.getSyncManager().setCursorItem(NetworkUtils.readItemStack((PacketBuffer)buf));
            }
        }

        private void syncCursorStack(PacketBuffer buf) {
            ItemStack curStack = this.getSyncManager().getCursorItem();
            ItemStack outStack = this.slot.func_75211_c();
            if (this.slot.func_82869_a(this.getSyncManager().getPlayer())) {
                ItemStack toSync = outStack.func_77946_l();
                int combined = curStack.func_190916_E() + outStack.func_190916_E();
                toSync.func_190920_e(Math.min(combined, outStack.func_77976_d()));
                buf.writeBoolean(true);
                NetworkUtils.writeItemStack((PacketBuffer)buf, (ItemStack)toSync);
            } else {
                buf.writeBoolean(false);
            }
        }

        public ItemStack getOutputStack() {
            return this.slot.func_75211_c();
        }

        public void handleItemCraft(ItemStack craftedStack, EntityPlayer player) {
            craftedStack.func_77980_a(player.field_70170_p, player, 1);
            InventoryCrafting inventoryCrafting = this.recipeLogic.getCraftingMatrix();
            FMLCommonHandler.instance().firePlayerCraftingEvent(player, craftedStack, (IInventory)inventoryCrafting);
            IRecipe cachedRecipe = this.recipeLogic.getCachedRecipe();
            if (cachedRecipe != null) {
                if (!cachedRecipe.func_192399_d()) {
                    player.func_192021_a((List)Lists.newArrayList((Object[])new IRecipe[]{cachedRecipe}));
                }
                ItemStack resultStack = cachedRecipe.func_77572_b(inventoryCrafting);
                this.slot.notifyRecipePerformed(resultStack);
            }
        }
    }

    private static class InventoryWrapper
    implements IItemHandlerModifiable {
        private final IInventory inventory;
        private final CraftingRecipeLogic recipeLogic;

        private InventoryWrapper(IInventory inventory, CraftingRecipeLogic recipeLogic) {
            this.inventory = inventory;
            this.recipeLogic = recipeLogic;
        }

        public int getSlots() {
            return this.inventory.func_70302_i_();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.inventory.func_70301_a(slot).func_77946_l();
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.inventory.func_70301_a(slot);
        }

        public int getSlotLimit(int slot) {
            return this.inventory.func_70297_j_();
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            if (!this.recipeLogic.isRecipeValid()) {
                this.inventory.func_70299_a(slot, ItemStack.field_190927_a);
            }
            if (!stack.func_190926_b()) {
                this.inventory.func_70299_a(slot, stack);
            }
        }
    }

    protected static class CraftingOutputMS
    extends ModularSlot {
        private final IntSyncValue amountCrafted;
        private final CraftingRecipeLogic recipeLogic;
        private final CraftingRecipeMemory recipeMemory;
        private final IItemHandler craftingGrid;

        public CraftingOutputMS(IntSyncValue amountCrafted, MetaTileEntityWorkbench workbench) {
            super((IItemHandler)new InventoryWrapper(workbench.getCraftingRecipeLogic().getCraftingResultInventory(), workbench.getCraftingRecipeLogic()), 0, true);
            this.amountCrafted = amountCrafted;
            this.recipeLogic = workbench.getCraftingRecipeLogic();
            this.recipeMemory = workbench.getRecipeMemory();
            this.craftingGrid = workbench.getCraftingGrid();
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            ItemStack curStack = playerIn.field_71071_by.func_70445_o();
            if (curStack.func_190926_b()) {
                return true;
            }
            ItemStack outStack = this.func_75211_c();
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)curStack, (ItemStack)outStack)) {
                int combined = curStack.func_190916_E() + outStack.func_190916_E();
                return combined <= outStack.func_77976_d();
            }
            return false;
        }

        public void notifyRecipePerformed(ItemStack stack) {
            this.amountCrafted.setValue(Integer.valueOf(this.amountCrafted.getValue() + stack.func_190916_E()), true, true);
            this.recipeMemory.notifyRecipePerformed(this.craftingGrid, stack);
        }

        public void func_75215_d(@NotNull ItemStack stack) {
            super.func_75215_d(this.func_75211_c());
        }

        @NotNull
        public ItemStack func_75209_a(int amount) {
            return this.func_75211_c();
        }
    }
}

