/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.mui.widget.workbench;

import com.cleanroommc.modularui.api.widget.IGuiAction;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.integration.jei.JeiGhostIngredientSlot;
import com.cleanroommc.modularui.integration.jei.JeiIngredientProvider;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.slot.IOnSlotChanged;
import gregtech.api.util.GTUtility;
import gregtech.client.utils.RenderUtil;
import gregtech.common.metatileentities.storage.CraftingRecipeLogic;
import gregtech.common.mui.widget.workbench.CraftingOutputSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingInputSlot
extends Widget<CraftingOutputSlot>
implements Interactable,
JeiGhostIngredientSlot<ItemStack>,
JeiIngredientProvider {
    private final InputSyncHandler syncHandler;
    public boolean hasIngredients = true;
    private static boolean dragging = false;

    private CraftingInputSlot(IItemHandlerModifiable handler, int index) {
        this.syncHandler = new InputSyncHandler(handler, index);
        this.setSyncHandler(this.syncHandler);
        this.tooltipAutoUpdate(true);
        this.tooltipBuilder(tooltip -> {
            if (!this.isSynced()) {
                return;
            }
            ItemStack stack = this.syncHandler.getStack();
            if (stack.func_190926_b()) {
                return;
            }
            tooltip.addFromItem(stack);
        });
        this.listenGuiAction((IGuiAction)((IGuiAction.MouseDrag)(m, t) -> {
            if (this.isHovering() && dragging && this.syncHandler.isValid()) {
                ItemStack player = this.syncHandler.getSyncManager().getCursorItem();
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)player, (ItemStack)this.getStack())) {
                    this.syncHandler.syncStack();
                }
                return true;
            }
            return false;
        }));
        this.listenGuiAction((IGuiAction)((IGuiAction.MouseReleased)mouseButton -> {
            dragging = false;
            return true;
        }));
    }

    public static CraftingInputSlot create(CraftingRecipeLogic logic, IItemHandlerModifiable handler, int index) {
        CraftingInputSlot slot = new CraftingInputSlot(handler, index);
        logic.setInputSlot(slot, index);
        return slot;
    }

    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        return syncHandler instanceof InputSyncHandler;
    }

    public void onInit() {
        this.getContext().getJeiSettings().addJeiGhostIngredientSlot((IWidget)this);
    }

    public CraftingInputSlot changeListener(IOnSlotChanged listener) {
        this.syncHandler.listener = listener;
        return this;
    }

    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        if (!this.syncHandler.isValid() || dragging) {
            return Interactable.Result.IGNORE;
        }
        this.syncHandler.syncStack();
        return Interactable.Result.SUCCESS;
    }

    public void onMouseDrag(int mouseButton, long timeSinceClick) {
        if (!dragging && timeSinceClick > 100L) {
            dragging = true;
        }
    }

    public void draw(ModularGuiContext context, WidgetTheme widgetTheme) {
        ItemStack itemstack = this.syncHandler.getStack();
        if (!itemstack.func_190926_b()) {
            if (!this.hasIngredients) {
                RenderUtil.renderRect(0.0f, 0.0f, 18.0f, 18.0f, 200.0f, -2130771968);
            }
            RenderUtil.renderItem(itemstack, 1, 1, 16.0f, 16.0f);
        }
        RenderUtil.handleJeiGhostHighlight((IWidget)this);
    }

    public void drawForeground(ModularGuiContext context) {
        RichTooltip tooltip = this.getTooltip();
        if (tooltip != null && this.isHoveringFor(tooltip.getShowUpTimer())) {
            tooltip.draw((GuiContext)this.getContext(), this.syncHandler.getStack());
        }
    }

    public void setGhostIngredient(@NotNull ItemStack ingredient) {
        this.syncHandler.setStack(ingredient, true);
    }

    @Nullable
    public ItemStack castGhostIngredientIfValid(@NotNull Object ingredient) {
        return this.areAncestorsEnabled() && ingredient instanceof ItemStack ? (ItemStack)ingredient : null;
    }

    @NotNull
    public ItemStack getIngredient() {
        return this.getStack();
    }

    public ItemStack getStack() {
        return this.syncHandler.getStack();
    }

    public int getIndex() {
        return this.syncHandler.index;
    }

    public void setStack(ItemStack stack) {
        this.syncHandler.setStack(stack, true);
    }

    protected static class InputSyncHandler
    extends SyncHandler {
        public static final int SLOT_CHANGED = 1;
        private final IItemHandlerModifiable handler;
        private final int index;
        private ItemStack lastStoredItem;
        private IOnSlotChanged listener = IOnSlotChanged.DEFAULT;

        public InputSyncHandler(IItemHandlerModifiable handler, int index) {
            this.handler = handler;
            this.index = index;
        }

        public void init(String key, PanelSyncManager syncHandler) {
            super.init(key, syncHandler);
            this.lastStoredItem = this.getStack().func_77946_l();
        }

        public void readOnClient(int id, PacketBuffer buf) {
            if (id == 1) {
                ItemStack stack = NetworkUtils.readItemStack((PacketBuffer)buf);
                this.setStack(stack, false);
            }
        }

        public void readOnServer(int id, PacketBuffer buf) {
            if (id == 1) {
                ItemStack stack = NetworkUtils.readItemStack((PacketBuffer)buf);
                this.setStack(stack, false);
            }
        }

        public void detectAndSendChanges(boolean init) {
            ItemStack itemStack = this.getStack();
            if (itemStack.func_190926_b() && this.lastStoredItem.func_190926_b()) {
                return;
            }
            if (init || !ItemHandlerHelper.canItemStacksStack((ItemStack)this.lastStoredItem, (ItemStack)itemStack)) {
                this.listener.onChange(itemStack, false, false, init);
                this.lastStoredItem = itemStack.func_190926_b() ? ItemStack.field_190927_a : itemStack.func_77946_l();
                this.syncToClient(1, buffer -> NetworkUtils.writeItemStack((PacketBuffer)buffer, (ItemStack)itemStack));
            }
        }

        public void syncStack() {
            ItemStack cursorStack = GTUtility.copy(1, this.getSyncManager().getCursorItem());
            this.setStack(cursorStack, true);
        }

        public ItemStack getStack() {
            return this.handler.getStackInSlot(this.index);
        }

        public void setStack(ItemStack stack, boolean sync) {
            ItemStack old = this.getStack();
            boolean onlyAmt = ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)stack, (ItemStack)old);
            this.handler.setStackInSlot(this.index, stack);
            this.listener.onChange(stack, onlyAmt, this.getSyncManager().isClient(), false);
            if (sync) {
                this.syncToServer(1, buffer -> NetworkUtils.writeItemStack((PacketBuffer)buffer, (ItemStack)this.getStack()));
            }
        }
    }
}

