/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.mui.widget.orefilter;

import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.widgets.ItemSlot;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.util.function.BooleanConsumer;
import gregtech.api.util.oreglob.OreGlob;
import gregtech.common.covers.filter.oreglob.impl.ImpossibleOreGlob;
import gregtech.common.mui.widget.orefilter.ItemOreFilterTestSlot;
import it.unimi.dsi.fastutil.objects.Object2BooleanAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class OreFilterTestSlot
extends ItemSlot {
    private final ItemOreFilterTestSlot slot;
    private Supplier<OreGlob> globSupplier = ImpossibleOreGlob::getInstance;
    @Nullable
    private BooleanConsumer onMatchChange;
    private final Object2BooleanMap<String> testResult = new Object2BooleanAVLTreeMap();
    private MatchType matchType = MatchType.INVALID;
    private boolean matchSuccess;
    private boolean matchAll;

    public OreFilterTestSlot() {
        this.slot = new ItemOreFilterTestSlot();
        this.slot.setParent(this);
        this.slot(this.slot);
        this.tooltipBuilder(tooltip -> {
            List<Object> list;
            if (!this.isEnabled()) {
                return;
            }
            switch (this.matchType) {
                case NO_ORE_DICT_MATCH: {
                    list = Collections.singletonList(IKey.lang((String)(this.matchSuccess ? "cover.ore_dictionary_filter.test_slot.no_oredict.matches" : "cover.ore_dictionary_filter.test_slot.no_oredict.matches_not")));
                    break;
                }
                case ORE_DICT_MATCH: {
                    list = this.testResult.object2BooleanEntrySet().stream().map(e -> IKey.lang((String)(e.getBooleanValue() ? "cover.ore_dictionary_filter.test_slot.matches" : "cover.ore_dictionary_filter.test_slot.matches_not"), (Object[])new Object[]{e.getKey()})).collect(Collectors.toList());
                    break;
                }
                default: {
                    list = Collections.singletonList(IKey.lang((String)"cover.ore_dictionary_filter.test_slot.info"));
                }
            }
            tooltip.addDrawableLines(list);
        });
    }

    public OreFilterTestSlot setGlobSupplier(Supplier<OreGlob> supplier) {
        this.globSupplier = supplier;
        this.updatePreview();
        return this.getThis();
    }

    public OreFilterTestSlot getThis() {
        return this;
    }

    public boolean isMatchSuccess() {
        return this.matchSuccess;
    }

    public OreFilterTestSlot onMatchChange(@Nullable BooleanConsumer onMatchChange) {
        this.onMatchChange = onMatchChange;
        return this.getThis();
    }

    public void setMatchAll(boolean matchAll) {
        if (this.matchAll == matchAll) {
            return;
        }
        this.matchAll = matchAll;
        this.updatePreview();
    }

    public void updatePreview() {
        Set<String> oreDicts = this.getTestCandidates();
        this.testResult.clear();
        if (oreDicts == null) {
            this.matchType = MatchType.INVALID;
            this.updateAndNotifyMatchSuccess(false);
            return;
        }
        OreGlob glob = this.globSupplier.get();
        int success = 0;
        if (oreDicts.isEmpty()) {
            this.testResult.put((Object)"", glob != null && glob.matches(""));
            this.matchType = MatchType.NO_ORE_DICT_MATCH;
        } else {
            for (String oreDict : oreDicts) {
                boolean matches;
                boolean bl = matches = glob != null && glob.matches(oreDict);
                if (matches) {
                    ++success;
                }
                this.testResult.put((Object)oreDict, matches);
            }
            this.matchType = MatchType.ORE_DICT_MATCH;
        }
        this.updateAndNotifyMatchSuccess(this.matchAll ? success == this.testResult.size() : success > 0);
        this.tooltip().markDirty();
    }

    public void draw(ModularGuiContext context, WidgetTheme widgetTheme) {
        super.draw(context, widgetTheme);
        if (this.matchSuccess) {
            GTGuiTextures.OREDICT_MATCH.draw((GuiContext)context, 12, -2, 9, 6, widgetTheme);
        } else if (this.testResult.size() > 0) {
            GTGuiTextures.OREDICT_NO_MATCH.draw((GuiContext)context, 12, -3, 7, 7, widgetTheme);
        }
    }

    private void updateAndNotifyMatchSuccess(boolean newValue) {
        if (this.matchSuccess == newValue) {
            return;
        }
        this.matchSuccess = newValue;
        if (this.onMatchChange != null) {
            this.onMatchChange.apply(newValue);
        }
    }

    @Nullable
    protected Set<String> getTestCandidates() {
        return this.slot.func_75211_c().func_190926_b() ? null : OreDictUnifier.getOreDictionaryNames(this.slot.func_75211_c());
    }

    private static enum MatchType {
        NO_ORE_DICT_MATCH,
        ORE_DICT_MATCH,
        INVALID;

    }
}

