/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.mui.widget;

import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.drawable.IHoverable;
import com.cleanroommc.modularui.api.drawable.IRichTextBuilder;
import com.cleanroommc.modularui.api.layout.IViewport;
import com.cleanroommc.modularui.api.layout.IViewportStack;
import com.cleanroommc.modularui.api.widget.IGuiAction;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.Stencil;
import com.cleanroommc.modularui.drawable.text.RichText;
import com.cleanroommc.modularui.drawable.text.TextRenderer;
import com.cleanroommc.modularui.integration.jei.JeiIngredientProvider;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.utils.HoveredWidgetList;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widget.scroll.ScrollArea;
import com.cleanroommc.modularui.widget.scroll.ScrollData;
import com.cleanroommc.modularui.widget.sizer.Area;
import gregtech.api.mui.IconAcessor;
import java.awt.Rectangle;
import java.util.function.Consumer;
import net.minecraft.client.gui.FontRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollableTextWidget
extends Widget<ScrollableTextWidget>
implements IRichTextBuilder<ScrollableTextWidget>,
Interactable,
IViewport,
JeiIngredientProvider {
    private final RichText text = new RichText();
    private Consumer<RichText> builder;
    private boolean dirty = false;
    private boolean autoUpdate = false;
    private Object lastIngredient;
    private final ScrollArea scroll = new ScrollArea();
    private final TextRenderer renderer = new TextRenderer();

    public ScrollableTextWidget() {
        this.listenGuiAction((IGuiAction)((IGuiAction.MouseReleased)mouseButton -> {
            this.scroll.mouseReleased((GuiContext)this.getContext());
            return false;
        }));
    }

    public void onInit() {
        this.scroll.setScrollData(ScrollData.of((GuiAxis)GuiAxis.Y));
    }

    public void onUpdate() {
        super.onUpdate();
        this.scroll.drag(this.getContext().getAbsMouseX(), this.getContext().getAbsMouseY());
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void drawForeground(ModularGuiContext context) {
        IconAcessor accessor;
        Object object;
        super.drawForeground(context);
        Object object2 = this.getHoveredElement();
        if (object2 instanceof IHoverable) {
            IHoverable hoverable = (IHoverable)object2;
            hoverable.onHover();
            RichTooltip tooltip = hoverable.getTooltip();
            if (tooltip != null) {
                tooltip.draw((GuiContext)context);
            }
        }
        if ((object = this.getHoveredElement()) instanceof IconAcessor && (object = (accessor = (IconAcessor)object).gregTech$getDrawable()) instanceof JeiIngredientProvider) {
            JeiIngredientProvider provider = (JeiIngredientProvider)object;
            this.lastIngredient = provider.getIngredient();
        } else {
            this.lastIngredient = null;
        }
    }

    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        ModularGuiContext context = this.getContext();
        if (this.scroll.mouseClicked((GuiContext)context)) {
            return Interactable.Result.STOP;
        }
        Object object = this.getHoveredElement();
        if (object instanceof Interactable) {
            Interactable interactable = (Interactable)object;
            return interactable.onMousePressed(mouseButton);
        }
        return Interactable.Result.ACCEPT;
    }

    public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
        if (this.scroll.mouseScroll((GuiContext)this.getContext())) {
            return true;
        }
        Object object = this.getHoveredElement();
        if (object instanceof Interactable) {
            Interactable interactable = (Interactable)object;
            return interactable.onMouseScroll(scrollDirection, amount);
        }
        return false;
    }

    public boolean onMouseRelease(int mouseButton) {
        this.scroll.mouseReleased((GuiContext)this.getContext());
        Object object = this.getHoveredElement();
        if (object instanceof Interactable) {
            Interactable interactable = (Interactable)object;
            return interactable.onMouseRelease(mouseButton);
        }
        return false;
    }

    @Nullable
    public Object getHoveredElement() {
        if (!this.isHovering()) {
            return null;
        }
        FontRenderer fr = this.getContext().getFontRenderer();
        int x = this.getContext().getMouseX();
        int y = this.getContext().getMouseY();
        return this.text.getHoveringElement(fr, x, y + this.getScrollY());
    }

    public Area getArea() {
        return this.getScrollArea();
    }

    public ScrollArea getScrollArea() {
        return this.scroll;
    }

    public void transformChildren(IViewportStack stack) {
        stack.translate(0.0f, (float)(-this.getScrollY()));
    }

    public void getSelfAt(IViewportStack stack, HoveredWidgetList widgets, int x, int y) {
        if (this.isInside(stack, x, y)) {
            widgets.add((IWidget)this, stack.peek());
        }
    }

    public void getWidgetsAt(IViewportStack stack, HoveredWidgetList widgets, int x, int y) {
    }

    public void onResized() {
        this.scroll.getScrollY().clamp(this.scroll);
    }

    public boolean canHover() {
        return super.canHover() || this.scroll.isInsideScrollbarArea(this.getContext().getMouseX(), this.getContext().getMouseY());
    }

    public void preDraw(ModularGuiContext context, boolean transformed) {
        if (!transformed) {
            Stencil.applyAtZero((Rectangle)this.scroll, (GuiContext)context);
        } else {
            this.drawText(context);
        }
    }

    private void drawText(ModularGuiContext context) {
        if (this.autoUpdate || this.dirty) {
            if (this.builder != null) {
                this.text.clearText();
                this.builder.accept(this.text);
            }
            this.dirty = false;
        }
        this.text.setupRenderer(this.renderer, this.getArea().getPadding().left, this.getArea().getPadding().top - this.getScrollY(), (float)this.getArea().paddedWidth(), (float)this.getArea().paddedHeight(), this.getWidgetTheme(context.getTheme()).getTextColor(), this.getWidgetTheme(context.getTheme()).getTextShadow());
        this.text.compileAndDraw(this.renderer, (GuiContext)context, false);
        int diff = (int)Math.ceil((this.renderer.getLastHeight() - (float)this.getArea().h()) / 2.0f);
        this.scroll.getScrollY().setScrollSize(this.getArea().h() + Math.max(0, diff));
    }

    public void postDraw(ModularGuiContext context, boolean transformed) {
        if (!transformed) {
            Stencil.remove();
            this.scroll.drawScrollbar();
        }
    }

    public int getScrollY() {
        return this.scroll.getScrollY() != null ? this.scroll.getScrollY().getScroll() : 0;
    }

    public IRichTextBuilder<?> getRichText() {
        return this.text;
    }

    public ScrollableTextWidget autoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
        return this;
    }

    public ScrollableTextWidget textBuilder(Consumer<RichText> builder) {
        this.builder = builder;
        this.markDirty();
        return this;
    }

    @Nullable
    public Object getIngredient() {
        return this.lastIngredient;
    }
}

