/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.mui.widget;

import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widgets.TextWidget;
import gregtech.api.util.virtualregistry.VirtualEntry;
import java.util.function.Consumer;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class InteractableText<T extends VirtualEntry>
extends TextWidget
implements Interactable {
    private final T entry;
    private final EntryColorSH syncHandler;

    public InteractableText(T entry, Consumer<String> setter) {
        super((IKey)IKey.str((String)((VirtualEntry)entry).getColorStr()).alignment(Alignment.CenterLeft).color(Integer.valueOf(Color.WHITE.darker(1))));
        this.entry = entry;
        this.syncHandler = new EntryColorSH(setter);
        this.setSyncHandler(this.syncHandler);
    }

    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        Interactable.playButtonClickSound();
        this.syncHandler.setColor(((VirtualEntry)this.entry).getColorStr());
        this.syncHandler.syncToServer(1, buf -> NetworkUtils.writeStringSafe((PacketBuffer)buf, (String)((VirtualEntry)this.entry).getColorStr()));
        return Interactable.Result.SUCCESS;
    }

    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        return syncHandler instanceof EntryColorSH;
    }

    private static class EntryColorSH
    extends SyncHandler {
        private final Consumer<String> setter;

        private EntryColorSH(Consumer<String> setter) {
            this.setter = setter;
        }

        public void setColor(String c) {
            this.setter.accept(c);
        }

        public void readOnClient(int id, PacketBuffer buf) {
        }

        public void readOnServer(int id, PacketBuffer buf) {
            if (id == 1) {
                this.setColor(NetworkUtils.readStringSafe((PacketBuffer)buf));
            }
        }
    }
}

