/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.mui.widget;

import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.value.sync.StringSyncValue;
import com.cleanroommc.modularui.widgets.textfield.TextFieldHandler;
import com.cleanroommc.modularui.widgets.textfield.TextFieldRenderer;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;

public class HighlightedTextField
extends TextFieldWidget {
    private StringSyncValue stringSyncValue;
    private final TextHighlighter highlighter;
    private Runnable onUnfocus;

    public HighlightedTextField() {
        this.highlighter = new TextHighlighter(this.handler);
        this.renderer = this.highlighter;
        this.handler.setRenderer(this.renderer);
    }

    public void afterInit() {
        this.highlighter.runHighlighter(this.getText());
    }

    public HighlightedTextField setHighlightRule(Function<String, String> highlightRule) {
        this.highlighter.setHighlightRule(highlightRule);
        return this.getThis();
    }

    public HighlightedTextField value(IStringValue<?> stringValue) {
        this.stringSyncValue = (StringSyncValue)stringValue;
        super.value(stringValue);
        return this.getThis();
    }

    public HighlightedTextField getThis() {
        return this;
    }

    public void onRemoveFocus(ModularGuiContext context) {
        super.onRemoveFocus(context);
        this.highlighter.runHighlighter(this.getText());
        if (this.isSynced()) {
            this.stringSyncValue.setStringValue(this.getText(), true, true);
        }
        this.onUnfocus.run();
    }

    public HighlightedTextField onUnfocus(Runnable onUnfocus) {
        this.onUnfocus = onUnfocus;
        return this.getThis();
    }

    public static final class TextHighlighter
    extends TextFieldRenderer {
        private Function<String, String> highlightRule = string -> string;
        private final Map<String, String> cacheMap = new Object2ObjectOpenHashMap();

        public TextHighlighter(TextFieldHandler handler) {
            super(handler);
        }

        public void setHighlightRule(Function<String, String> highlightRule) {
            this.highlightRule = highlightRule;
        }

        protected void draw(String text, float x, float y) {
            super.draw(this.cacheMap.getOrDefault(text, text), x, y);
        }

        public void runHighlighter(String text) {
            if (this.highlightRule == null) {
                return;
            }
            this.cacheMap.computeIfAbsent(text, this.highlightRule);
        }
    }
}

