/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.mui.widget;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.text.TextRenderer;
import com.cleanroommc.modularui.integration.jei.JeiGhostIngredientSlot;
import com.cleanroommc.modularui.integration.jei.JeiIngredientProvider;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetSlotTheme;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.utils.NumberFormat;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.Widget;
import gregtech.api.mui.sync.GTFluidSyncHandler;
import gregtech.api.util.GTUtility;
import gregtech.client.utils.RenderUtil;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GTFluidSlot
extends Widget<GTFluidSlot>
implements Interactable,
JeiIngredientProvider,
JeiGhostIngredientSlot<FluidStack> {
    private final TextRenderer textRenderer = new TextRenderer();
    private GTFluidSyncHandler syncHandler;
    private boolean disableBackground = false;

    public GTFluidSlot() {
        this.tooltip().setAutoUpdate(true).titleMargin();
        this.tooltipBuilder(tooltip -> {
            if (!this.isSynced()) {
                return;
            }
            this.syncHandler.handleTooltip((RichTooltip)tooltip);
        });
    }

    public static GTFluidSyncHandler sync(IFluidTank tank) {
        return new GTFluidSyncHandler(tank);
    }

    public void onInit() {
        this.textRenderer.setShadow(true);
        this.textRenderer.setScale(0.5f);
        this.textRenderer.setColor(Color.WHITE.main);
        if (this.syncHandler.canLockFluid() || this.syncHandler.isPhantom()) {
            this.getContext().getJeiSettings().addJeiGhostIngredientSlot((IWidget)this);
        }
    }

    public GTFluidSlot syncHandler(IFluidTank fluidTank) {
        return this.syncHandler(GTFluidSlot.sync(fluidTank));
    }

    public GTFluidSlot syncHandler(GTFluidSyncHandler syncHandler) {
        this.setSyncHandler(syncHandler);
        this.syncHandler = syncHandler;
        return this;
    }

    public GTFluidSlot disableBackground() {
        this.disableBackground = true;
        return this;
    }

    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        return syncHandler instanceof GTFluidSyncHandler;
    }

    public void drawBackground(ModularGuiContext context, WidgetTheme widgetTheme) {
        if (this.disableBackground) {
            return;
        }
        super.drawBackground(context, widgetTheme);
    }

    public void draw(ModularGuiContext context, WidgetTheme widgetTheme) {
        if (widgetTheme instanceof WidgetSlotTheme) {
            WidgetSlotTheme slotTheme = (WidgetSlotTheme)widgetTheme;
            this.draw(context, slotTheme);
        }
    }

    public void draw(ModularGuiContext context, WidgetSlotTheme widgetTheme) {
        FluidStack content = this.syncHandler.getFluid();
        if (content == null) {
            content = this.syncHandler.getLockedFluid();
        }
        float height = this.getArea().h() - 2;
        int y = 1;
        if (!this.syncHandler.drawAlwaysFull()) {
            float amt = content == null ? 0.0f : (float)content.amount;
            float newHeight = height * (amt / (float)this.syncHandler.getCapacity());
            y += (int)(height - newHeight);
            height = newHeight;
        }
        GuiDraw.drawFluidTexture((FluidStack)content, (float)1.0f, (float)y, (float)(this.getArea().w() - 2), (float)height, (float)0.0f);
        if (content != null && this.syncHandler.showAmountOnSlot()) {
            String amount = NumberFormat.formatWithMaxDigits((double)content.amount, (int)3) + "L";
            this.textRenderer.setAlignment(Alignment.CenterRight, (float)this.getArea().width - 1.0f);
            this.textRenderer.setPos(0, 12);
            this.textRenderer.draw(amount);
        }
        if (this.isHovering()) {
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GuiDraw.drawRect((float)1.0f, (float)1.0f, (float)(this.getArea().w() - 2), (float)(this.getArea().h() - 2), (int)widgetTheme.getSlotHoverColor());
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        RenderUtil.handleJeiGhostHighlight((IWidget)this);
    }

    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        MouseData data = MouseData.create((int)mouseButton);
        if (this.syncHandler.canFillSlot() || this.syncHandler.canDrainSlot()) {
            this.syncHandler.handleClick(data);
            if (this.syncHandler.canLockFluid()) {
                this.syncHandler.toggleLockFluid();
            }
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.IGNORE;
    }

    public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
        if (!this.syncHandler.isPhantom()) {
            return false;
        }
        if (scrollDirection.isUp() && !this.syncHandler.canFillSlot() || scrollDirection.isDown() && !this.syncHandler.canDrainSlot()) {
            return false;
        }
        MouseData mouseData = MouseData.create((int)scrollDirection.modifier);
        this.syncHandler.handlePhantomScroll(mouseData);
        return true;
    }

    protected WidgetTheme getWidgetThemeInternal(ITheme theme) {
        return theme.getFluidSlotTheme();
    }

    public void setGhostIngredient(@NotNull FluidStack ingredient) {
        if (this.syncHandler.isPhantom()) {
            this.syncHandler.setFluid(ingredient);
            this.syncHandler.syncToServer(2, buffer -> NetworkUtils.writeFluidStack((PacketBuffer)buffer, (FluidStack)ingredient));
        } else {
            this.syncHandler.lockFluid(ingredient, true);
        }
    }

    @Nullable
    public FluidStack castGhostIngredientIfValid(@NotNull Object ingredient) {
        ItemStack stack;
        if (!this.syncHandler.canLockFluid() && !this.syncHandler.isPhantom()) {
            return null;
        }
        if (ingredient instanceof FluidStack) {
            FluidStack stack2 = (FluidStack)ingredient;
            return stack2;
        }
        if (ingredient instanceof ItemStack && (stack = (ItemStack)ingredient).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            IFluidHandlerItem handler;
            if (stack.func_190916_E() > 1) {
                stack = GTUtility.copy(1, stack);
            }
            return (handler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) == null ? null : handler.drain(Integer.MAX_VALUE, true);
        }
        return null;
    }

    @Nullable
    public Object getIngredient() {
        return this.syncHandler.getFluid();
    }
}

