/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.drawable.ItemDrawable;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.scroll.ScrollData;
import com.cleanroommc.modularui.widget.scroll.VerticalScrollData;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.PageButton;
import com.cleanroommc.modularui.widgets.PagedWidget;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.layout.Grid;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.modularui.widgets.slot.SlotGroup;
import com.google.common.base.Preconditions;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.api.mui.sync.PagedWidgetSyncHandler;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.inventory.handlers.SingleItemStackHandler;
import gregtech.common.inventory.handlers.ToolItemStackHandler;
import gregtech.common.metatileentities.storage.CraftingRecipeLogic;
import gregtech.common.metatileentities.storage.CraftingRecipeMemory;
import gregtech.common.mui.widget.workbench.CraftingInputSlot;
import gregtech.common.mui.widget.workbench.CraftingOutputSlot;
import gregtech.common.mui.widget.workbench.RecipeMemorySlot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityWorkbench
extends MetaTileEntity {
    private static final IDrawable CHEST = new ItemDrawable(new ItemStack((Block)Blocks.field_150486_ae)).asIcon().size(16);
    private final IDrawable WORKSTATION = new ItemDrawable(this.getStackForm()).asIcon().size(16);
    private final ItemStackHandler craftingGrid = new SingleItemStackHandler(9);
    private final ItemStackHandler internalInventory = new GTItemStackHandler((MetaTileEntity)this, 18);
    private final ItemStackHandler toolInventory = new ToolItemStackHandler(9);
    private ItemHandlerList combinedInventory;
    private ItemHandlerList connectedInventory;
    private final CraftingRecipeMemory recipeMemory = new CraftingRecipeMemory(9, (IItemHandlerModifiable)this.craftingGrid);
    private CraftingRecipeLogic recipeLogic = null;
    private int itemsCrafted = 0;

    public MetaTileEntityWorkbench(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityWorkbench(this.metaTileEntityId);
    }

    @Override
    public int getDefaultPaintingColor() {
        return 0xFFFFFF;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.CRAFTING_TABLE.getParticleSprite(), (Object)this.getDefaultPaintingColor());
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        int paintingColor = this.getPaintingColorForRendering();
        pipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(paintingColor)));
        Textures.CRAFTING_TABLE.renderOriented(renderState, translation, pipeline, this.getFrontFacing());
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeInt(this.itemsCrafted);
        for (int i = 0; i < this.craftingGrid.getSlots(); ++i) {
            NetworkUtils.writeItemStack((PacketBuffer)buf, (ItemStack)this.craftingGrid.getStackInSlot(i));
        }
        this.recipeMemory.writeInitialSyncData(buf);
        buf.func_150787_b(this.computeConnectedInventory().getSlots());
    }

    @Override
    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.itemsCrafted = buf.readInt();
        for (int i = 0; i < this.craftingGrid.getSlots(); ++i) {
            this.craftingGrid.setStackInSlot(i, NetworkUtils.readItemStack((PacketBuffer)buf));
        }
        this.recipeMemory.receiveInitialSyncData(buf);
        this.connectedInventory = new ItemHandlerList(Collections.singletonList(new GTItemStackHandler((MetaTileEntity)this, buf.func_150792_a())));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("CraftingGridInventory", (NBTBase)this.craftingGrid.serializeNBT());
        data.func_74782_a("ToolInventory", (NBTBase)this.toolInventory.serializeNBT());
        data.func_74782_a("InternalInventory", (NBTBase)this.internalInventory.serializeNBT());
        data.func_74768_a("ItemsCrafted", this.itemsCrafted);
        data.func_74782_a("RecipeMemory", (NBTBase)this.recipeMemory.serializeNBT());
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.craftingGrid.deserializeNBT(data.func_74775_l("CraftingGridInventory"));
        this.toolInventory.deserializeNBT(data.func_74775_l("ToolInventory"));
        this.internalInventory.deserializeNBT(data.func_74775_l("InternalInventory"));
        this.itemsCrafted = data.func_74762_e("ItemsCrafted");
        this.recipeMemory.deserializeNBT(data.func_74775_l("RecipeMemory"));
    }

    public IItemHandlerModifiable getAvailableHandlers() {
        ArrayList<Object> handlers = new ArrayList<Object>();
        handlers.add(this.internalInventory);
        handlers.add(this.toolInventory);
        if (this.getWorld().field_72995_K) {
            handlers.add(this.connectedInventory);
        } else {
            handlers.add(this.computeConnectedInventory());
        }
        this.combinedInventory = new ItemHandlerList(handlers);
        return this.combinedInventory;
    }

    private ItemHandlerList computeConnectedInventory() {
        ArrayList<IItemHandler> handlers = new ArrayList<IItemHandler>();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            IItemHandler handler;
            TileEntity neighbor = this.getNeighbor(facing);
            if (neighbor == null || (handler = (IItemHandler)neighbor.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) == null) continue;
            handlers.add(handler);
        }
        this.connectedInventory = new ItemHandlerList(handlers);
        return this.connectedInventory;
    }

    @Override
    public void onNeighborChanged() {
        this.getCraftingRecipeLogic().updateInventory(this.getAvailableHandlers());
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.UPDATE_CLIENT_HANDLER, this::sendHandlerToClient);
        }
    }

    @NotNull
    public CraftingRecipeLogic getCraftingRecipeLogic() {
        Preconditions.checkState((this.getWorld() != null ? 1 : 0) != 0, (Object)"getRecipeResolver called too early");
        if (this.recipeLogic == null) {
            this.recipeLogic = new CraftingRecipeLogic(this.getWorld(), this.getAvailableHandlers(), (IItemHandlerModifiable)this.getCraftingGrid());
            this.writeCustomData(GregtechDataCodes.UPDATE_CLIENT_HANDLER, this::sendHandlerToClient);
        }
        return this.recipeLogic;
    }

    @Override
    public void clearMachineInventory(@NotNull @NotNull List<@NotNull ItemStack> itemBuffer) {
        super.clearMachineInventory(itemBuffer);
        MetaTileEntityWorkbench.clearInventory(itemBuffer, (IItemHandlerModifiable)this.internalInventory);
        MetaTileEntityWorkbench.clearInventory(itemBuffer, (IItemHandlerModifiable)this.toolInventory);
    }

    @Override
    public boolean usesMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(PosGuiData guiData, PanelSyncManager syncManager) {
        this.getCraftingRecipeLogic().updateCurrentRecipe();
        this.recipeLogic.clearSlotMap();
        syncManager.syncValue("recipe_logic", (SyncHandler)this.recipeLogic);
        syncManager.syncValue("recipe_memory", (SyncHandler)this.recipeMemory);
        PagedWidget.Controller controller = new PagedWidget.Controller();
        syncManager.syncValue("page_controller", (SyncHandler)new PagedWidgetSyncHandler(controller));
        return ((ModularPanel)((ModularPanel)((ModularPanel)GTGuis.createPanel(this, 176, 224).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.row().debugName("tab row")).widthRel(1.0f)).leftRel(0.5f)).margin(3, 0)).coverChildrenHeight()).topRel(0.0f, 3, 1.0f)).child((IWidget)((PageButton)new PageButton(0, controller).tab(GuiTextures.TAB_TOP, 0).addTooltipLine((IDrawable)IKey.lang((String)"gregtech.machine.workbench.tab.workbench"))).overlay(new IDrawable[]{this.WORKSTATION}))).child((IWidget)((PageButton)((PageButton)new PageButton(1, controller).tab(GuiTextures.TAB_TOP, 0).addTooltipLine((IDrawable)IKey.lang((String)"gregtech.machine.workbench.tab.item_list"))).addTooltipLine((IDrawable)IKey.lang((String)"gregtech.machine.workbench.storage_note").style(TextFormatting.DARK_GRAY))).overlay(new IDrawable[]{CHEST})))).child((IWidget)((TextWidget)IKey.lang((String)this.getMetaFullName()).asWidget().top(7)).left(7))).child((IWidget)((PagedWidget)((PagedWidget)((PagedWidget)((PagedWidget)new PagedWidget().top(22)).margin(7)).widthRel(0.9f)).controller(controller).coverChildrenHeight()).addPage((IWidget)((Flow)((Flow)((Flow)((Flow)Flow.column().debugName("crafting page")).coverChildrenWidth()).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.row().debugName("crafting row")).coverChildrenHeight()).widthRel(1.0f)).child(this.createCraftingGrid())).child(this.createCraftingOutput(guiData, syncManager))).child(this.createRecipeMemoryGrid(syncManager)))).child(this.createToolInventory(syncManager))).child(this.createInternalInventory(syncManager))).addPage(this.createInventoryPage(syncManager)))).bindPlayerInventory();
    }

    private ModularSlot trackSlot(IItemHandler handler, int slot) {
        int offset = this.combinedInventory.getIndexOffset(handler);
        if (offset == -1) {
            throw new NullPointerException("handler cannot be found");
        }
        this.recipeLogic.updateSlotMap(offset, slot);
        return new ModularSlot(handler, slot);
    }

    public IWidget createToolInventory(PanelSyncManager syncManager) {
        SlotGroup toolSlots = new SlotGroup("tool_slots", 9, -120, true);
        syncManager.registerSlotGroup(toolSlots);
        return (IWidget)SlotGroupWidget.builder().row("XXXXXXXXX").key('X', i -> ((ItemSlot)new ItemSlot().background(new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.TOOL_SLOT_OVERLAY})).slot(this.trackSlot((IItemHandler)this.toolInventory, i).slotGroup(toolSlots))).build().marginTop(2);
    }

    public IWidget createInternalInventory(PanelSyncManager syncManager) {
        SlotGroup inventory = new SlotGroup("internal_slots", 9, -100, true);
        syncManager.registerSlotGroup(inventory);
        return (IWidget)SlotGroupWidget.builder().row("XXXXXXXXX").row("XXXXXXXXX").key('X', i -> new ItemSlot().slot(this.trackSlot((IItemHandler)this.internalInventory, i).slotGroup(inventory))).build().marginTop(2);
    }

    public IWidget createCraftingGrid() {
        return (IWidget)SlotGroupWidget.builder().matrix(new String[]{"XXX", "XXX", "XXX"}).key('X', i -> CraftingInputSlot.create(this.recipeLogic, (IItemHandlerModifiable)this.craftingGrid, i).changeListener((newItem, onlyAmountChanged, client, init) -> {
            if (!init) {
                this.recipeLogic.updateCurrentRecipe();
            }
        }).background(new IDrawable[]{GTGuiTextures.SLOT})).build().child((IWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().margin(2)).size(8)).topRel(0.0f)).rightRel(0.0f, 0, 1.0f)).background(new IDrawable[]{GTGuiTextures.BUTTON_CLEAR_GRID})).addTooltipLine((IDrawable)IKey.lang((String)"gregtech.machine.workbench.clear_grid"))).disableHoverBackground()).onMousePressed(mouseButton -> {
            this.recipeLogic.clearCraftingGrid();
            return true;
        }));
    }

    public IWidget createCraftingOutput(PosGuiData guiData, PanelSyncManager syncManager) {
        IntSyncValue amountCrafted = new IntSyncValue(this::getItemsCrafted, this::setItemsCrafted);
        syncManager.syncValue("amount_crafted", (SyncHandler)amountCrafted);
        return (IWidget)((Flow)((Flow)Flow.column().size(54)).child((IWidget)((CraftingOutputSlot)((CraftingOutputSlot)new CraftingOutputSlot(amountCrafted, this).marginTop(18)).background(new IDrawable[]{GTGuiTextures.SLOT.asIcon().size(22)})).marginBottom(4))).child((IWidget)IKey.dynamic(() -> TextFormattingUtil.formatLongToCompactString(amountCrafted.getIntValue(), 5)).alignment(Alignment.Center).asWidget().widthRel(1.0f));
    }

    public IWidget createRecipeMemoryGrid(PanelSyncManager syncManager) {
        return (IWidget)SlotGroupWidget.builder().matrix(new String[]{"XXX", "XXX", "XXX"}).key('X', i -> new RecipeMemorySlot(this.recipeMemory, i).background(new IDrawable[]{GTGuiTextures.SLOT})).build().right(0);
    }

    public IWidget createInventoryPage(PanelSyncManager syncManager) {
        if (this.connectedInventory.getSlots() == 0) {
            return ((Flow)((Flow)((Flow)((Flow)((Flow)Flow.column().debugName("inventory page - empty")).leftRel(0.5f)).padding(2)).height(108)).width(148)).background(new IDrawable[]{GTGuiTextures.DISPLAY});
        }
        ArrayList<ItemSlot> list = new ArrayList<ItemSlot>(this.connectedInventory.getSlots());
        int rowSize = Math.min(this.connectedInventory.getSlots(), 8);
        SlotGroup connected = new SlotGroup("connected_inventory", rowSize, true).setAllowSorting(false);
        syncManager.registerSlotGroup(connected);
        for (int i = 0; i < this.connectedInventory.getSlots(); ++i) {
            list.add(((ItemSlot)new ItemSlot().setEnabledIf(itemSlot -> {
                int slot = itemSlot.getSlot().getSlotIndex();
                return slot < this.connectedInventory.getSlots();
            })).slot(this.trackSlot((IItemHandler)this.connectedInventory, i).slotGroup(connected)));
        }
        list.sort((o1, o2) -> {
            ItemStack left = o1.getSlot().func_75211_c();
            ItemStack right = o2.getSlot().func_75211_c();
            if (!left.func_190926_b() && !right.func_190926_b()) {
                return 0;
            }
            if (left.func_190926_b() && right.func_190926_b()) {
                return 0;
            }
            return right.func_190926_b() ? -1 : 1;
        });
        return (IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.column().debugName("inventory page")).padding(2)).leftRel(0.5f)).coverChildren()).background(new IDrawable[]{GTGuiTextures.DISPLAY})).child((IWidget)((Grid)((Grid)new Grid().scrollable((ScrollData)new VerticalScrollData()).width(148)).height(108)).mapTo(rowSize, list));
    }

    public void sendHandlerToClient(PacketBuffer buffer) {
        buffer.func_150787_b(this.connectedInventory.getSlots());
    }

    public void readHandler(PacketBuffer buf) {
        int connected = buf.func_150792_a();
        this.connectedInventory = new ItemHandlerList(Collections.singletonList(new ItemStackHandler(connected)));
        this.combinedInventory = new ItemHandlerList(Arrays.asList(this.internalInventory, this.toolInventory, this.connectedInventory));
        this.getCraftingRecipeLogic().updateInventory(this.combinedInventory);
    }

    @Override
    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_CLIENT_HANDLER) {
            this.readHandler(buf);
        }
    }

    public int getItemsCrafted() {
        return this.itemsCrafted;
    }

    public void setItemsCrafted(int itemsCrafted) {
        this.itemsCrafted = itemsCrafted;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.workbench.tooltip1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.workbench.tooltip2", (Object[])new Object[0]));
    }

    public ItemStackHandler getCraftingGrid() {
        return this.craftingGrid;
    }

    public ItemStackHandler getToolInventory() {
        return this.toolInventory;
    }

    public CraftingRecipeMemory getRecipeMemory() {
        return this.recipeMemory;
    }

    @Override
    public boolean canPlaceCoverOnSide(@NotNull EnumFacing side) {
        return false;
    }

    @Override
    public boolean acceptsCovers() {
        return false;
    }

    @Override
    public boolean canRenderMachineGrid(@NotNull ItemStack mainHandStack, @NotNull ItemStack offHandStack) {
        return false;
    }

    @Override
    public boolean showToolUsages() {
        return false;
    }
}

