/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.DualHandler;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.IQuantumController;
import gregtech.api.capability.IQuantumStorage;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityQuantumStorageController
extends MetaTileEntity
implements IQuantumController {
    private static final int MAX_DISTANCE_RADIUS = 16;
    private EnergyContainerList energyHandler = new EnergyContainerList(Collections.emptyList());
    private final List<IEnergyContainer> energyContainers = new ArrayList<IEnergyContainer>();
    private Map<BlockPos, WeakReference<IQuantumStorage<?>>> storageInstances = new HashMap();
    private Set<BlockPos> storagePositions = new HashSet<BlockPos>();
    private final Map<IQuantumStorage.Type, Set<BlockPos>> typePosMap = new EnumMap<IQuantumStorage.Type, Set<BlockPos>>(IQuantumStorage.Type.class);
    private final BlockPos[] bounds = new BlockPos[2];
    private long energyConsumption = 0L;
    private final QuantumControllerHandler handler = new QuantumControllerHandler();
    private boolean isDead = false;
    private boolean isPowered = false;

    public MetaTileEntityQuantumStorageController(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
        for (IQuantumStorage.Type type : IQuantumStorage.Type.VALUES) {
            this.typePosMap.put(type, new HashSet());
        }
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityQuantumStorageController(this.metaTileEntityId);
    }

    @Override
    public void update() {
        super.update();
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (this.getOffsetTimer() % 10L == 0L) {
            boolean isPowered;
            boolean bl = isPowered = this.energyHandler.getEnergyStored() > this.energyConsumption && this.energyConsumption > 0L;
            if (isPowered) {
                this.energyHandler.removeEnergy(this.energyConsumption);
            }
            if (isPowered != this.isPowered) {
                this.isPowered = isPowered;
                this.writeCustomData(GregtechDataCodes.UPDATE_ENERGY, buf -> {
                    buf.writeBoolean(this.isPowered);
                    buf.func_179255_a(this.bounds[0]);
                    buf.func_179255_a(this.bounds[1]);
                });
                this.onHandlerUpdate();
            }
        }
    }

    @Override
    public boolean isPowered() {
        return this.isPowered;
    }

    @Override
    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_ENERGY) {
            this.isPowered = buf.readBoolean();
            this.getWorld().func_175704_b(buf.func_179259_c(), buf.func_179259_c());
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.UPDATE_ENERGY_PER) {
            this.energyConsumption = buf.readLong();
        }
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        SimpleOverlayRenderer front = this.isPowered() ? Textures.QUANTUM_CONTROLLER_FRONT_ACTIVE : Textures.QUANTUM_CONTROLLER_FRONT_INACTIVE;
        SimpleOverlayRenderer sides = this.isPowered() ? Textures.QUANTUM_CONTROLLER_ACTIVE : Textures.QUANTUM_CONTROLLER_INACTIVE;
        IVertexOperation[] newPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
        front.renderSided(this.getFrontFacing(), renderState, translation, newPipeline);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (facing == this.getFrontFacing()) continue;
            sides.renderSided(facing, renderState, translation, newPipeline);
        }
    }

    @Override
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.QUANTUM_CONTROLLER_ACTIVE.getParticleSprite(), (Object)this.getPaintingColorForRendering());
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return true;
    }

    @Nullable
    private IQuantumStorage<?> getStorage(BlockPos pos, boolean rebuild) {
        WeakReference<IQuantumStorage<?>> storageRef;
        IQuantumStorage storage;
        if (this.getWorld().field_72995_K) {
            return null;
        }
        if (this.storageInstances.containsKey(pos) && (storage = (IQuantumStorage)(storageRef = this.storageInstances.get(pos)).get()) != null) {
            return storage;
        }
        MetaTileEntity mte = GTUtility.getMetaTileEntity((IBlockAccess)this.getWorld(), pos);
        if (mte instanceof IQuantumStorage) {
            storage = (IQuantumStorage)((Object)mte);
            this.storageInstances.put(pos, new WeakReference<IQuantumStorage>(storage));
            return storage;
        }
        if (rebuild) {
            this.storagePositions.remove(pos);
            this.rebuildNetwork();
            return null;
        }
        return null;
    }

    @Nullable
    public final IQuantumStorage<?> getStorage(BlockPos pos) {
        return this.getStorage(pos, false);
    }

    @Override
    public boolean canConnect(IQuantumStorage<?> storage) {
        return !this.isDead && this.isInRange(storage.getPos());
    }

    private boolean isInRange(BlockPos pos) {
        return Math.abs(this.getPos().func_177958_n() - pos.func_177958_n()) <= 16 && Math.abs(this.getPos().func_177956_o() - pos.func_177956_o()) <= 16 && Math.abs(this.getPos().func_177952_p() - pos.func_177952_p()) <= 16;
    }

    @Override
    public void onRemoval() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        this.isDead = true;
        for (BlockPos pos : this.storagePositions) {
            IQuantumStorage<?> storage = this.getStorage(pos);
            if (storage == null) continue;
            storage.setDisconnected();
        }
        this.handler.invalidate();
        this.storagePositions.clear();
        this.storageInstances.clear();
        this.typePosMap.clear();
    }

    @Override
    public void onPlacement(@Nullable EntityLivingBase placer) {
        super.onPlacement(placer);
        this.rebuildNetwork();
    }

    @Override
    public void onLoad() {
        this.calculateEnergyUsage();
        super.onLoad();
    }

    @Override
    public void rebuildNetwork() {
        IQuantumStorage storage;
        if (this.getWorld().field_72995_K) {
            return;
        }
        Map<BlockPos, WeakReference<IQuantumStorage<?>>> oldInstances = this.storageInstances;
        Set<BlockPos> oldPositions = this.storagePositions;
        this.storageInstances = new HashMap();
        this.storagePositions = new HashSet<BlockPos>();
        this.typePosMap.values().forEach(Set::clear);
        ArrayDeque<BlockPos> searchQueue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!MetaTileEntityQuantumStorageController.checkStorageNeighbor(this, facing)) continue;
            searchQueue.add(this.getPos().func_177972_a(facing));
        }
        int minx = this.getPos().func_177958_n();
        int miny = this.getPos().func_177956_o();
        int minz = this.getPos().func_177952_p();
        int maxx = minx;
        int maxy = miny;
        int maxz = minz;
        while (!searchQueue.isEmpty()) {
            MetaTileEntity mte;
            IBlockState state;
            BlockPos pos = (BlockPos)searchQueue.remove();
            if (!checked.add(pos) || !this.isInRange(pos) || !this.getWorld().func_175668_a(pos, false) || (state = this.getWorld().func_180495_p(pos)).func_177230_c().isAir(state, (IBlockAccess)this.getWorld(), pos) || (storage = (IQuantumStorage)((Object)(mte = GTUtility.getMetaTileEntity((IBlockAccess)this.getWorld(), pos)))).isConnected() && !storage.getControllerPos().equals((Object)this.getPos())) continue;
            this.storageInstances.put(pos, new WeakReference<IQuantumStorage>(storage));
            this.storagePositions.add(pos);
            this.typePosMap.get((Object)storage.getType()).add(pos);
            storage.setConnected(this);
            oldInstances.remove(pos);
            oldPositions.remove(pos);
            minx = Math.min(minx, pos.func_177958_n());
            miny = Math.min(miny, pos.func_177956_o());
            minz = Math.min(minz, pos.func_177952_p());
            maxx = Math.max(maxx, pos.func_177958_n());
            maxy = Math.max(maxy, pos.func_177956_o());
            maxz = Math.max(maxz, pos.func_177952_p());
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos offsetPos = pos.func_177972_a(facing);
                if (checked.contains(offsetPos) || this.getPos().equals((Object)offsetPos) || (state = this.getWorld().func_180495_p(offsetPos)).func_177230_c().isAir(state, (IBlockAccess)this.getWorld(), offsetPos) || !MetaTileEntityQuantumStorageController.checkStorageNeighbor(mte, facing)) continue;
                searchQueue.add(offsetPos);
            }
        }
        this.bounds[0] = new BlockPos(minx, miny, minz);
        this.bounds[1] = new BlockPos(maxx, maxy, maxz);
        for (BlockPos pos : oldPositions) {
            IBlockState state;
            if (checked.contains(pos) || (state = this.getWorld().func_180495_p(pos)).func_177230_c().isAir(state, (IBlockAccess)this.getWorld(), pos)) continue;
            storage = (IQuantumStorage)oldInstances.get(pos).get();
            if (storage == null) {
                IQuantumStorage quantumStorage;
                MetaTileEntity mte = GTUtility.getMetaTileEntity((IBlockAccess)this.getWorld(), pos);
                if (!(mte instanceof IQuantumStorage)) continue;
                storage = quantumStorage = (IQuantumStorage)((Object)mte);
            }
            storage.setDisconnected();
        }
        this.handler.markDirty();
        this.onHandlerUpdate();
        this.calculateEnergyUsage();
        this.markDirty();
    }

    private static boolean checkStorageNeighbor(MetaTileEntity mte, EnumFacing facing) {
        TileEntity tileEntity = mte.getNeighbor(facing);
        if (tileEntity instanceof IGregTechTileEntity) {
            IGregTechTileEntity gtte = (IGregTechTileEntity)tileEntity;
            return gtte.getMetaTileEntity() instanceof IQuantumStorage;
        }
        return false;
    }

    @Override
    public void onHandlerUpdate() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        this.notifyBlockUpdate();
        for (BlockPos pos : this.typePosMap.get((Object)IQuantumStorage.Type.PROXY)) {
            IQuantumStorage<?> storage = this.getStorage(pos);
            if (storage == null) continue;
            storage.notifyBlockUpdate();
        }
    }

    private void calculateEnergyUsage() {
        this.energyContainers.clear();
        this.energyConsumption = 0L;
        for (BlockPos pos : this.storagePositions) {
            IQuantumStorage<?> storage = this.getStorage(pos);
            if (storage == null) continue;
            this.typePosMap.get((Object)storage.getType()).add(pos);
            this.energyConsumption += this.getTypeEnergy(storage);
            if (storage.getType() != IQuantumStorage.Type.ENERGY) continue;
            this.energyContainers.add((IEnergyContainer)storage.getTypeValue());
        }
        this.energyHandler = new EnergyContainerList(this.energyContainers);
        this.writeCustomData(GregtechDataCodes.UPDATE_ENERGY_PER, buf -> buf.writeLong(this.energyConsumption));
    }

    @Override
    public long getTypeEnergy(IQuantumStorage<?> storage) {
        long l;
        switch (storage.getType()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ITEM: 
            case FLUID: {
                int tier;
                int n;
                if (storage instanceof ITieredMetaTileEntity) {
                    ITieredMetaTileEntity tieredMTE = (ITieredMetaTileEntity)((Object)storage);
                    n = tieredMTE.getTier();
                } else {
                    n = tier = 1;
                }
                if (tier > 5) {
                    l = GTValues.VH[3];
                    break;
                }
                l = GTValues.VH[1];
                break;
            }
            case PROXY: {
                l = 8L;
                break;
            }
            case EXTENDER: {
                l = 2L;
                break;
            }
            case ENERGY: {
                l = 1L;
            }
        }
        return l;
    }

    @Override
    public int getCount(IQuantumStorage.Type type) {
        return this.typePosMap.get((Object)type).size();
    }

    @Override
    public final long getEnergyUsage() {
        return this.energyConsumption;
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isPowered);
        buf.writeLong(this.energyConsumption);
    }

    @Override
    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isPowered = buf.readBoolean();
        this.energyConsumption = buf.readLong();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        NBTTagCompound tagCompound = super.writeToNBT(data);
        NBTTagList list = new NBTTagList();
        for (BlockPos pos : this.storagePositions) {
            list.func_74742_a((NBTBase)new NBTTagLong(pos.func_177986_g()));
        }
        tagCompound.func_74782_a("StorageInstances", (NBTBase)list);
        tagCompound.func_74772_a("MinBound", this.bounds[0].func_177986_g());
        tagCompound.func_74772_a("MaxBound", this.bounds[1].func_177986_g());
        tagCompound.func_74757_a("isPowered", this.isPowered);
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        NBTTagList list = data.func_150295_c("StorageInstances", 4);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.storagePositions.add(BlockPos.func_177969_a((long)((NBTTagLong)list.func_179238_g(i)).func_150291_c()));
        }
        this.bounds[0] = BlockPos.func_177969_a((long)data.func_74763_f("MinBound"));
        this.bounds[1] = BlockPos.func_177969_a((long)data.func_74763_f("MaxBound"));
        this.isPowered = data.func_74767_n("isPowered");
    }

    @Override
    public <T> T getCapability(@NotNull Capability<T> capability, EnumFacing side) {
        if (this.isPowered()) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.handler.hasItemHandlers()) {
                return (T)this.handler.getItemDelegate();
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.handler.hasFluidTanks()) {
                return (T)this.handler.getFluidDelegate();
            }
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.quantum_chest.tooltip", (Object[])new Object[0]));
    }

    @Override
    public DualHandler getHandler() {
        return this.handler;
    }

    private class QuantumControllerHandler
    extends DualHandler {
        private static final IItemHandlerModifiable EMPTY_ITEM = new ItemStackHandler(0);
        private static final IMultipleTankHandler EMPTY_TANK = new FluidTankList(false, new IFluidTank[0]);
        private boolean dirty;

        public QuantumControllerHandler() {
            super(EMPTY_ITEM, EMPTY_TANK, true);
            this.dirty = true;
        }

        private void invalidate() {
            this.fluidDelegate = EMPTY_TANK;
            this.itemDelegate = EMPTY_ITEM;
        }

        private void rebuildCache() {
            ArrayList<IItemHandler> itemHandlerList = new ArrayList<IItemHandler>();
            ArrayList<IFluidTank> fluidTankList = new ArrayList<IFluidTank>();
            for (BlockPos pos : MetaTileEntityQuantumStorageController.this.storagePositions) {
                IQuantumStorage<?> storage = MetaTileEntityQuantumStorageController.this.getStorage(pos);
                if (storage == null) continue;
                switch (storage.getType()) {
                    case ITEM: {
                        itemHandlerList.add((IItemHandler)storage.getTypeValue());
                        break;
                    }
                    case FLUID: {
                        fluidTankList.add((IFluidTank)storage.getTypeValue());
                    }
                }
            }
            this.fluidDelegate = new FluidTankList(false, fluidTankList);
            this.itemDelegate = new ItemHandlerList(itemHandlerList);
            this.dirty = false;
        }

        public void markDirty() {
            this.dirty = true;
        }

        public boolean hasItemHandlers() {
            if (this.dirty) {
                this.rebuildCache();
            }
            return this.getSlots() > 0;
        }

        public boolean hasFluidTanks() {
            if (this.dirty) {
                this.rebuildCache();
            }
            return this.getTanks() > 0;
        }
    }
}

