/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IQuantumController;
import gregtech.api.capability.IQuantumStorage;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.handler.BlockPosHighlightRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.client.utils.RenderUtil;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MetaTileEntityQuantumStorage<T>
extends MetaTileEntity
implements IQuantumStorage<T> {
    private WeakReference<IQuantumController> controller = new WeakReference<Object>(null);
    private BlockPos controllerPos;
    private ClickButtonWidget connectedIcon;

    public MetaTileEntityQuantumStorage(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    @SideOnly(value=Side.CLIENT)
    protected void renderIndicatorOverlay(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        SimpleOverlayRenderer texture = this.isConnected() ? (this.getQuantumController().isPowered() ? Textures.QUANTUM_INDICATOR_POWERED : Textures.QUANTUM_INDICATOR_CONNECTED) : Textures.QUANTUM_INDICATOR;
        texture.renderSided(this.getFrontFacing(), renderState, RenderUtil.adjustTrans(translation, this.getFrontFacing(), 1), pipeline);
    }

    @Override
    public void setConnected(IQuantumController controller) {
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (!controller.getPos().equals((Object)this.controllerPos)) {
            this.controller = new WeakReference<IQuantumController>(controller);
            this.controllerPos = controller.getPos();
            this.writeCustomData(GregtechDataCodes.UPDATE_CONTROLLER_POS, buf -> buf.func_179255_a(this.controllerPos));
            this.markDirty();
        }
    }

    @Override
    public void setDisconnected() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        this.controller.clear();
        this.controllerPos = null;
        this.writeCustomData(GregtechDataCodes.REMOVE_CONTROLLER, buf -> {});
        this.markDirty();
    }

    @Override
    public final IQuantumController getQuantumController() {
        if (this.isConnected()) {
            if (this.controller.get() != null) {
                return (IQuantumController)this.controller.get();
            }
            MetaTileEntity mte = GTUtility.getMetaTileEntity((IBlockAccess)this.getWorld(), this.controllerPos);
            if (mte instanceof IQuantumController) {
                IQuantumController quantumController = (IQuantumController)((Object)mte);
                this.controller = new WeakReference<IQuantumController>(quantumController);
                return quantumController;
            }
            this.setDisconnected();
            this.tryFindNetwork();
        }
        return null;
    }

    @Override
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    @Override
    public void onRemoval() {
        IQuantumController controller;
        if (!this.getWorld().field_72995_K && this.isConnected() && (controller = this.getQuantumController()) != null) {
            controller.rebuildNetwork();
        }
    }

    @Override
    public void onPlacement(@Nullable EntityLivingBase placer) {
        super.onPlacement(placer);
        if (this.getWorld() == null || this.getWorld().field_72995_K) {
            return;
        }
        this.tryFindNetwork();
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.controllerPos != null);
        if (this.controllerPos != null) {
            buf.func_179255_a(this.controllerPos);
        }
    }

    @Override
    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        if (buf.readBoolean()) {
            this.controllerPos = buf.func_179259_c();
            this.scheduleRenderUpdate();
        }
    }

    @Override
    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_CONTROLLER_POS) {
            this.controllerPos = buf.func_179259_c();
            this.controller.clear();
            if (this.connectedIcon != null) {
                this.connectedIcon.setButtonTexture(GuiTextures.GREGTECH_LOGO);
                this.connectedIcon.setTooltipText("gregtech.machine.quantum_storage.connected", this.controllerPos.func_177958_n(), this.controllerPos.func_177952_p(), this.controllerPos.func_177956_o());
            }
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.REMOVE_CONTROLLER) {
            this.controllerPos = null;
            this.controller.clear();
            if (this.connectedIcon != null) {
                this.connectedIcon.setButtonTexture(GuiTextures.GREGTECH_LOGO_DARK);
                this.connectedIcon.setTooltipText("gregtech.machine.quantum_storage.disconnected", new Object[0]);
            }
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.LOCATE_CONTROLLER) {
            BlockPosHighlightRenderer.renderBlockBoxHighLight(this.getControllerPos(), 6000L, 1500L);
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        NBTTagCompound tagCompound = super.writeToNBT(data);
        tagCompound.func_74757_a("HasController", this.controllerPos != null);
        if (this.controllerPos != null) {
            tagCompound.func_74772_a("ControllerPos", this.controllerPos.func_177986_g());
        }
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74767_n("HasController")) {
            this.controllerPos = BlockPos.func_177969_a((long)data.func_74763_f("ControllerPos"));
        }
    }

    protected ClickButtonWidget createConnectedGui(int y) {
        this.connectedIcon = new ClickButtonWidget(151, y, 18, 18, "", clickData -> {
            if (this.isConnected()) {
                this.writeCustomData(GregtechDataCodes.LOCATE_CONTROLLER, buffer -> {});
            }
        });
        this.connectedIcon.setButtonTexture(this.isConnected() ? GuiTextures.GREGTECH_LOGO : GuiTextures.GREGTECH_LOGO_DARK);
        if (this.isConnected()) {
            this.connectedIcon.setTooltipText("gregtech.machine.quantum_storage.connected", this.controllerPos.func_177958_n(), this.controllerPos.func_177952_p(), this.controllerPos.func_177956_o());
        } else {
            this.connectedIcon.setTooltipText("gregtech.machine.quantum_storage.disconnected", new Object[0]);
        }
        return this.connectedIcon;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.quantum_chest.tooltip", (Object[])new Object[0]));
    }
}

