/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.DualHandler;
import gregtech.api.capability.IQuantumController;
import gregtech.api.capability.IQuantumStorage;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.storage.MetaTileEntityQuantumStorage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityQuantumProxy
extends MetaTileEntityQuantumStorage<DualHandler> {
    public MetaTileEntityQuantumProxy(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityQuantumProxy(this.metaTileEntityId);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        IVertexOperation[] newPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
        if (this.isConnected() && this.getQuantumController().isPowered()) {
            Textures.QUANTUM_PROXY_ACTIVE.render(renderState, translation, newPipeline);
        } else {
            Textures.QUANTUM_PROXY_INACTIVE.render(renderState, translation, newPipeline);
        }
    }

    @Override
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.QUANTUM_PROXY_INACTIVE.getParticleSprite(), (Object)this.getPaintingColorForRendering());
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    public boolean hasFrontFacing() {
        return false;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        IQuantumController controller;
        if ((capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) && (controller = this.getPoweredController()) != null) {
            return (T)controller.getCapability(capability, side);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void setDisconnected() {
        super.setDisconnected();
        this.notifyBlockUpdate();
    }

    @Override
    public IQuantumStorage.Type getType() {
        return IQuantumStorage.Type.PROXY;
    }

    @Override
    public DualHandler getTypeValue() {
        IQuantumController controller = this.getPoweredController();
        if (controller == null) {
            return null;
        }
        return controller.getHandler();
    }

    @Nullable
    private IQuantumController getPoweredController() {
        if (!this.isConnected()) {
            return null;
        }
        IQuantumController controller = this.getQuantumController();
        if (controller == null || !controller.isPowered()) {
            return null;
        }
        return controller;
    }
}

