/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IActiveOutputSide;
import gregtech.api.capability.IQuantumStorage;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.ItemHandlerProxy;
import gregtech.api.cover.CoverRayTracer;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.AdvancedTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.IFastRenderMetaTileEntity;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.custom.QuantumStorageRenderer;
import gregtech.common.metatileentities.storage.MetaTileEntityQuantumStorage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityQuantumChest
extends MetaTileEntityQuantumStorage<IItemHandler>
implements ITieredMetaTileEntity,
IActiveOutputSide,
IFastRenderMetaTileEntity {
    private final int tier;
    protected final long maxStoredItems;
    protected ItemStack virtualItemStack = ItemStack.field_190927_a;
    protected long itemsStoredInside = 0L;
    private boolean autoOutputItems;
    private EnumFacing outputFacing;
    private boolean allowInputFromOutputSide = false;
    private static final String NBT_ITEMSTACK = "ItemStack";
    private static final String NBT_PARTIALSTACK = "PartialStack";
    private static final String NBT_ITEMCOUNT = "ItemAmount";
    private static final String IS_VOIDING = "IsVoiding";
    protected IItemHandler outputItemInventory;
    private ItemHandlerList combinedInventory;
    protected ItemStack previousStack;
    protected long previousStackSize;
    protected boolean voiding;

    public MetaTileEntityQuantumChest(ResourceLocation metaTileEntityId, int tier, long maxStoredItems) {
        super(metaTileEntityId);
        this.tier = tier;
        this.maxStoredItems = maxStoredItems;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityQuantumChest(this.metaTileEntityId, this.tier, this.maxStoredItems);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        Textures.QUANTUM_STORAGE_RENDERER.renderMachine(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()))), this);
        Textures.QUANTUM_CHEST_OVERLAY.renderSided(EnumFacing.UP, renderState, translation, pipeline);
        if (this.outputFacing != null) {
            Textures.PIPE_OUT_OVERLAY.renderSided(this.outputFacing, renderState, translation, pipeline);
            if (this.isAutoOutputItems()) {
                Textures.ITEM_OUTPUT_OVERLAY.renderSided(this.outputFacing, renderState, translation, pipeline);
            }
        }
        this.renderIndicatorOverlay(renderState, translation, pipeline);
    }

    @Override
    public void renderMetaTileEntity(double x, double y, double z, float partialTicks) {
        QuantumStorageRenderer.renderChestStack(x, y, z, this, this.virtualItemStack, this.itemsStoredInside, partialTicks);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.VOLTAGE_CASINGS[this.tier].getParticleSprite(), (Object)this.getPaintingColorForRendering());
    }

    @Override
    public void update() {
        super.update();
        EnumFacing currentOutputFacing = this.getOutputFacing();
        if (!this.getWorld().field_72995_K) {
            if (this.itemsStoredInside < this.maxStoredItems) {
                ItemStack inputStack = this.importItems.getStackInSlot(0);
                ItemStack outputStack = this.exportItems.getStackInSlot(0);
                if (!inputStack.func_190926_b() && (this.virtualItemStack.func_190926_b() || MetaTileEntityQuantumChest.areItemStackIdentical(outputStack, inputStack))) {
                    GTTransferUtils.moveInventoryItems((IItemHandler)this.importItems, (IItemHandler)this.combinedInventory);
                    this.markDirty();
                }
            }
            if (this.itemsStoredInside > 0L && !this.virtualItemStack.func_190926_b()) {
                ItemStack outputStack = this.exportItems.getStackInSlot(0);
                int maxStackSize = this.virtualItemStack.func_77976_d();
                if (outputStack.func_190926_b() || MetaTileEntityQuantumChest.areItemStackIdentical(this.virtualItemStack, outputStack) && outputStack.func_190916_E() < maxStackSize) {
                    GTTransferUtils.moveInventoryItems(this.itemInventory, (IItemHandler)this.exportItems);
                    this.markDirty();
                }
            }
            if (this.isAutoOutputItems()) {
                this.pushItemsIntoNearbyHandlers(currentOutputFacing);
            }
            if (this.voiding && !this.importItems.getStackInSlot(0).func_190926_b()) {
                this.importItems.setStackInSlot(0, ItemStack.field_190927_a);
            }
            if (this.previousStack == null || !MetaTileEntityQuantumChest.areItemStackIdentical(this.previousStack, this.virtualItemStack)) {
                this.writeCustomData(GregtechDataCodes.UPDATE_ITEM, buf -> {
                    this.virtualItemStack.func_190920_e(1);
                    buf.func_150788_a(this.virtualItemStack);
                });
                this.previousStack = this.virtualItemStack;
            }
            if (this.previousStackSize != this.itemsStoredInside) {
                this.writeCustomData(GregtechDataCodes.UPDATE_ITEM_COUNT, buf -> buf.writeLong(this.itemsStoredInside));
                this.previousStackSize = this.itemsStoredInside;
            }
        }
    }

    protected static boolean areItemStackIdentical(ItemStack first, ItemStack second) {
        return ItemStack.func_179545_c((ItemStack)first, (ItemStack)second) && ItemStack.func_77970_a((ItemStack)first, (ItemStack)second);
    }

    protected void addDisplayInformation(List<ITextComponent> textList) {
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.machine.quantum_chest.items_stored", new Object[0]));
        textList.add((ITextComponent)new TextComponentString(String.format("%,d", this.itemsStoredInside)));
        ItemStack export = this.exportItems.getStackInSlot(0);
        if (!export.func_190926_b()) {
            textList.add((ITextComponent)new TextComponentString(TextFormattingUtil.formatStringWithNewlines(export.func_82833_r(), 14)));
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.item_storage_total", (Object[])new Object[]{this.maxStoredItems}));
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            String translationKey = null;
            long count = 0L;
            int exportCount = 0;
            if (compound.func_74764_b(NBT_ITEMSTACK)) {
                count = compound.func_74763_f(NBT_ITEMCOUNT);
            }
            if (compound.func_74764_b(NBT_PARTIALSTACK)) {
                ItemStack tempStack = new ItemStack(compound.func_74775_l(NBT_PARTIALSTACK));
                translationKey = tempStack.func_82833_r();
                exportCount = tempStack.func_190916_E();
            }
            if (translationKey != null) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.item_stored", (Object[])new Object[]{I18n.func_135052_a((String)translationKey, (Object[])new Object[0]), count, exportCount}));
            }
        }
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.auto_output_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        this.itemInventory = new QuantumChestItemHandler();
        ArrayList<Object> temp = new ArrayList<Object>();
        temp.add(this.exportItems);
        temp.add(this.itemInventory);
        this.combinedInventory = new ItemHandlerList(temp);
        this.outputItemInventory = new ItemHandlerProxy((IItemHandler)new GTItemStackHandler((MetaTileEntity)this, 0), (IItemHandler)this.combinedInventory);
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new GTItemStackHandler(this, 1){

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return GTTransferUtils.insertItem(MetaTileEntityQuantumChest.this.getCombinedInventory(), stack, simulate);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                NBTTagCompound compound = stack.func_77978_p();
                ItemStack outStack = MetaTileEntityQuantumChest.this.getExportItems().getStackInSlot(0);
                boolean outStackMatch = true;
                if (!outStack.func_190926_b()) {
                    outStackMatch = MetaTileEntityQuantumChest.areItemStackIdentical(stack, outStack);
                }
                if (compound == null) {
                    return true;
                }
                return outStackMatch && !compound.func_150297_b(MetaTileEntityQuantumChest.NBT_ITEMSTACK, 10) && !compound.func_150297_b("Fluid", 10);
            }
        };
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new GTItemStackHandler((MetaTileEntity)this, 1);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        NBTTagCompound tagCompound = super.writeToNBT(data);
        data.func_74768_a("OutputFacing", this.getOutputFacing().func_176745_a());
        data.func_74757_a("AutoOutputItems", this.autoOutputItems);
        data.func_74757_a("AllowInputFromOutputSide", this.allowInputFromOutputSide);
        if (!this.virtualItemStack.func_190926_b() && this.itemsStoredInside > 0L) {
            tagCompound.func_74782_a(NBT_ITEMSTACK, (NBTBase)this.virtualItemStack.func_77955_b(new NBTTagCompound()));
            tagCompound.func_74772_a(NBT_ITEMCOUNT, this.itemsStoredInside);
        }
        data.func_74757_a(IS_VOIDING, this.voiding);
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.outputFacing = EnumFacing.field_82609_l[data.func_74762_e("OutputFacing")];
        this.autoOutputItems = data.func_74767_n("AutoOutputItems");
        this.allowInputFromOutputSide = data.func_74767_n("AllowInputFromOutputSide");
        if (data.func_150297_b(NBT_ITEMSTACK, 10)) {
            this.virtualItemStack = new ItemStack(data.func_74775_l(NBT_ITEMSTACK));
            if (!this.virtualItemStack.func_190926_b()) {
                this.itemsStoredInside = data.func_74763_f(NBT_ITEMCOUNT);
            }
        }
        if (data.func_74764_b(IS_VOIDING)) {
            this.voiding = data.func_74767_n(IS_VOIDING);
        }
    }

    @Override
    public void initFromItemStackData(NBTTagCompound itemStack) {
        super.initFromItemStackData(itemStack);
        if (itemStack.func_150297_b(NBT_ITEMSTACK, 10)) {
            this.virtualItemStack = new ItemStack(itemStack.func_74775_l(NBT_ITEMSTACK));
            if (!this.virtualItemStack.func_190926_b()) {
                this.itemsStoredInside = itemStack.func_74763_f(NBT_ITEMCOUNT);
            }
        }
        if (itemStack.func_150297_b(NBT_PARTIALSTACK, 10)) {
            this.exportItems.setStackInSlot(0, new ItemStack(itemStack.func_74775_l(NBT_PARTIALSTACK)));
        }
        if (itemStack.func_74767_n(IS_VOIDING)) {
            this.setVoiding(true);
        }
    }

    @Override
    public void writeItemStackData(NBTTagCompound itemStack) {
        ItemStack partialStack;
        super.writeItemStackData(itemStack);
        if (!this.virtualItemStack.func_190926_b()) {
            itemStack.func_74782_a(NBT_ITEMSTACK, (NBTBase)this.virtualItemStack.func_77955_b(new NBTTagCompound()));
            itemStack.func_74772_a(NBT_ITEMCOUNT, this.itemsStoredInside);
        }
        if (!(partialStack = this.exportItems.extractItem(0, 64, false)).func_190926_b()) {
            itemStack.func_74782_a(NBT_PARTIALSTACK, (NBTBase)partialStack.func_77955_b(new NBTTagCompound()));
        }
        if (this.voiding) {
            itemStack.func_74757_a(IS_VOIDING, true);
        }
        this.virtualItemStack = ItemStack.field_190927_a;
        this.itemsStoredInside = 0L;
        this.exportItems.setStackInSlot(0, ItemStack.field_190927_a);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.defaultBuilder();
        builder.image(7, 16, 81, 46, GuiTextures.DISPLAY);
        builder.widget(new AdvancedTextWidget(11, 20, this::addDisplayInformation, 0xFFFFFF));
        builder.label(6, 6, this.getMetaFullName()).widget(new SlotWidget((IItemHandler)this.importItems, 0, 90, 17, true, true).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.IN_SLOT_OVERLAY)).widget(new SlotWidget((IItemHandler)this.exportItems, 0, 90, 44, true, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.OUT_SLOT_OVERLAY)).widget(new ToggleButtonWidget(7, 64, 18, 18, GuiTextures.BUTTON_ITEM_OUTPUT, this::isAutoOutputItems, this::setAutoOutputItems).shouldUseBaseBackground().setTooltipText("gregtech.gui.item_auto_output.tooltip", new Object[0])).widget(new ToggleButtonWidget(25, 64, 18, 18, GuiTextures.BUTTON_ITEM_VOID, this::isVoiding, this::setVoiding).setTooltipText("gregtech.gui.item_voiding.tooltip", new Object[0]).shouldUseBaseBackground()).bindPlayerInventory(entityPlayer.field_71071_by);
        builder.widget(this.createConnectedGui(64));
        return builder.build(this.getHolder(), entityPlayer);
    }

    public EnumFacing getOutputFacing() {
        return this.outputFacing == null ? this.frontFacing.func_176734_d() : this.outputFacing;
    }

    public void setOutputFacing(EnumFacing outputFacing) {
        this.outputFacing = outputFacing;
        if (!this.getWorld().field_72995_K) {
            this.notifyBlockUpdate();
            this.writeCustomData(GregtechDataCodes.UPDATE_OUTPUT_FACING, buf -> buf.writeByte(outputFacing.func_176745_a()));
            this.markDirty();
        }
    }

    @Override
    public boolean onWrenchClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!playerIn.func_70093_af()) {
            if (this.getOutputFacing() == facing || this.getFrontFacing() == facing) {
                return false;
            }
            if (!this.getWorld().field_72995_K) {
                this.setOutputFacing(facing);
            }
            return true;
        }
        return super.onWrenchClick(playerIn, hand, facing, hitResult);
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeByte(this.getOutputFacing().func_176745_a());
        buf.writeBoolean(this.autoOutputItems);
        this.virtualItemStack.func_190920_e(1);
        buf.func_150788_a(this.virtualItemStack);
        buf.writeLong(this.itemsStoredInside);
        buf.writeBoolean(this.voiding);
    }

    @Override
    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.outputFacing = EnumFacing.field_82609_l[buf.readByte()];
        this.autoOutputItems = buf.readBoolean();
        try {
            this.virtualItemStack = buf.func_150791_c();
        }
        catch (IOException ignored) {
            GTLog.logger.warn("Failed to load item from NBT in a quantum chest at " + this.getPos() + " on initial server/client sync");
        }
        this.itemsStoredInside = buf.readLong();
        this.voiding = buf.readBoolean();
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return super.isValidFrontFacing(facing) && facing != this.outputFacing;
    }

    @Override
    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_OUTPUT_FACING) {
            this.outputFacing = EnumFacing.field_82609_l[buf.readByte()];
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.UPDATE_AUTO_OUTPUT_ITEMS) {
            this.autoOutputItems = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.UPDATE_ITEM) {
            try {
                this.virtualItemStack = buf.func_150791_c();
            }
            catch (IOException e) {
                GTLog.logger.error("Failed to read item stack in a quantum chest!");
            }
        } else if (dataId == GregtechDataCodes.UPDATE_ITEM_COUNT) {
            this.itemsStoredInside = buf.readLong();
        } else if (dataId == GregtechDataCodes.UPDATE_IS_VOIDING) {
            this.setVoiding(buf.readBoolean());
        }
    }

    public void setAutoOutputItems(boolean autoOutputItems) {
        this.autoOutputItems = autoOutputItems;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.UPDATE_AUTO_OUTPUT_ITEMS, buf -> buf.writeBoolean(autoOutputItems));
            this.markDirty();
        }
    }

    protected boolean isVoiding() {
        return this.voiding;
    }

    protected void setVoiding(boolean isVoiding) {
        this.voiding = isVoiding;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.UPDATE_IS_VOIDING, buf -> buf.writeBoolean(this.voiding));
            this.markDirty();
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_ACTIVE_OUTPUT_SIDE) {
            if (side == this.getOutputFacing()) {
                return (T)GregtechTileCapabilities.CAPABILITY_ACTIVE_OUTPUT_SIDE.cast((Object)this);
            }
            return null;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            ItemHandlerList itemHandler;
            if (side == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.combinedInventory);
            }
            ItemHandlerList itemHandlerList = itemHandler = side == this.getOutputFacing() && !this.isAllowInputFromOutputSideItems() ? this.outputItemInventory : this.combinedInventory;
            if (itemHandler.getSlots() > 0) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)itemHandler);
            }
            return null;
        }
        return super.getCapability(capability, side);
    }

    public IItemHandler getCombinedInventory() {
        return this.combinedInventory;
    }

    public IItemHandler getOutputItemInventory() {
        return this.outputItemInventory;
    }

    @Override
    public void setFrontFacing(EnumFacing frontFacing) {
        super.setFrontFacing(frontFacing);
        if (this.outputFacing == null) {
            this.setOutputFacing(frontFacing.func_176734_d());
        }
    }

    @Override
    public boolean isAutoOutputItems() {
        return this.autoOutputItems;
    }

    @Override
    public boolean isAutoOutputFluids() {
        return false;
    }

    @Override
    public boolean isAllowInputFromOutputSideItems() {
        return this.allowInputFromOutputSide;
    }

    @Override
    public boolean isAllowInputFromOutputSideFluids() {
        return false;
    }

    @Override
    public void clearMachineInventory(@NotNull @NotNull List<@NotNull ItemStack> itemBuffer) {
        MetaTileEntityQuantumChest.clearInventory(itemBuffer, this.importItems);
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        EnumFacing hitFacing = CoverRayTracer.determineGridSideHit((RayTraceResult)hitResult);
        if (facing == this.getOutputFacing() || hitFacing == this.getOutputFacing() && playerIn.func_70093_af()) {
            if (!this.getWorld().field_72995_K) {
                if (this.isAllowInputFromOutputSideItems()) {
                    this.setAllowInputFromOutputSide(false);
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.basic.input_from_output_side.disallow", new Object[0]), true);
                } else {
                    this.setAllowInputFromOutputSide(true);
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.basic.input_from_output_side.allow", new Object[0]), true);
                }
            }
            return true;
        }
        return super.onScrewdriverClick(playerIn, hand, facing, hitResult);
    }

    public void setAllowInputFromOutputSide(boolean allowInputFromOutputSide) {
        this.allowInputFromOutputSide = allowInputFromOutputSide;
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    @Override
    public IQuantumStorage.Type getType() {
        return IQuantumStorage.Type.ITEM;
    }

    @Override
    public IItemHandler getTypeValue() {
        return this.combinedInventory;
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.getPos());
    }

    @Override
    public boolean needsSneakToRotate() {
        return true;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    private class QuantumChestItemHandler
    implements IItemHandler {
        private QuantumChestItemHandler() {
        }

        public int getSlots() {
            return 1;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            ItemStack itemStack = MetaTileEntityQuantumChest.this.virtualItemStack;
            long itemsStored = MetaTileEntityQuantumChest.this.itemsStoredInside;
            if (itemStack.func_190926_b() || itemsStored == 0L) {
                return ItemStack.field_190927_a;
            }
            ItemStack resultStack = itemStack.func_77946_l();
            resultStack.func_190920_e((int)itemsStored);
            return resultStack;
        }

        public int getSlotLimit(int slot) {
            return (int)MetaTileEntityQuantumChest.this.maxStoredItems;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            int extractedAmount = (int)Math.min((long)amount, MetaTileEntityQuantumChest.this.itemsStoredInside);
            if (MetaTileEntityQuantumChest.this.virtualItemStack.func_190926_b() || extractedAmount == 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack extractedStack = MetaTileEntityQuantumChest.this.virtualItemStack.func_77946_l();
            extractedStack.func_190920_e(extractedAmount);
            if (!simulate) {
                MetaTileEntityQuantumChest.this.itemsStoredInside -= (long)extractedAmount;
                if (MetaTileEntityQuantumChest.this.itemsStoredInside == 0L) {
                    MetaTileEntityQuantumChest.this.virtualItemStack = ItemStack.field_190927_a;
                }
            }
            return extractedStack;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack insertedStack, boolean simulate) {
            if (insertedStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (MetaTileEntityQuantumChest.this.itemsStoredInside > 0L && !MetaTileEntityQuantumChest.this.virtualItemStack.func_190926_b() && !MetaTileEntityQuantumChest.areItemStackIdentical(MetaTileEntityQuantumChest.this.virtualItemStack, insertedStack)) {
                return insertedStack;
            }
            ItemStack exportItems = MetaTileEntityQuantumChest.this.getExportItems().getStackInSlot(0);
            if (!exportItems.func_190926_b() && !MetaTileEntityQuantumChest.areItemStackIdentical(exportItems, insertedStack)) {
                return insertedStack;
            }
            ItemStack remainingStack = insertedStack.func_77946_l();
            long amountLeftInChest = MetaTileEntityQuantumChest.this.maxStoredItems - MetaTileEntityQuantumChest.this.itemsStoredInside;
            int maxPotentialVirtualizedAmount = insertedStack.func_190916_E();
            int actualVirtualizedAmount = (int)Math.min((long)maxPotentialVirtualizedAmount, amountLeftInChest);
            remainingStack.func_190918_g(actualVirtualizedAmount);
            if (!simulate && actualVirtualizedAmount > 0) {
                if (MetaTileEntityQuantumChest.this.virtualItemStack.func_190926_b()) {
                    ItemStack virtualStack = insertedStack.func_77946_l();
                    virtualStack.func_190920_e(1);
                    MetaTileEntityQuantumChest.this.virtualItemStack = virtualStack;
                    MetaTileEntityQuantumChest.this.itemsStoredInside = actualVirtualizedAmount;
                } else {
                    MetaTileEntityQuantumChest.this.itemsStoredInside += (long)actualVirtualizedAmount;
                }
            }
            if (MetaTileEntityQuantumChest.this.isVoiding() && remainingStack.func_190916_E() > 0) {
                return ItemStack.field_190927_a;
            }
            return remainingStack;
        }
    }
}

