/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IPropertyFluidFilter;
import gregtech.api.capability.impl.FilteredFluidHandler;
import gregtech.api.capability.impl.GTFluidHandlerItemStack;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityDrum
extends MetaTileEntity {
    private final IPropertyFluidFilter fluidFilter;
    private final boolean isWood;
    private final int color;
    private final int tankSize;
    private FilteredFluidHandler fluidTank;
    private boolean isAutoOutput = false;

    public MetaTileEntityDrum(ResourceLocation metaTileEntityId, @NotNull Material material, int tankSize) {
        super(metaTileEntityId);
        IPropertyFluidFilter filter = material.getProperty(PropertyKey.FLUID_PIPE);
        if (filter == null) {
            throw new IllegalArgumentException("Material " + material + " requires FluidPipeProperty for Drums");
        }
        this.fluidFilter = filter;
        this.isWood = ModHandler.isMaterialWood(material);
        this.color = material.getMaterialRGB();
        this.tankSize = tankSize;
        this.initializeInventory();
    }

    public MetaTileEntityDrum(ResourceLocation metaTileEntityId, @NotNull IPropertyFluidFilter fluidFilter, boolean isWood, int color, int tankSize) {
        super(metaTileEntityId);
        this.fluidFilter = fluidFilter;
        this.isWood = isWood;
        this.color = color;
        this.tankSize = tankSize;
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityDrum(this.metaTileEntityId, this.fluidFilter, this.isWood, this.color, this.tankSize);
    }

    @Override
    public String getHarvestTool() {
        return this.isWood ? "axe" : "wrench";
    }

    @Override
    public boolean hasFrontFacing() {
        return false;
    }

    @Override
    protected void initializeInventory() {
        if (this.fluidFilter == null) {
            return;
        }
        super.initializeInventory();
        this.fluidTank = new FilteredFluidHandler(this.tankSize).setFilter(this.fluidFilter);
        this.fluidInventory = this.fluidTank;
    }

    @Override
    public void initFromItemStackData(NBTTagCompound itemStack) {
        super.initFromItemStackData(itemStack);
        if (itemStack.func_150297_b("Fluid", 10)) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.func_74775_l("Fluid"));
            this.fluidTank.setFluid(fluidStack);
        }
    }

    @Override
    public void writeItemStackData(NBTTagCompound itemStack) {
        super.writeItemStackData(itemStack);
        FluidStack fluidStack = this.fluidTank.getFluid();
        if (fluidStack != null && fluidStack.amount > 0) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            fluidStack.writeToNBT(tagCompound);
            itemStack.func_74782_a("Fluid", (NBTBase)tagCompound);
        }
    }

    @Override
    public ICapabilityProvider initItemStackCapabilities(ItemStack itemStack) {
        return new GTFluidHandlerItemStack(itemStack, this.tankSize).setFilter(this.fluidTank.getFilter());
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        FluidStack fluidStack = this.fluidTank.getFluid();
        buf.writeBoolean(fluidStack != null);
        if (fluidStack != null) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            fluidStack.writeToNBT(tagCompound);
            buf.func_150786_a(tagCompound);
        }
        buf.writeBoolean(this.isAutoOutput);
    }

    @Override
    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        FluidStack fluidStack = null;
        if (buf.readBoolean()) {
            try {
                NBTTagCompound tagCompound = buf.func_150793_b();
                fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fluidTank.setFluid(fluidStack);
        this.isAutoOutput = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_AUTO_OUTPUT) {
            this.isAutoOutput = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.isAutoOutput && this.getOffsetTimer() % 5L == 0L) {
            this.pushFluidsIntoNearbyHandlers(EnumFacing.DOWN);
        }
    }

    @Override
    public boolean onRightClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (playerIn.func_184586_b(hand).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return this.getWorld().field_72995_K || !playerIn.func_70093_af() && FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (IFluidHandler)this.fluidTank);
        }
        return super.onRightClick(playerIn, hand, facing, hitResult);
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing wrenchSide, CuboidRayTraceResult hitResult) {
        if (!playerIn.func_70093_af()) {
            if (this.getWorld().field_72995_K) {
                this.scheduleRenderUpdate();
                return true;
            }
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.drum." + (this.isAutoOutput ? "disable" : "enable") + "_output", new Object[0]), true);
            this.toggleOutput();
            return true;
        }
        return super.onScrewdriverClick(playerIn, hand, wrenchSide, hitResult);
    }

    private void toggleOutput() {
        boolean bl = this.isAutoOutput = !this.isAutoOutput;
        if (!this.getWorld().field_72995_K) {
            this.notifyBlockUpdate();
            this.writeCustomData(GregtechDataCodes.UPDATE_AUTO_OUTPUT, buf -> buf.writeBoolean(this.isAutoOutput));
            this.markDirty();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        if (this.isWood) {
            return Pair.of((Object)Textures.WOODEN_DRUM.getParticleTexture(), (Object)this.getPaintingColorForRendering());
        }
        int color = GTUtility.convertOpaqueRGBA_CLtoRGB(ColourRGBA.multiply((int)GTUtility.convertRGBtoOpaqueRGBA_CL(this.color), (int)GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
        return Pair.of((Object)Textures.DRUM.getParticleTexture(), (Object)color);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        if (this.isWood) {
            ColourMultiplier multiplier = new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()));
            Textures.WOODEN_DRUM.render(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)multiplier), this.getFrontFacing());
        } else {
            ColourMultiplier multiplier = new ColourMultiplier(ColourRGBA.multiply((int)GTUtility.convertRGBtoOpaqueRGBA_CL(this.color), (int)GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
            Textures.DRUM.render(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)multiplier), this.getFrontFacing());
            Textures.DRUM_OVERLAY.render(renderState, translation, pipeline);
        }
        if (this.isAutoOutput) {
            Textures.STEAM_VENT_OVERLAY.renderSided(EnumFacing.DOWN, renderState, translation, pipeline);
        }
    }

    @Override
    public int getDefaultPaintingColor() {
        return 0xFFFFFF;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        NBTTagCompound tagCompound;
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{this.tankSize}));
        this.fluidFilter.appendTooltips(tooltip, true, true);
        if (TooltipHelper.isShiftDown()) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.auto_output_down", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.crowbar", (Object[])new Object[0]));
        }
        if ((tagCompound = stack.func_77978_p()) != null && tagCompound.func_150297_b("Fluid", 10)) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound.func_74775_l("Fluid"));
            if (fluidStack == null) {
                return;
            }
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_tank.fluid", (Object[])new Object[]{fluidStack.amount, fluidStack.getFluid().getLocalizedName(fluidStack)}));
        }
    }

    @Override
    public boolean showToolUsages() {
        return false;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("FluidInventory", (NBTBase)((FluidTank)this.fluidInventory).writeToNBT(new NBTTagCompound()));
        data.func_74757_a("AutoOutput", this.isAutoOutput);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        ((FluidTank)this.fluidInventory).readFromNBT(data.func_74775_l("FluidInventory"));
        this.isAutoOutput = data.func_74767_n("AutoOutput");
    }

    @Override
    protected boolean shouldSerializeInventories() {
        return false;
    }
}

