/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.ILaserContainer;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityCreativeEnergy
extends MetaTileEntity
implements ILaserContainer,
IControllable {
    private long voltage = 0L;
    private int amps = 1;
    private int setTier = 0;
    private boolean active = false;
    private boolean source = true;
    private long lastEnergyIOPerSec = 0L;
    private long energyIOPerSec = 0L;
    private long ampsReceived = 0L;
    private boolean doExplosion = false;

    public MetaTileEntityCreativeEnergy() {
        super(GTUtility.gregtechId("infinite_energy"));
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        IVertexOperation[] renderPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
        Textures.VOLTAGE_CASINGS[14].render(renderState, translation, renderPipeline, Cuboid6.full);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            Textures.INFINITE_EMITTER_FACE.renderSided(face, renderState, translation, pipeline);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.VOLTAGE_CASINGS[this.setTier].getParticleSprite(), (Object)this.getPaintingColorForRendering());
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityCreativeEnergy();
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            return (T)GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER.cast((Object)this);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_LASER) {
            return (T)GregtechTileCapabilities.CAPABILITY_LASER.cast((Object)this);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.defaultBuilder().widget(new CycleButtonWidget(7, 7, 30, 20, GTValues.VNF, () -> this.setTier, tier -> {
            this.setTier = tier;
            this.voltage = GTValues.V[this.setTier];
        }));
        builder.label(7, 32, "gregtech.creative.energy.voltage");
        builder.widget(new ImageWidget(7, 44, 156, 20, GuiTextures.DISPLAY));
        builder.widget(new TextFieldWidget2(9, 50, 152, 16, () -> String.valueOf(this.voltage), value -> {
            if (!value.isEmpty()) {
                this.voltage = Long.parseLong(value);
                this.setTier = GTUtility.getTierByVoltage(this.voltage);
            }
        }).setAllowedChars(TextFieldWidget2.NATURAL_NUMS).setMaxLength(19).setValidator(MetaTileEntityCreativeEnergy.getTextFieldValidator()));
        builder.label(7, 74, "gregtech.creative.energy.amperage");
        builder.widget(new ClickButtonWidget(7, 87, 20, 20, "-", data -> {
            this.amps = --this.amps == -1 ? 0 : this.amps;
        }));
        builder.widget(new ImageWidget(29, 87, 118, 20, GuiTextures.DISPLAY));
        builder.widget(new TextFieldWidget2(31, 93, 114, 16, () -> String.valueOf(this.amps), value -> {
            if (!value.isEmpty()) {
                this.amps = Integer.parseInt(value);
            }
        }).setMaxLength(10).setNumbersOnly(0, Integer.MAX_VALUE));
        builder.widget(new ClickButtonWidget(149, 87, 20, 20, "+", data -> {
            if (this.amps < Integer.MAX_VALUE) {
                ++this.amps;
            }
        }));
        builder.dynamicLabel(7, 110, () -> "Energy I/O per sec: " + this.lastEnergyIOPerSec, 0x232323);
        builder.widget(new CycleButtonWidget(7, 139, 77, 20, () -> this.active, this::setActive, "gregtech.creative.activity.off", "gregtech.creative.activity.on"));
        builder.widget(new CycleButtonWidget(85, 139, 77, 20, () -> this.source, value -> {
            this.source = value;
            if (this.source) {
                this.voltage = 0L;
                this.amps = 0;
                this.setTier = 0;
            } else {
                this.voltage = GTValues.V[14];
                this.amps = Integer.MAX_VALUE;
                this.setTier = 14;
            }
        }, "gregtech.creative.energy.sink", "gregtech.creative.energy.source"));
        return builder.build(this.getHolder(), entityPlayer);
    }

    public void setActive(boolean active) {
        this.active = active;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.UPDATE_ACTIVE, buf -> buf.writeBoolean(active));
            this.markDirty();
        }
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.creative_tooltip.1", (Object[])new Object[0]) + TooltipHelper.RAINBOW + I18n.func_135052_a((String)"gregtech.creative_tooltip.2", (Object[])new Object[0]) + I18n.func_135052_a((String)"gregtech.creative_tooltip.3", (Object[])new Object[0]));
    }

    @Override
    public long getOutputPerSec() {
        return this.lastEnergyIOPerSec;
    }

    @Override
    public void update() {
        super.update();
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (this.getOffsetTimer() % 20L == 0L) {
            this.setIOSpeed(this.energyIOPerSec);
            this.energyIOPerSec = 0L;
            if (this.doExplosion) {
                this.getWorld().func_72876_a(null, (double)this.getPos().func_177958_n() + 0.5, (double)this.getPos().func_177956_o() + 0.5, (double)this.getPos().func_177952_p() + 0.5, 1.0f, false);
                this.doExplosion = false;
            }
        }
        this.ampsReceived = 0L;
        if (!this.active || !this.source || this.voltage <= 0L || this.amps <= 0) {
            return;
        }
        long ampsUsed = 0L;
        for (EnumFacing facing : EnumFacing.values()) {
            EnumFacing opposite = facing.func_176734_d();
            TileEntity tile = this.getNeighbor(facing);
            if (tile == null) continue;
            IEnergyContainer container = (IEnergyContainer)tile.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, opposite);
            if (container == null) {
                container = (IEnergyContainer)tile.getCapability(GregtechTileCapabilities.CAPABILITY_LASER, opposite);
            }
            if (container != null && container.inputsEnergy(opposite) && container.getEnergyCanBeInserted() != 0L && (ampsUsed += container.acceptEnergyFromNetwork(opposite, this.voltage, (long)this.amps - ampsUsed)) >= (long)this.amps) break;
        }
        this.energyIOPerSec += ampsUsed * this.voltage;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data.func_74772_a("Voltage", this.voltage);
        data.func_74768_a("Amps", this.amps);
        data.func_74774_a("Tier", (byte)this.setTier);
        data.func_74757_a("Active", this.active);
        data.func_74757_a("Source", this.source);
        data.func_74772_a("EnergyIOPerSec", this.lastEnergyIOPerSec);
        return super.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.voltage = data.func_74763_f("Voltage");
        this.amps = data.func_74762_e("Amps");
        this.setTier = data.func_74771_c("Tier");
        this.active = data.func_74767_n("Active");
        this.source = data.func_74767_n("Source");
        if (data.func_74764_b("EnergyIOPerSec")) {
            this.lastEnergyIOPerSec = data.func_74763_f("EnergyIOPerSec");
        }
        super.readFromNBT(data);
    }

    @Override
    public long acceptEnergyFromNetwork(EnumFacing side, long voltage, long amperage) {
        if (this.source || !this.active || this.ampsReceived >= (long)this.amps) {
            return 0L;
        }
        if (voltage > this.voltage) {
            if (this.doExplosion) {
                return 0L;
            }
            this.doExplosion = true;
            return Math.min(amperage, this.getInputAmperage() - this.ampsReceived);
        }
        long amperesAccepted = Math.min(amperage, this.getInputAmperage() - this.ampsReceived);
        if (amperesAccepted > 0L) {
            this.ampsReceived += amperesAccepted;
            this.energyIOPerSec += amperesAccepted * voltage;
            return amperesAccepted;
        }
        return 0L;
    }

    @Override
    public boolean inputsEnergy(EnumFacing side) {
        return !this.source;
    }

    @Override
    public boolean outputsEnergy(EnumFacing side) {
        return this.source;
    }

    @Override
    public long changeEnergy(long differenceAmount) {
        if (this.source || !this.active) {
            return 0L;
        }
        this.energyIOPerSec += differenceAmount;
        return differenceAmount;
    }

    @Override
    public long getEnergyStored() {
        return 69L;
    }

    @Override
    public long getEnergyCapacity() {
        return 420L;
    }

    @Override
    public long getInputAmperage() {
        return this.source ? 0L : (long)this.amps;
    }

    @Override
    public long getInputVoltage() {
        return this.source ? 0L : this.voltage;
    }

    @Override
    public long getOutputVoltage() {
        return this.source ? this.voltage : 0L;
    }

    @Override
    public long getOutputAmperage() {
        return this.source ? (long)this.amps : 0L;
    }

    public void setIOSpeed(long energyIOPerSec) {
        if (this.lastEnergyIOPerSec != energyIOPerSec) {
            this.lastEnergyIOPerSec = energyIOPerSec;
            this.writeCustomData(GregtechDataCodes.UPDATE_IO_SPEED, packetBuffer -> packetBuffer.writeLong(energyIOPerSec));
        }
    }

    @Override
    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_IO_SPEED) {
            this.lastEnergyIOPerSec = buf.readLong();
        } else if (dataId == GregtechDataCodes.UPDATE_ACTIVE) {
            this.active = buf.readBoolean();
        }
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.active);
    }

    @Override
    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.active = buf.readBoolean();
    }

    public static Function<String, String> getTextFieldValidator() {
        return val -> {
            long num;
            if (val.isEmpty()) {
                return "0";
            }
            try {
                num = Long.parseLong(val);
            }
            catch (NumberFormatException ignored) {
                return "0";
            }
            if (num < 0L) {
                return "0";
            }
            return val;
        };
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.active;
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        this.setActive(isWorkingAllowed);
    }
}

