/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.layout.Grid;
import gregtech.api.capability.impl.FilteredFluidHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.mui.GTGuis;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.mui.widget.GTFluidSlot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityBuffer
extends MetaTileEntity
implements ITieredMetaTileEntity {
    private static final int TANK_SIZE = 64000;
    private final int tier;
    private FluidTankList fluidTankList;
    private ItemStackHandler itemStackHandler;

    public MetaTileEntityBuffer(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId);
        this.tier = tier;
        this.initializeInventory();
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        FilteredFluidHandler[] fluidHandlers = new FilteredFluidHandler[this.tier + 2];
        for (int i = 0; i < this.tier + 2; ++i) {
            fluidHandlers[i] = new FilteredFluidHandler(64000);
        }
        this.fluidTankList = new FluidTankList(false, (IFluidTank[])fluidHandlers);
        this.fluidInventory = this.fluidTankList;
        this.itemStackHandler = new GTItemStackHandler((MetaTileEntity)this, (int)Math.pow(this.tier + 2, 2.0));
        this.itemInventory = this.itemStackHandler;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityBuffer(this.metaTileEntityId, this.tier);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.VOLTAGE_CASINGS[this.tier].getParticleSprite(), (Object)this.getPaintingColorForRendering());
    }

    @Override
    public boolean usesMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(PosGuiData guiData, PanelSyncManager guiSyncManager) {
        int invTier = this.tier + 2;
        guiSyncManager.registerSlotGroup("item_inv", invTier);
        ArrayList slotWidgets = new ArrayList();
        for (int y = 0; y < invTier; ++y) {
            slotWidgets.add(new ArrayList());
            for (int x = 0; x < invTier; ++x) {
                int index = y * invTier + x;
                ((List)slotWidgets.get(y)).add(new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this.itemStackHandler, (int)index).slotGroup("item_inv")));
            }
        }
        ArrayList tankWidgets = new ArrayList();
        for (int i = 0; i < this.fluidTankList.getTanks(); ++i) {
            tankWidgets.add(new ArrayList());
            ((List)tankWidgets.get(i)).add(new GTFluidSlot().syncHandler(this.fluidTankList.getTankAt(i)));
        }
        return (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)GTGuis.createPanel(this, 176, Math.max(166, 18 + 18 * invTier + 94)).child((IWidget)IKey.lang((String)this.getMetaFullName()).asWidget().pos(5, 5))).child((IWidget)((SlotGroupWidget)SlotGroupWidget.playerInventory().left(7)).bottom(7))).child((IWidget)((Grid)((Grid)((Grid)new Grid().top(18)).height(18 * invTier)).left(7)).minElementMargin(0, 0).minColWidth(18).minRowHeight(18).matrix(slotWidgets))).child((IWidget)((Grid)((Grid)((Grid)new Grid().top(18)).height(18 * invTier)).left(151)).minElementMargin(0, 0).minColWidth(18).minRowHeight(18).matrix(tankWidgets));
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        Textures.VOLTAGE_CASINGS[this.tier].render(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()))));
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            Textures.BUFFER_OVERLAY.renderSided(facing, renderState, translation, pipeline);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74782_a("Inventory", (NBTBase)this.itemStackHandler.serializeNBT());
        tag.func_74782_a("FluidInventory", (NBTBase)this.fluidTankList.serializeNBT());
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.itemStackHandler.deserializeNBT(tag.func_74775_l("Inventory"));
        this.fluidTankList.deserializeNBT(tag.func_74775_l("FluidInventory"));
    }

    @Override
    protected boolean shouldSerializeInventories() {
        return false;
    }

    @Override
    public boolean hasFrontFacing() {
        return false;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.buffer.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.item_storage_capacity", (Object[])new Object[]{(int)Math.pow(this.tier + 2, 2.0)}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity_mult", (Object[])new Object[]{this.tier + 2, 64000}));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    public void clearMachineInventory(@NotNull @NotNull List<@NotNull ItemStack> itemBuffer) {
        MetaTileEntityBuffer.clearInventory(itemBuffer, (IItemHandlerModifiable)this.itemStackHandler);
    }
}

