/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.common.metatileentities.storage.CraftingRecipeLogic;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingRecipeMemory
extends SyncHandler {
    public static final int UPDATE_RECIPES = 1;
    public static final int SYNC_RECIPE = 4;
    public static final int OFFSET_RECIPE = 5;
    public static final int REMOVE_RECIPE = 2;
    public static final int MAKE_RECIPE = 3;
    public static final int UPDATE_LOGIC = 6;
    public static final int MOUSE_CLICK = 2;
    private final Hash.Strategy<ItemStack> strategy = ItemStackHashStrategy.builder().compareItem(true).compareMetadata(true).build();
    private final MemorizedRecipe[] memorizedRecipes;
    private final IItemHandlerModifiable craftingMatrix;

    public CraftingRecipeMemory(int memorySize, IItemHandlerModifiable craftingMatrix) {
        this.memorizedRecipes = new MemorizedRecipe[memorySize];
        this.craftingMatrix = craftingMatrix;
    }

    public void loadRecipe(int index) {
        MemorizedRecipe recipe = this.memorizedRecipes[index];
        if (recipe != null) {
            CraftingRecipeMemory.copyInventoryItems((IItemHandler)recipe.craftingMatrix, this.craftingMatrix);
            this.getRecipeLogic().updateCurrentRecipe();
            this.syncToClient(6);
        }
    }

    public CraftingRecipeLogic getRecipeLogic() {
        return (CraftingRecipeLogic)this.getSyncManager().getSyncHandler("recipe_logic:0");
    }

    @Nullable
    public MemorizedRecipe getRecipeAtIndex(int index) {
        return this.memorizedRecipes[index];
    }

    @NotNull
    public ItemStack getRecipeOutputAtIndex(int index) {
        return this.hasRecipe(index) ? this.getRecipeAtIndex(index).getRecipeResult() : ItemStack.field_190927_a;
    }

    private void offsetRecipe(int startIndex) {
        MemorizedRecipe previousRecipe = this.removeRecipe(startIndex);
        if (previousRecipe == null) {
            return;
        }
        for (int i = startIndex + 1; i < this.memorizedRecipes.length; ++i) {
            MemorizedRecipe recipe = this.memorizedRecipes[i];
            if (recipe != null && recipe.recipeLocked) continue;
            this.memorizedRecipes[i] = previousRecipe;
            this.memorizedRecipes[i].index = i;
            if (recipe == null) {
                return;
            }
            previousRecipe = recipe;
        }
    }

    @Nullable
    private MemorizedRecipe findOrCreateRecipe(ItemStack resultItemStack) {
        MemorizedRecipe existing = null;
        for (MemorizedRecipe memorizedRecipe : this.memorizedRecipes) {
            if (memorizedRecipe == null || !this.strategy.equals((Object)memorizedRecipe.recipeResult, (Object)resultItemStack)) continue;
            existing = memorizedRecipe;
            break;
        }
        if (existing != null) {
            if (existing.index == 0 || existing.recipeLocked) {
                return existing;
            }
            int removed = existing.index;
            this.removeRecipe(existing.index);
            this.syncToClient(2, buffer -> buffer.writeByte(removed));
            this.offsetRecipe(0);
            this.syncToClient(5, buffer -> buffer.writeByte(0));
            existing.index = 0;
            this.memorizedRecipes[0] = existing;
            return this.memorizedRecipes[0];
        }
        for (int i = 0; i < this.memorizedRecipes.length; ++i) {
            MemorizedRecipe memorizedRecipe;
            if (this.memorizedRecipes[i] == null) {
                memorizedRecipe = new MemorizedRecipe(i);
            } else {
                if (this.memorizedRecipes[i].recipeLocked) continue;
                this.offsetRecipe(i);
                memorizedRecipe = new MemorizedRecipe(i);
                this.syncToClient(5, buffer -> buffer.writeByte(memorizedRecipe.index));
            }
            memorizedRecipe.initialize(resultItemStack);
            this.memorizedRecipes[i] = memorizedRecipe;
            return this.memorizedRecipes[i];
        }
        return null;
    }

    public void notifyRecipePerformed(IItemHandler craftingGrid, ItemStack resultStack) {
        MemorizedRecipe recipe = this.findOrCreateRecipe(resultStack);
        if (recipe != null) {
            recipe.updateCraftingMatrix(craftingGrid);
            ++recipe.timesUsed;
            this.syncToClient(4, x$0 -> recipe.writeToBuffer(x$0));
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        NBTTagList resultList = new NBTTagList();
        tagCompound.func_74782_a("Memory", (NBTBase)resultList);
        for (int i = 0; i < this.memorizedRecipes.length; ++i) {
            MemorizedRecipe recipe = this.memorizedRecipes[i];
            if (recipe == null) continue;
            NBTTagCompound entryComponent = new NBTTagCompound();
            entryComponent.func_74768_a("Slot", i);
            entryComponent.func_74782_a("Recipe", (NBTBase)recipe.serializeNBT());
            resultList.func_74742_a((NBTBase)entryComponent);
        }
        return tagCompound;
    }

    public void deserializeNBT(NBTTagCompound tagCompound) {
        NBTTagList resultList = tagCompound.func_150295_c("Memory", 10);
        for (int i = 0; i < resultList.func_74745_c(); ++i) {
            MemorizedRecipe recipe;
            NBTTagCompound entryComponent = resultList.func_150305_b(i);
            int slotIndex = entryComponent.func_74762_e("Slot");
            this.memorizedRecipes[slotIndex] = recipe = MemorizedRecipe.deserializeNBT(entryComponent.func_74775_l("Recipe"), slotIndex);
        }
    }

    private static void copyInventoryItems(IItemHandler src, IItemHandlerModifiable dest) {
        for (int i = 0; i < src.getSlots(); ++i) {
            ItemStack itemStack = src.getStackInSlot(i);
            dest.setStackInSlot(i, itemStack.func_190926_b() ? ItemStack.field_190927_a : itemStack.func_77946_l());
        }
    }

    public final MemorizedRecipe removeRecipe(int index) {
        if (this.hasRecipe(index)) {
            MemorizedRecipe removed = this.memorizedRecipes[index];
            this.memorizedRecipes[index] = null;
            return removed;
        }
        return null;
    }

    public final boolean hasRecipe(int index) {
        return this.memorizedRecipes[index] != null;
    }

    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        this.writeRecipes(buf);
    }

    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        this.readRecipes(buf);
    }

    public void readOnClient(int id, PacketBuffer buf) {
        if (id == 1) {
            this.readRecipes(buf);
        } else if (id == 2) {
            this.removeRecipe(buf.readByte());
        } else if (id == 3) {
            byte index = buf.readByte();
            MemorizedRecipe recipe = this.memorizedRecipes[index];
            if (recipe == null) {
                recipe = new MemorizedRecipe(index);
            }
            recipe.recipeResult = NetworkUtils.readItemStack((PacketBuffer)buf);
            recipe.index = index;
            this.memorizedRecipes[index] = recipe;
        } else if (id == 4) {
            MemorizedRecipe recipe;
            this.memorizedRecipes[recipe.index] = recipe = MemorizedRecipe.fromBuffer(buf);
        } else if (id == 5) {
            this.offsetRecipe(buf.readByte());
        } else if (id == 6) {
            this.getRecipeLogic().updateCurrentRecipe();
        }
    }

    public void writeRecipes(PacketBuffer buf) {
        Int2ObjectOpenHashMap written = new Int2ObjectOpenHashMap();
        for (int i = 0; i < this.memorizedRecipes.length; ++i) {
            ItemStack stack = this.getRecipeOutputAtIndex(i);
            if (stack.func_190926_b()) continue;
            written.put(i, stack);
        }
        buf.writeByte(written.size());
        for (Map.Entry entry : written.entrySet()) {
            MemorizedRecipe recipe = this.memorizedRecipes[(Integer)entry.getKey()];
            buf.writeByte(recipe.index);
            NetworkUtils.writeItemStack((PacketBuffer)buf, (ItemStack)recipe.recipeResult);
            buf.writeInt(recipe.timesUsed);
            buf.writeBoolean(recipe.isRecipeLocked());
        }
    }

    public void readRecipes(PacketBuffer buf) {
        int size = buf.readByte();
        for (int i = 0; i < size; ++i) {
            byte index = buf.readByte();
            if (!this.hasRecipe(index)) {
                this.memorizedRecipes[index] = new MemorizedRecipe(index);
            }
            this.memorizedRecipes[index].recipeResult = NetworkUtils.readItemStack((PacketBuffer)buf);
            this.memorizedRecipes[index].timesUsed = buf.readInt();
            this.memorizedRecipes[index].recipeLocked = buf.readBoolean();
        }
    }

    public void readOnServer(int id, PacketBuffer buf) {
        if (id == 1) {
            this.syncToClient(1, this::writeRecipes);
        } else if (id == 2) {
            byte index = buf.readByte();
            MouseData data = MouseData.readPacket((PacketBuffer)buf);
            MemorizedRecipe recipe = this.getRecipeAtIndex(index);
            if (recipe == null) {
                return;
            }
            if (data.shift && data.mouseButton == 0) {
                recipe.setRecipeLocked(!recipe.isRecipeLocked());
            } else if (data.mouseButton == 0) {
                this.loadRecipe(index);
            } else if (data.mouseButton == 1 && !recipe.isRecipeLocked()) {
                this.removeRecipe(index);
            }
        }
    }

    public static class MemorizedRecipe {
        private final ItemStackHandler craftingMatrix = new ItemStackHandler(9);
        private ItemStack recipeResult = ItemStack.field_190927_a;
        private boolean recipeLocked = false;
        public int timesUsed = 0;
        public int index;

        private MemorizedRecipe(int index) {
            this.index = index;
        }

        private NBTTagCompound serializeNBT() {
            NBTTagCompound result = new NBTTagCompound();
            result.func_74782_a("Result", (NBTBase)this.recipeResult.serializeNBT());
            result.func_74782_a("Matrix", (NBTBase)this.craftingMatrix.serializeNBT());
            result.func_74757_a("Locked", this.recipeLocked);
            result.func_74768_a("TimesUsed", this.timesUsed);
            return result;
        }

        private static MemorizedRecipe deserializeNBT(NBTTagCompound tagCompound, int index) {
            MemorizedRecipe recipe = new MemorizedRecipe(index);
            recipe.recipeResult = new ItemStack(tagCompound.func_74775_l("Result"));
            recipe.craftingMatrix.deserializeNBT(tagCompound.func_74775_l("Matrix"));
            recipe.recipeLocked = tagCompound.func_74767_n("Locked");
            recipe.timesUsed = tagCompound.func_74762_e("TimesUsed");
            return recipe;
        }

        private void writeToBuffer(PacketBuffer buffer) {
            buffer.writeByte(this.index);
            buffer.writeInt(this.timesUsed);
            buffer.writeBoolean(this.recipeLocked);
            NetworkUtils.writeItemStack((PacketBuffer)buffer, (ItemStack)this.recipeResult);
        }

        @NotNull
        private static MemorizedRecipe fromBuffer(PacketBuffer buffer) {
            MemorizedRecipe recipe = new MemorizedRecipe(buffer.readByte());
            recipe.timesUsed = buffer.readInt();
            recipe.recipeLocked = buffer.readBoolean();
            recipe.recipeResult = NetworkUtils.readItemStack((PacketBuffer)buffer);
            return recipe;
        }

        private void initialize(ItemStack recipeResult) {
            this.recipeResult = recipeResult.func_77946_l();
            for (int i = 0; i < this.craftingMatrix.getSlots(); ++i) {
                this.craftingMatrix.setStackInSlot(i, ItemStack.field_190927_a);
            }
            this.recipeLocked = false;
            this.timesUsed = 0;
        }

        private void updateCraftingMatrix(IItemHandler craftingGrid) {
            if (!this.recipeLocked) {
                CraftingRecipeMemory.copyInventoryItems(craftingGrid, (IItemHandlerModifiable)this.craftingMatrix);
            }
        }

        public ItemStack getRecipeResult() {
            return this.recipeResult;
        }

        public boolean isRecipeLocked() {
            return this.recipeLocked;
        }

        public void setRecipeLocked(boolean recipeLocked) {
            this.recipeLocked = recipeLocked;
        }

        public MemorizedRecipe copy() {
            MemorizedRecipe recipe = new MemorizedRecipe(this.index);
            recipe.initialize(this.recipeResult);
            recipe.updateCraftingMatrix((IItemHandler)this.craftingMatrix);
            recipe.recipeLocked = this.recipeLocked;
            recipe.timesUsed = this.timesUsed;
            return recipe;
        }

        public String toString() {
            return String.format("MemorizedRecipe{%dx %s, locked: %s, times used: %d}", this.getRecipeResult().func_190916_E(), this.getRecipeResult().func_82833_r(), this.recipeLocked, this.timesUsed);
        }
    }
}

