/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import gregtech.api.items.toolitem.ItemGTToolbelt;
import gregtech.api.util.DummyContainer;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.common.crafting.ShapedOreEnergyTransferRecipe;
import gregtech.common.metatileentities.storage.CachedRecipeData;
import gregtech.common.mui.widget.workbench.CraftingInputSlot;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CraftingRecipeLogic
extends SyncHandler {
    public static final int UPDATE_INGREDIENTS = 1;
    public static final int RESET_INGREDIENTS = 2;
    public static final int SYNC_STACK = 3;
    public static final int UPDATE_MATRIX = 0;
    private final World world;
    private IItemHandlerModifiable availableHandlers;
    private final Hash.Strategy<ItemStack> strategy = ItemStackHashStrategy.builder().compareItem(true).compareMetadata(true).build();
    private final Map<ItemStack, Set<Integer>> stackLookupMap = new Object2ObjectOpenCustomHashMap(this.strategy);
    private final Map<ItemStack, Integer> requiredItems = new Object2IntOpenCustomHashMap(this.strategy);
    private final Int2IntMap compactedIndexes = new Int2IntArrayMap(9);
    private final Int2IntMap slotMap = new Int2IntArrayMap();
    private final Int2ObjectMap<Object2BooleanMap<ItemStack>> replaceAttemptMap = new Int2ObjectArrayMap();
    private final InventoryCrafting craftingMatrix;
    private final IInventory craftingResultInventory = new InventoryCraftResult();
    private final CachedRecipeData cachedRecipeData;
    private final CraftingInputSlot[] inputSlots = new CraftingInputSlot[9];

    public CraftingRecipeLogic(World world, IItemHandlerModifiable handlers, IItemHandlerModifiable craftingMatrix) {
        this.world = world;
        this.availableHandlers = handlers;
        this.craftingMatrix = CraftingRecipeLogic.wrapHandler(craftingMatrix);
        this.cachedRecipeData = new CachedRecipeData();
    }

    public IInventory getCraftingResultInventory() {
        return this.craftingResultInventory;
    }

    public InventoryCrafting getCraftingMatrix() {
        return this.craftingMatrix;
    }

    public void updateSlotMap(int offset, int slot) {
        this.slotMap.put(offset + slot, this.slotMap.size());
    }

    public void clearSlotMap() {
        this.slotMap.clear();
    }

    public void updateInventory(IItemHandlerModifiable handler) {
        this.availableHandlers = handler;
    }

    public void clearCraftingGrid() {
        this.fillCraftingGrid(Collections.emptyMap());
    }

    public void fillCraftingGrid(Map<Integer, ItemStack> ingredients) {
        for (int i = 0; i < this.craftingMatrix.func_70302_i_(); ++i) {
            this.craftingMatrix.func_70299_a(i, ingredients.getOrDefault(i, ItemStack.field_190927_a));
        }
        this.syncMatrix();
        this.updateCurrentRecipe();
    }

    public void setInputSlot(CraftingInputSlot slot, int index) {
        this.inputSlots[index] = slot;
    }

    public boolean performRecipe() {
        return this.isRecipeValid() && this.attemptMatchRecipe() && this.consumeRecipeItems();
    }

    public boolean isRecipeValid() {
        return this.cachedRecipeData.getRecipe() != null && this.cachedRecipeData.matches(this.craftingMatrix, this.world);
    }

    public boolean attemptMatchRecipe() {
        for (CraftingInputSlot slot : this.inputSlots) {
            if (slot.hasIngredients) continue;
            return false;
        }
        return true;
    }

    protected boolean consumeRecipeItems() {
        if (this.requiredItems.isEmpty()) {
            return false;
        }
        Int2IntOpenHashMap gatheredItems = new Int2IntOpenHashMap();
        for (Map.Entry<ItemStack, Integer> entry : this.requiredItems.entrySet()) {
            ItemStack stack = entry.getKey();
            int requestedAmount = entry.getValue();
            Set<Integer> slotList = this.stackLookupMap.get(stack);
            int extractedAmount = 0;
            for (int slot : slotList) {
                ItemStack extracted = this.availableHandlers.extractItem(slot, requestedAmount, true);
                gatheredItems.put(slot, extracted.func_190916_E());
                extractedAmount += extracted.func_190916_E();
                if ((requestedAmount -= extracted.func_190916_E()) != 0) continue;
                break;
            }
            if (extractedAmount >= requestedAmount) continue;
            return false;
        }
        boolean extracted = false;
        for (Map.Entry gathered : gatheredItems.entrySet()) {
            int slot = (Integer)gathered.getKey();
            int amount = (Integer)gathered.getValue();
            ItemStack stack = this.availableHandlers.getStackInSlot(slot);
            boolean hasContainer = stack.func_77973_b().hasContainerItem(stack);
            if (hasContainer && stack.func_190916_E() > 1) {
                ItemStack useStack = stack.func_77979_a(1);
                ItemStack newStack = ForgeHooks.getContainerItem((ItemStack)useStack);
                if (newStack.func_190926_b()) {
                    return false;
                }
                GTTransferUtils.insertItem((IItemHandler)this.availableHandlers, newStack, false);
            } else if (hasContainer) {
                ItemStack usedStack = ForgeHooks.getContainerItem((ItemStack)stack);
                this.availableHandlers.setStackInSlot(slot, usedStack);
            } else {
                this.availableHandlers.extractItem(slot, amount, false);
            }
            extracted = true;
        }
        return extracted;
    }

    public ItemStack findSubstitute(int craftingIndex, ItemStack stack) {
        Object2BooleanMap map = (Object2BooleanMap)this.replaceAttemptMap.computeIfAbsent((Object)craftingIndex, m -> new Object2BooleanOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount()));
        ItemStack substitute = ItemStack.field_190927_a;
        IRecipe recipe = this.getCachedRecipe();
        int index = this.compactedIndexes.get(craftingIndex);
        for (int i = 0; i < this.availableHandlers.getSlots(); ++i) {
            ItemStack itemStack = this.availableHandlers.getStackInSlot(i);
            if (itemStack.func_190926_b() || this.strategy.equals((Object)itemStack, (Object)stack)) continue;
            boolean matchedPreviously = false;
            if (map.containsKey((Object)itemStack) && map.getBoolean((Object)itemStack)) {
                matchedPreviously = true;
            }
            if (itemStack.func_77973_b() instanceof ItemGTToolbelt) {
                ItemGTToolbelt.setCraftingSlot(this.slotMap.get(i), (EntityPlayerMP)this.getSyncManager().getPlayer());
            }
            if (!matchedPreviously) {
                boolean matched = false;
                if (!(recipe instanceof IShapedRecipe)) {
                    for (Ingredient ing : recipe.func_192400_c()) {
                        if (!ing.apply(itemStack)) continue;
                        matched = true;
                        break;
                    }
                } else {
                    matched = this.cachedRecipeData.canIngredientApply(index, itemStack);
                }
                if (!matched) {
                    map.put((Object)GTUtility.copy(1, itemStack), false);
                    continue;
                }
            }
            ItemStack previousResult = recipe.func_77572_b(this.craftingMatrix);
            this.craftingMatrix.func_70299_a(craftingIndex, itemStack);
            ItemStack newResult = recipe.func_77572_b(this.craftingMatrix);
            if (this.cachedRecipeData.matches(this.craftingMatrix, this.world) && ItemStack.func_77989_b((ItemStack)newResult, (ItemStack)previousResult) || recipe instanceof ShapedOreEnergyTransferRecipe) {
                this.craftingMatrix.func_70299_a(craftingIndex, stack);
                map.put((Object)GTUtility.copy(1, itemStack), true);
                substitute = itemStack;
                break;
            }
            map.put((Object)GTUtility.copy(1, itemStack), false);
            this.craftingMatrix.func_70299_a(craftingIndex, stack);
        }
        return substitute;
    }

    private boolean simulateExtractItem(int craftingIndex, ItemStack itemStack, int count) {
        if (itemStack.func_190926_b()) {
            return true;
        }
        if (!this.stackLookupMap.containsKey(itemStack)) {
            return false;
        }
        int extracted = 0;
        for (int slot : this.stackLookupMap.get(itemStack)) {
            ItemStack slotStack = this.availableHandlers.extractItem(slot, count, true);
            if (slotStack.func_77973_b() instanceof ItemGTToolbelt) {
                ItemGTToolbelt.setCraftingSlot(this.slotMap.get(slot), (EntityPlayerMP)this.getSyncManager().getPlayer());
            }
            if (!this.cachedRecipeData.canIngredientApply(this.compactedIndexes.get(craftingIndex), slotStack) || (extracted += slotStack.func_190916_E()) < count) continue;
            return true;
        }
        return false;
    }

    public void updateCurrentRecipe() {
        if (!this.cachedRecipeData.matches(this.craftingMatrix, this.world)) {
            IRecipe newRecipe = CraftingManager.func_192413_b((InventoryCrafting)this.craftingMatrix, (World)this.world);
            ItemStack resultStack = ItemStack.field_190927_a;
            if (newRecipe != null) {
                resultStack = newRecipe.func_77572_b(this.craftingMatrix);
            }
            this.craftingResultInventory.func_70299_a(0, resultStack);
            this.cachedRecipeData.setRecipe(newRecipe);
        }
    }

    public IRecipe getCachedRecipe() {
        return this.cachedRecipeData.getRecipe();
    }

    public void detectAndSendChanges(boolean init) {
        IRecipe recipe = this.getCachedRecipe();
        if (recipe == null) {
            IRecipe prevRecipe = this.cachedRecipeData.getPreviousRecipe();
            if (prevRecipe == null) {
                return;
            }
            this.cachedRecipeData.setRecipe(null);
            for (CraftingInputSlot inputSlot : this.inputSlots) {
                inputSlot.hasIngredients = true;
            }
            this.syncToClient(2);
            return;
        }
        this.compactedIndexes.clear();
        this.requiredItems.clear();
        this.refreshStackMap();
        Int2BooleanArrayMap map = new Int2BooleanArrayMap();
        int next = 0;
        for (CraftingInputSlot slot : this.inputSlots) {
            boolean hadIngredients = slot.hasIngredients;
            ItemStack slotStack = slot.getStack();
            if (slotStack.func_190926_b()) {
                if (hadIngredients) continue;
                slot.hasIngredients = true;
                map.put(slot.getIndex(), slot.hasIngredients);
                continue;
            }
            this.compactedIndexes.put(slot.getIndex(), next++);
            int count = this.requiredItems.getOrDefault(slotStack, 0) + 1;
            slot.hasIngredients = this.simulateExtractItem(slot.getIndex(), slotStack, count);
            if (slot.hasIngredients) {
                this.requiredItems.put(GTUtility.copy(1, slotStack), count);
            } else {
                ItemStack substitute = this.findSubstitute(slot.getIndex(), slotStack);
                if (!substitute.func_190926_b()) {
                    count = this.requiredItems.getOrDefault(substitute, 0) + 1;
                    slot.hasIngredients = this.simulateExtractItem(slot.getIndex(), substitute, count);
                    this.requiredItems.put(GTUtility.copy(1, substitute), count);
                }
            }
            if (hadIngredients == slot.hasIngredients) continue;
            map.put(slot.getIndex(), slot.hasIngredients);
        }
        if (!map.isEmpty()) {
            this.syncToClient(1, arg_0 -> CraftingRecipeLogic.lambda$detectAndSendChanges$1((Map)map, arg_0));
        }
    }

    public void refreshStackMap() {
        this.stackLookupMap.clear();
        for (int i = 0; i < this.availableHandlers.getSlots(); ++i) {
            IntArraySet slots;
            ItemStack curStack = this.availableHandlers.getStackInSlot(i);
            if (curStack.func_190926_b()) continue;
            if (this.stackLookupMap.containsKey(curStack)) {
                slots = this.stackLookupMap.get(curStack);
            } else {
                slots = new IntArraySet();
                this.stackLookupMap.put(GTUtility.copy(1, curStack), (Set<Integer>)slots);
            }
            slots.add(i);
        }
    }

    public void writeMatrix(PacketBuffer buffer) {
        buffer.func_150787_b(this.craftingMatrix.func_70302_i_());
        for (int i = 0; i < this.craftingMatrix.func_70302_i_(); ++i) {
            NetworkUtils.writeItemStack((PacketBuffer)buffer, (ItemStack)this.craftingMatrix.func_70301_a(i));
        }
    }

    public void readOnClient(int id, PacketBuffer buf) {
        block3: {
            block4: {
                block2: {
                    if (id != 1) break block2;
                    int size = buf.readByte();
                    for (int i = 0; i < size; ++i) {
                        this.inputSlots[buf.readByte()].hasIngredients = buf.readBoolean();
                    }
                    break block3;
                }
                if (id != 3) break block4;
                this.getSyncManager().setCursorItem(NetworkUtils.readItemStack((PacketBuffer)buf));
                break block3;
            }
            if (id != 2) break block3;
            for (CraftingInputSlot inputSlot : this.inputSlots) {
                inputSlot.hasIngredients = true;
            }
        }
    }

    public void readOnServer(int id, PacketBuffer buf) {
        if (id == 0) {
            int size = buf.func_150792_a();
            for (int i = 0; i < size; ++i) {
                this.craftingMatrix.func_70299_a(i, NetworkUtils.readItemStack((PacketBuffer)buf));
            }
            this.updateCurrentRecipe();
        }
    }

    public void syncMatrix() {
        if (this.getSyncManager().isClient()) {
            this.syncToServer(0, this::writeMatrix);
        }
    }

    public static InventoryCrafting wrapHandler(final IItemHandlerModifiable handler) {
        return new InventoryCrafting(new DummyContainer(), 3, 3){

            public ItemStack func_70463_b(int row, int column) {
                int index = row + 3 * column;
                return handler.getStackInSlot(index);
            }

            public ItemStack func_70301_a(int index) {
                return handler.getStackInSlot(index);
            }

            public void func_70299_a(int index, ItemStack stack) {
                handler.setStackInSlot(index, GTUtility.copy(1, stack));
            }
        };
    }

    private static /* synthetic */ void lambda$detectAndSendChanges$1(Map map, PacketBuffer buffer) throws IOException {
        buffer.writeByte(map.size());
        for (Map.Entry set : map.entrySet()) {
            buffer.writeByte(((Integer)set.getKey()).intValue());
            buffer.writeBoolean(((Boolean)set.getValue()).booleanValue());
        }
    }
}

