/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import gregtech.api.util.GTLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class CachedRecipeData {
    private IRecipe recipe;
    private IRecipe previousRecipe;
    private final List<Ingredient> recipeIngredients = new ArrayList<Ingredient>();

    public CachedRecipeData() {
        this(null);
    }

    public CachedRecipeData(@Nullable IRecipe recipe) {
        this.recipe = recipe;
    }

    public boolean matches(InventoryCrafting inventoryCrafting, World world) {
        if (this.recipe == null) {
            return false;
        }
        return this.recipe.func_77569_a(inventoryCrafting, world);
    }

    public void setRecipe(IRecipe newRecipe) {
        this.previousRecipe = this.recipe;
        this.recipe = newRecipe;
        this.recipeIngredients.clear();
        if (newRecipe != null) {
            this.recipeIngredients.addAll((Collection<Ingredient>)newRecipe.func_192400_c());
            this.recipeIngredients.removeIf(ing -> ing == Ingredient.field_193370_a);
        }
    }

    public IRecipe getRecipe() {
        return this.recipe;
    }

    public IRecipe getPreviousRecipe() {
        return this.previousRecipe;
    }

    public boolean canIngredientApply(int index, ItemStack stack) {
        if (this.recipeIngredients.isEmpty()) {
            return false;
        }
        if (index < 0 || index >= this.recipeIngredients.size()) {
            GTLog.logger.warn("Compacted index \"{}\" is out of bounds for list size \"{}\"", (Object)index, (Object)this.recipeIngredients.size());
            return false;
        }
        return this.recipeIngredients.get(index).apply(stack);
    }
}

