/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.steam.boiler;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.impl.CommonFluidFilters;
import gregtech.api.capability.impl.FilteredFluidHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.FluidContainerSlotWidget;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.IDataInfoProvider;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.particle.VanillaParticleEffects;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleSidedCubeRenderer;
import gregtech.common.ConfigHolder;
import gregtech.core.sound.GTSoundEvents;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SteamBoiler
extends MetaTileEntity
implements IDataInfoProvider {
    private static final Pattern STRING_SUBSTITUTION_PATTERN = Pattern.compile("%s", 16);
    private static final EnumFacing[] STEAM_PUSH_DIRECTIONS = (EnumFacing[])ArrayUtils.add((Object[])EnumFacing.field_176754_o, (Object)EnumFacing.UP);
    public final TextureArea bronzeSlotBackgroundTexture;
    public final TextureArea slotFurnaceBackground;
    protected final boolean isHighPressure;
    private final ICubeRenderer renderer;
    protected FluidTank waterFluidTank;
    protected FluidTank steamFluidTank;
    private int fuelBurnTimeLeft;
    private int fuelMaxBurnTime;
    private int currentTemperature;
    private boolean hasNoWater;
    private int timeBeforeCoolingDown;
    private boolean isBurning;
    private boolean wasBurningAndNeedsUpdate;
    private final ItemStackHandler containerInventory;

    public SteamBoiler(ResourceLocation metaTileEntityId, boolean isHighPressure, ICubeRenderer renderer) {
        super(metaTileEntityId);
        this.renderer = renderer;
        this.isHighPressure = isHighPressure;
        this.bronzeSlotBackgroundTexture = this.getGuiTexture("slot_%s");
        this.slotFurnaceBackground = this.getGuiTexture("slot_%s_furnace_background");
        this.containerInventory = new GTItemStackHandler((MetaTileEntity)this, 2);
    }

    @Override
    public boolean isActive() {
        return this.isBurning;
    }

    @SideOnly(value=Side.CLIENT)
    protected SimpleSidedCubeRenderer getBaseRenderer() {
        if (this.isHighPressure) {
            return Textures.STEAM_BRICKED_CASING_STEEL;
        }
        return Textures.STEAM_BRICKED_CASING_BRONZE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)this.getBaseRenderer().getParticleSprite(), (Object)this.getPaintingColorForRendering());
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        IVertexOperation[] colouredPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
        this.getBaseRenderer().render(renderState, translation, colouredPipeline);
        this.renderer.renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isBurning(), true);
    }

    @Override
    public int getDefaultPaintingColor() {
        return 0xFFFFFF;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("FuelBurnTimeLeft", this.fuelBurnTimeLeft);
        data.func_74768_a("FuelMaxBurnTime", this.fuelMaxBurnTime);
        data.func_74768_a("CurrentTemperature", this.currentTemperature);
        data.func_74757_a("HasNoWater", this.hasNoWater);
        data.func_74782_a("ContainerInventory", (NBTBase)this.containerInventory.serializeNBT());
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.fuelBurnTimeLeft = data.func_74762_e("FuelBurnTimeLeft");
        this.fuelMaxBurnTime = data.func_74762_e("FuelMaxBurnTime");
        this.currentTemperature = data.func_74762_e("CurrentTemperature");
        this.hasNoWater = data.func_74767_n("HasNoWater");
        this.containerInventory.deserializeNBT(data.func_74775_l("ContainerInventory"));
        this.isBurning = this.fuelBurnTimeLeft > 0;
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isBurning);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isBurning = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.IS_WORKING) {
            this.isBurning = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    public void setFuelMaxBurnTime(int fuelMaxBurnTime) {
        this.fuelMaxBurnTime = fuelMaxBurnTime;
        this.fuelBurnTimeLeft = fuelMaxBurnTime;
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            this.updateCurrentTemperature();
            if (this.getOffsetTimer() % 10L == 0L) {
                this.generateSteam();
            }
            GTTransferUtils.fillInternalTankFromFluidContainer(this.importFluids, (IItemHandlerModifiable)this.containerInventory, 0, 1);
            if (this.getOffsetTimer() % 5L == 0L) {
                this.pushFluidsIntoNearbyHandlers(STEAM_PUSH_DIRECTIONS);
            }
            if (this.fuelMaxBurnTime <= 0) {
                this.tryConsumeNewFuel();
                if (this.fuelBurnTimeLeft > 0) {
                    if (this.wasBurningAndNeedsUpdate) {
                        this.wasBurningAndNeedsUpdate = false;
                    } else {
                        this.setBurning(true);
                    }
                }
            }
            if (this.wasBurningAndNeedsUpdate) {
                this.wasBurningAndNeedsUpdate = false;
                this.setBurning(false);
            }
        }
    }

    private void updateCurrentTemperature() {
        if (this.fuelMaxBurnTime > 0) {
            if (this.getOffsetTimer() % 12L == 0L) {
                if (this.fuelBurnTimeLeft % 2 == 0 && this.currentTemperature < this.getMaxTemperate()) {
                    ++this.currentTemperature;
                }
                this.fuelBurnTimeLeft -= this.isHighPressure ? 2 : 1;
                if (this.fuelBurnTimeLeft <= 0) {
                    this.fuelMaxBurnTime = 0;
                    this.timeBeforeCoolingDown = this.getCooldownInterval();
                    this.wasBurningAndNeedsUpdate = true;
                }
            }
        } else if (this.timeBeforeCoolingDown == 0) {
            if (this.currentTemperature > 0) {
                this.currentTemperature -= this.getCoolDownRate();
                this.timeBeforeCoolingDown = this.getCooldownInterval();
            }
        } else {
            --this.timeBeforeCoolingDown;
        }
    }

    protected abstract int getBaseSteamOutput();

    public int getTotalSteamOutput() {
        if (this.currentTemperature < 100) {
            return 0;
        }
        return (int)((double)this.getBaseSteamOutput() * ((double)this.currentTemperature / ((double)this.getMaxTemperate() * 1.0)) / 2.0);
    }

    public boolean hasWater() {
        return !this.hasNoWater;
    }

    private void generateSteam() {
        if (this.currentTemperature >= 100) {
            int fillAmount = this.getTotalSteamOutput();
            boolean hasDrainedWater = this.waterFluidTank.drain(1, true) != null;
            int filledSteam = 0;
            if (hasDrainedWater) {
                filledSteam = this.steamFluidTank.fill(Materials.Steam.getFluid(fillAmount), true);
            }
            if (this.hasNoWater && hasDrainedWater) {
                this.doExplosion(2.0f);
            } else {
                boolean bl = this.hasNoWater = !hasDrainedWater;
            }
            if (filledSteam == 0 && hasDrainedWater) {
                float x = (float)this.getPos().func_177958_n() + 0.5f;
                float y = (float)this.getPos().func_177956_o() + 0.5f;
                float z = (float)this.getPos().func_177952_p() + 0.5f;
                ((WorldServer)this.getWorld()).func_175739_a(EnumParticleTypes.CLOUD, (double)x + (double)this.getFrontFacing().func_82601_c() * 0.6, (double)y + (double)this.getFrontFacing().func_96559_d() * 0.6, (double)z + (double)this.getFrontFacing().func_82599_e() * 0.6, 7 + GTValues.RNG.nextInt(3), (double)this.getFrontFacing().func_82601_c() / 2.0, (double)this.getFrontFacing().func_96559_d() / 2.0, (double)this.getFrontFacing().func_82599_e() / 2.0, 0.1, new int[0]);
                if (ConfigHolder.machines.machineSounds && !this.isMuffled()) {
                    this.getWorld().func_184148_a(null, (double)x, (double)y, (double)z, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                this.steamFluidTank.drain(4000, true);
            }
        } else {
            this.hasNoWater = this.waterFluidTank.getFluidAmount() == 0;
        }
    }

    public boolean isBurning() {
        return this.isBurning;
    }

    public void setBurning(boolean burning) {
        this.isBurning = burning;
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
            this.writeCustomData(GregtechDataCodes.IS_WORKING, buf -> buf.writeBoolean(burning));
        }
    }

    protected abstract void tryConsumeNewFuel();

    protected abstract int getCooldownInterval();

    protected abstract int getCoolDownRate();

    public int getMaxTemperate() {
        return this.isHighPressure ? 1000 : 500;
    }

    public double getTemperaturePercent() {
        return (double)this.currentTemperature / ((double)this.getMaxTemperate() * 1.0);
    }

    public int getCurrentTemperature() {
        return this.currentTemperature;
    }

    public double getFuelLeftPercent() {
        return this.fuelMaxBurnTime == 0 ? 0.0 : (double)this.fuelBurnTimeLeft / ((double)this.fuelMaxBurnTime * 1.0);
    }

    @Override
    protected FluidTankList createImportFluidHandler() {
        this.waterFluidTank = new FilteredFluidHandler(16000).setFilter(CommonFluidFilters.BOILER_FLUID);
        return new FluidTankList(false, new IFluidTank[]{this.waterFluidTank});
    }

    @Override
    protected FluidTankList createExportFluidHandler() {
        this.steamFluidTank = new FluidTank(16000);
        return new FluidTankList(false, new IFluidTank[]{this.steamFluidTank});
    }

    protected TextureArea getGuiTexture(String pathTemplate) {
        String type = this.isHighPressure ? "steel" : "bronze";
        return TextureArea.fullImage(String.format("textures/gui/steam/%s/%s.png", type, STRING_SUBSTITUTION_PATTERN.matcher(pathTemplate).replaceAll(Matcher.quoteReplacement(type))));
    }

    public ModularUI.Builder createUITemplate(EntityPlayer player) {
        return ModularUI.builder(GuiTextures.BACKGROUND_STEAM.get(this.isHighPressure), 176, 166).label(6, 6, this.getMetaFullName()).shouldColor(false).widget(new ProgressWidget(this::getTemperaturePercent, 96, 26, 10, 54).setProgressBar(GuiTextures.PROGRESS_BAR_BOILER_EMPTY.get(this.isHighPressure), GuiTextures.PROGRESS_BAR_BOILER_HEAT, ProgressWidget.MoveType.VERTICAL)).widget(new TankWidget((IFluidTank)this.waterFluidTank, 83, 26, 10, 54).setBackgroundTexture(GuiTextures.PROGRESS_BAR_BOILER_EMPTY.get(this.isHighPressure))).widget(new TankWidget((IFluidTank)this.steamFluidTank, 70, 26, 10, 54).setBackgroundTexture(GuiTextures.PROGRESS_BAR_BOILER_EMPTY.get(this.isHighPressure))).widget(new FluidContainerSlotWidget((IItemHandlerModifiable)this.containerInventory, 0, 43, 26, true).setBackgroundTexture(GuiTextures.SLOT_STEAM.get(this.isHighPressure), GuiTextures.IN_SLOT_OVERLAY_STEAM.get(this.isHighPressure))).slot((IItemHandlerModifiable)this.containerInventory, 1, 43, 62, true, false, GuiTextures.SLOT_STEAM.get(this.isHighPressure), GuiTextures.OUT_SLOT_OVERLAY_STEAM.get(this.isHighPressure)).image(43, 44, 18, 18, GuiTextures.CANISTER_OVERLAY_STEAM.get(this.isHighPressure)).bindPlayerInventory(player.field_71071_by, GuiTextures.SLOT_STEAM.get(this.isHighPressure), 0);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(String.format("%s %s", I18n.func_135052_a((String)"gregtech.universal.tooltip.produces_fluid", (Object[])new Object[]{this.getBaseSteamOutput() / 20}), Materials.Steam.getLocalizedName()));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    public SoundEvent getSound() {
        return GTSoundEvents.BOILER;
    }

    @Override
    public void clearMachineInventory(@NotNull @NotNull List<@NotNull ItemStack> itemBuffer) {
        super.clearMachineInventory(itemBuffer);
        SteamBoiler.clearInventory(itemBuffer, (IItemHandlerModifiable)this.containerInventory);
    }

    @Override
    @NotNull
    public List<ITextComponent> getDataInfo() {
        return Collections.singletonList(new TextComponentTranslation("gregtech.machine.steam_boiler.heat_amount", new Object[]{TextFormattingUtil.formatNumbers((int)(this.getTemperaturePercent() * 100.0))}));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick() {
        if (this.isActive()) {
            EnumParticleTypes smokeParticle = this.isHighPressure ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL;
            VanillaParticleEffects.defaultFrontEffect((MetaTileEntity)this, smokeParticle, EnumParticleTypes.FLAME);
            if (ConfigHolder.machines.machineSounds && GTValues.RNG.nextDouble() < 0.1) {
                BlockPos pos = this.getPos();
                this.getWorld().func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
        }
    }
}

