/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.steam;

import gregtech.api.GTValues;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SteamMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.RecipeMaps;
import gregtech.client.particle.VanillaParticleEffects;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class SteamFurnace
extends SteamMetaTileEntity {
    public SteamFurnace(ResourceLocation metaTileEntityId, boolean isHighPressure) {
        super(metaTileEntityId, RecipeMaps.FURNACE_RECIPES, Textures.FURNACE_OVERLAY, isHighPressure);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new SteamFurnace(this.metaTileEntityId, this.isHighPressure);
    }

    @Override
    protected boolean isBrickedCasing() {
        return true;
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new NotifiableItemStackHandler(this, 1, this, false);
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new NotifiableItemStackHandler(this, 1, this, true);
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        return this.createUITemplate(player).slot(this.importItems, 0, 53, 25, GuiTextures.SLOT_STEAM.get(this.isHighPressure), GuiTextures.FURNACE_OVERLAY_STEAM.get(this.isHighPressure)).progressBar(this.workableHandler::getProgressPercent, 79, 26, 20, 16, GuiTextures.PROGRESS_BAR_ARROW_STEAM.get(this.isHighPressure), ProgressWidget.MoveType.HORIZONTAL, this.workableHandler.getRecipeMap()).slot(this.exportItems, 0, 107, 25, true, false, GuiTextures.SLOT_STEAM.get(this.isHighPressure)).build(this.getHolder(), player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick() {
        if (this.isActive()) {
            EnumParticleTypes smokeParticle = this.isHighPressure ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL;
            VanillaParticleEffects.defaultFrontEffect((MetaTileEntity)this, 0.5f, smokeParticle, EnumParticleTypes.FLAME);
            if (ConfigHolder.machines.machineSounds && GTValues.RNG.nextDouble() < 0.1) {
                BlockPos pos = this.getPos();
                this.getWorld().func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
        }
    }
}

