/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.appeng;

import appeng.api.config.Actionable;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ImageCycleButtonWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.MetaTileEntityMEInputHatch;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.ExportOnlyAEFluidList;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.ExportOnlyAEFluidSlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.stack.WrappedFluidStack;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityMEStockingHatch
extends MetaTileEntityMEInputHatch {
    private static final int CONFIG_SIZE = 16;
    private boolean autoPull;
    private Predicate<FluidStack> autoPullTest = $ -> false;

    public MetaTileEntityMEStockingHatch(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, 5);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityMEStockingHatch(this.metaTileEntityId);
    }

    @Override
    protected ExportOnlyAEStockingFluidList getAEFluidHandler() {
        if (this.aeFluidHandler == null) {
            this.aeFluidHandler = new ExportOnlyAEStockingFluidList(this, 16, (MetaTileEntity)this.getController());
        }
        return (ExportOnlyAEStockingFluidList)this.aeFluidHandler;
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            if (this.isWorkingEnabled() && this.autoPull && this.getOffsetTimer() % 100L == 0L) {
                this.refreshList();
                this.syncME();
            }
            if (this.meStatusChanged && !this.isOnline) {
                if (this.autoPull) {
                    this.getAEFluidHandler().clearConfig();
                } else {
                    for (int i = 0; i < 16; ++i) {
                        this.getAEFluidHandler().getInventory()[i].setStack((IAEFluidStack)null);
                    }
                }
            }
        }
    }

    @Override
    protected void syncME() {
        IMEMonitor monitor = super.getMonitor();
        if (monitor == null) {
            return;
        }
        for (ExportOnlyAEStockingFluidSlot slot : this.getAEFluidHandler().getInventory()) {
            IAEFluidStack request;
            if (slot.getConfig() == null) {
                slot.setStack((IAEFluidStack)null);
                continue;
            }
            Object t = slot.getConfig();
            if (t instanceof WrappedFluidStack) {
                WrappedFluidStack wfs = (WrappedFluidStack)t;
                request = wfs.getAEStack();
            } else {
                request = ((IAEFluidStack)slot.getConfig()).copy();
            }
            request.setStackSize(Integer.MAX_VALUE);
            IAEFluidStack result = (IAEFluidStack)monitor.extractItems((IAEStack)request, Actionable.SIMULATE, this.getActionSource());
            slot.setStack(result);
        }
    }

    @Override
    protected void flushInventory() {
    }

    @Override
    public void addToMultiBlock(MultiblockControllerBase controllerBase) {
        super.addToMultiBlock(controllerBase);
        this.autoPullTest = stack -> !this.testConfiguredInOtherHatch((FluidStack)stack);
        this.validateConfig();
    }

    @Override
    public void removeFromMultiBlock(MultiblockControllerBase controllerBase) {
        this.autoPullTest = $ -> false;
        if (this.autoPull) {
            this.getAEFluidHandler().clearConfig();
        }
        super.removeFromMultiBlock(controllerBase);
    }

    private void validateConfig() {
        for (ExportOnlyAEStockingFluidSlot slot : this.getAEFluidHandler().getInventory()) {
            FluidStack configuredStack;
            if (slot.getConfig() == null || !this.testConfiguredInOtherHatch(configuredStack = ((IAEFluidStack)slot.getConfig()).getFluidStack())) continue;
            slot.setConfig(null);
            slot.setStock(null);
        }
    }

    private boolean testConfiguredInOtherHatch(FluidStack stack) {
        if (stack == null) {
            return false;
        }
        MultiblockControllerBase controller = this.getController();
        if (controller == null) {
            return false;
        }
        List<IFluidTank> abilityList = controller.getAbilities(MultiblockAbility.IMPORT_FLUIDS);
        for (IFluidTank ability : abilityList) {
            ExportOnlyAEStockingFluidSlot aeSlot;
            if (!(ability instanceof ExportOnlyAEStockingFluidSlot) || (aeSlot = (ExportOnlyAEStockingFluidSlot)ability).getConfig() == null || this.getAEFluidHandler().ownsSlot(aeSlot) || !((IAEFluidStack)aeSlot.getConfig()).getFluid().equals(stack.getFluid())) continue;
            return true;
        }
        return false;
    }

    private void setAutoPull(boolean autoPull) {
        this.autoPull = autoPull;
        this.markDirty();
        if (!this.getWorld().field_72995_K) {
            if (!this.autoPull) {
                this.getAEFluidHandler().clearConfig();
            } else if (this.updateMEStatus()) {
                this.refreshList();
                this.syncME();
            }
            this.writeCustomData(GregtechDataCodes.UPDATE_AUTO_PULL, buf -> buf.writeBoolean(this.autoPull));
        }
    }

    private void refreshList() {
        IMEMonitor monitor = this.getMonitor();
        if (monitor == null) {
            this.clearInventory(0);
            return;
        }
        IItemList storageList = monitor.getStorageList();
        if (storageList == null) {
            this.clearInventory(0);
            return;
        }
        int index = 0;
        for (IAEFluidStack stack : storageList) {
            FluidStack fluidStack;
            if (index >= 16) break;
            if (stack.getStackSize() == 0L || (stack = (IAEFluidStack)monitor.extractItems((IAEStack)stack, Actionable.SIMULATE, this.getActionSource())) == null || stack.getStackSize() == 0L || (fluidStack = stack.getFluidStack()) == null || this.autoPullTest != null && !this.autoPullTest.test(fluidStack)) continue;
            WrappedFluidStack selectedStack = WrappedFluidStack.fromFluidStack(fluidStack);
            IAEFluidStack configStack = (IAEFluidStack)selectedStack.copy().setStackSize(1L);
            ExportOnlyAEStockingFluidSlot slot = this.getAEFluidHandler().getInventory()[index];
            slot.setConfig(configStack);
            slot.setStack(selectedStack);
            ++index;
        }
        this.clearInventory(index);
    }

    private void clearInventory(int startIndex) {
        for (int i = startIndex; i < 16; ++i) {
            ExportOnlyAEStockingFluidSlot slot = this.getAEFluidHandler().getInventory()[i];
            slot.setConfig(null);
            slot.setStack((IAEFluidStack)null);
        }
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_AUTO_PULL) {
            this.autoPull = buf.readBoolean();
        }
    }

    @Override
    protected ModularUI.Builder createUITemplate(EntityPlayer player) {
        ModularUI.Builder builder = super.createUITemplate(player);
        builder.widget(new ImageCycleButtonWidget(80, 26, 16, 16, GuiTextures.BUTTON_AUTO_PULL, () -> this.autoPull, this::setAutoPull).setTooltipHoverString("gregtech.gui.me_bus.auto_pull_button"));
        return builder;
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!this.getWorld().field_72995_K) {
            this.setAutoPull(!this.autoPull);
            if (this.autoPull) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.me.stocking_auto_pull_enabled", new Object[0]), false);
            } else {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.me.stocking_auto_pull_disabled", new Object[0]), false);
            }
        }
        return true;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("AutoPull", this.autoPull);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.autoPull = data.func_74767_n("AutoPull");
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.autoPull);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.autoPull = buf.readBoolean();
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_hatch.import.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.stocking_fluid.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me_import_fluid_hatch.configs.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.copy_paste.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.stocking_fluid.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.extra_connections.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    @Override
    protected NBTTagCompound writeConfigToTag() {
        if (!this.autoPull) {
            NBTTagCompound tag = super.writeConfigToTag();
            tag.func_74757_a("AutoPull", false);
            return tag;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("AutoPull", true);
        return tag;
    }

    @Override
    protected void readConfigFromTag(NBTTagCompound tag) {
        if (tag.func_74767_n("AutoPull")) {
            this.setAutoPull(true);
            return;
        }
        this.setAutoPull(false);
        super.readConfigFromTag(tag);
    }

    private static class ExportOnlyAEStockingFluidList
    extends ExportOnlyAEFluidList {
        private final MetaTileEntityMEStockingHatch holder;

        public ExportOnlyAEStockingFluidList(MetaTileEntityMEStockingHatch holder, int slots, MetaTileEntity entityToNotify) {
            super(holder, slots, entityToNotify);
            this.holder = holder;
        }

        @Override
        protected void createInventory(MetaTileEntity holder, MetaTileEntity entityToNotify) {
            if (!(holder instanceof MetaTileEntityMEStockingHatch)) {
                throw new IllegalArgumentException("Cannot create Stocking Fluid List for nonstocking MetaTileEntity!");
            }
            MetaTileEntityMEStockingHatch stocking = (MetaTileEntityMEStockingHatch)holder;
            this.inventory = new ExportOnlyAEStockingFluidSlot[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.inventory[i] = new ExportOnlyAEStockingFluidSlot(stocking, entityToNotify);
            }
        }

        public ExportOnlyAEStockingFluidSlot[] getInventory() {
            return (ExportOnlyAEStockingFluidSlot[])super.getInventory();
        }

        @Override
        public boolean isStocking() {
            return true;
        }

        @Override
        public boolean isAutoPull() {
            return this.holder.autoPull;
        }

        @Override
        public boolean hasStackInConfig(FluidStack stack, boolean checkExternal) {
            boolean inThisHatch = super.hasStackInConfig(stack, false);
            if (inThisHatch) {
                return true;
            }
            if (checkExternal) {
                return this.holder.testConfiguredInOtherHatch(stack);
            }
            return false;
        }
    }

    private static class ExportOnlyAEStockingFluidSlot
    extends ExportOnlyAEFluidSlot {
        public ExportOnlyAEStockingFluidSlot(MetaTileEntityMEStockingHatch holder, IAEFluidStack config, IAEFluidStack stock, MetaTileEntity entityToNotify) {
            super(holder, config, stock, entityToNotify);
        }

        public ExportOnlyAEStockingFluidSlot(MetaTileEntityMEStockingHatch holder, MetaTileEntity entityToNotify) {
            super(holder, entityToNotify);
        }

        @Override
        protected MetaTileEntityMEStockingHatch getHolder() {
            return (MetaTileEntityMEStockingHatch)super.getHolder();
        }

        @Override
        public ExportOnlyAEFluidSlot copy() {
            return new ExportOnlyAEStockingFluidSlot(this.getHolder(), this.config == null ? null : ((IAEFluidStack)this.config).copy(), this.stock == null ? null : ((IAEFluidStack)this.stock).copy(), null);
        }

        @Override
        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.stock == null) {
                return null;
            }
            if (this.config != null) {
                IAEFluidStack request;
                IMEMonitor monitor = this.getHolder().getMonitor();
                if (monitor == null) {
                    return null;
                }
                Actionable action = doDrain ? Actionable.MODULATE : Actionable.SIMULATE;
                IAEStack iAEStack = this.config;
                if (iAEStack instanceof WrappedFluidStack) {
                    WrappedFluidStack wfs = (WrappedFluidStack)iAEStack;
                    request = wfs.getAEStack();
                } else {
                    request = ((IAEFluidStack)this.config).copy();
                }
                request.setStackSize((long)maxDrain);
                IAEFluidStack result = (IAEFluidStack)monitor.extractItems((IAEStack)request, action, this.getHolder().getActionSource());
                if (result != null) {
                    int extracted = (int)Math.min(result.getStackSize(), (long)maxDrain);
                    ((IAEFluidStack)this.stock).decStackSize((long)extracted);
                    this.trigger();
                    if (extracted != 0) {
                        FluidStack resultStack = ((IAEFluidStack)this.config).getFluidStack();
                        resultStack.amount = extracted;
                        return resultStack;
                    }
                }
            }
            return null;
        }
    }
}

