/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.appeng;

import appeng.api.config.Actionable;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.fluids.util.AEFluidStack;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.INotifiableHandler;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.gui.widget.appeng.AEFluidGridWidget;
import gregtech.common.inventory.appeng.SerializableFluidList;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.MetaTileEntityAEHostablePart;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityMEOutputHatch
extends MetaTileEntityAEHostablePart<IAEFluidStack>
implements IMultiblockAbilityPart<IFluidTank> {
    public static final String FLUID_BUFFER_TAG = "FluidBuffer";
    public static final String WORKING_TAG = "WorkingEnabled";
    private boolean workingEnabled = true;
    private SerializableFluidList internalBuffer;

    public MetaTileEntityMEOutputHatch(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, 4, true, IFluidStorageChannel.class);
    }

    @Override
    protected void initializeInventory() {
        this.internalBuffer = new SerializableFluidList();
        super.initializeInventory();
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.workingEnabled && this.shouldSyncME() && this.updateMEStatus()) {
            if (this.internalBuffer.isEmpty()) {
                return;
            }
            IMEMonitor monitor = this.getMonitor();
            if (monitor == null) {
                return;
            }
            Iterator<IAEFluidStack> iterator = this.internalBuffer.iterator();
            while (iterator.hasNext()) {
                IAEFluidStack fluid = iterator.next();
                IAEFluidStack notInserted = (IAEFluidStack)monitor.injectItems((IAEStack)fluid.copy(), Actionable.MODULATE, this.getActionSource());
                if (notInserted != null && notInserted.getStackSize() > 0L) {
                    fluid.setStackSize(notInserted.getStackSize());
                    continue;
                }
                fluid.reset();
            }
        }
    }

    @Override
    public void onRemoval() {
        IMEMonitor monitor = this.getMonitor();
        if (monitor == null) {
            return;
        }
        Iterator<IAEFluidStack> iterator = this.internalBuffer.iterator();
        while (iterator.hasNext()) {
            IAEFluidStack fluid = iterator.next();
            monitor.injectItems((IAEStack)fluid.copy(), Actionable.MODULATE, this.getActionSource());
        }
        super.onRemoval();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityMEOutputHatch(this.metaTileEntityId);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 184).label(10, 5, this.getMetaFullName());
        builder.dynamicLabel(10, 15, () -> this.isOnline ? I18n.func_135052_a((String)"gregtech.gui.me_network.online", (Object[])new Object[0]) : I18n.func_135052_a((String)"gregtech.gui.me_network.offline", (Object[])new Object[0]), 0x404040);
        builder.label(10, 25, "gregtech.gui.waiting_list", -1);
        builder.widget(new AEFluidGridWidget(10, 35, 3, this.internalBuffer));
        builder.bindPlayerInventory(entityPlayer.field_71071_by, GuiTextures.SLOT, 7, 102);
        return builder.build(this.getHolder(), entityPlayer);
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.workingEnabled = workingEnabled;
        World world = this.getWorld();
        if (world != null && !world.field_72995_K) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(workingEnabled));
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.workingEnabled);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.workingEnabled = buf.readBoolean();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a(WORKING_TAG, this.workingEnabled);
        data.func_74782_a(FLUID_BUFFER_TAG, (NBTBase)this.internalBuffer.serializeNBT());
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(WORKING_TAG)) {
            this.workingEnabled = data.func_74767_n(WORKING_TAG);
        }
        if (data.func_150297_b(FLUID_BUFFER_TAG, 9)) {
            this.internalBuffer.deserializeNBT((NBTTagList)data.func_74781_a(FLUID_BUFFER_TAG));
        }
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            if (this.isOnline) {
                Textures.ME_OUTPUT_HATCH_ACTIVE.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            } else {
                Textures.ME_OUTPUT_HATCH.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            }
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_hatch.export.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.fluid_export.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.fluid_export.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.extra_connections.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    @Override
    public MultiblockAbility<IFluidTank> getAbility() {
        return MultiblockAbility.EXPORT_FLUIDS;
    }

    @Override
    public void registerAbilities(@NotNull AbilityInstances abilityInstances) {
        abilityInstances.add(new InaccessibleInfiniteTank(this, this.internalBuffer, this.getController()));
    }

    @Override
    public void addToMultiBlock(MultiblockControllerBase controllerBase) {
        super.addToMultiBlock(controllerBase);
        if (controllerBase instanceof MultiblockWithDisplayBase) {
            ((MultiblockWithDisplayBase)controllerBase).enableFluidInfSink();
        }
    }

    private static class InaccessibleInfiniteTank
    implements IFluidTank,
    INotifiableHandler {
        private final IItemList<IAEFluidStack> internalBuffer;
        private final List<MetaTileEntity> notifiableEntities = new ArrayList<MetaTileEntity>();
        private final MetaTileEntity holder;

        public InaccessibleInfiniteTank(MetaTileEntity holder, IItemList<IAEFluidStack> internalBuffer, MetaTileEntity mte) {
            this.holder = holder;
            this.internalBuffer = internalBuffer;
            this.notifiableEntities.add(mte);
        }

        @Nullable
        public FluidStack getFluid() {
            return null;
        }

        public int getFluidAmount() {
            return 0;
        }

        public int getCapacity() {
            return 0x7FFFFFFE;
        }

        public FluidTankInfo getInfo() {
            return null;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            if (doFill) {
                this.internalBuffer.add((IAEStack)AEFluidStack.fromFluidStack((FluidStack)resource));
                this.holder.markDirty();
            }
            this.trigger();
            return resource.amount;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        @Override
        public void addNotifiableMetaTileEntity(MetaTileEntity metaTileEntity) {
            this.notifiableEntities.add(metaTileEntity);
        }

        @Override
        public void removeNotifiableMetaTileEntity(MetaTileEntity metaTileEntity) {
            this.notifiableEntities.remove(metaTileEntity);
        }

        private void trigger() {
            for (MetaTileEntity metaTileEntity : this.notifiableEntities) {
                if (metaTileEntity == null || !metaTileEntity.isValid()) continue;
                this.addToNotifiedList(metaTileEntity, this, true);
            }
        }
    }
}

