/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.appeng;

import appeng.api.config.Actionable;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IDataStickIntractable;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.gui.widget.appeng.AEFluidConfigWidget;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.MetaTileEntityAEHostablePart;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.ExportOnlyAEFluidList;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.ExportOnlyAEFluidSlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.stack.WrappedFluidStack;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityMEInputHatch
extends MetaTileEntityAEHostablePart<IAEFluidStack>
implements IMultiblockAbilityPart<IFluidTank>,
IDataStickIntractable {
    public static final String FLUID_BUFFER_TAG = "FluidTanks";
    public static final String WORKING_TAG = "WorkingEnabled";
    private static final int CONFIG_SIZE = 16;
    private boolean workingEnabled = true;
    protected ExportOnlyAEFluidList aeFluidHandler;

    public MetaTileEntityMEInputHatch(ResourceLocation metaTileEntityId) {
        this(metaTileEntityId, 4);
    }

    protected MetaTileEntityMEInputHatch(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier, false, IFluidStorageChannel.class);
    }

    protected ExportOnlyAEFluidList getAEFluidHandler() {
        if (this.aeFluidHandler == null) {
            this.aeFluidHandler = new ExportOnlyAEFluidList(this, 16, this.getController());
        }
        return this.aeFluidHandler;
    }

    @Override
    protected void initializeInventory() {
        this.getAEFluidHandler();
        super.initializeInventory();
    }

    @Override
    protected FluidTankList createImportFluidHandler() {
        return new FluidTankList(false, this.getAEFluidHandler().getInventory());
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.workingEnabled && this.shouldSyncME() && this.updateMEStatus()) {
            this.syncME();
        }
    }

    protected void syncME() {
        IMEMonitor monitor = this.getMonitor();
        if (monitor == null) {
            return;
        }
        for (ExportOnlyAEFluidSlot aeTank : this.getAEFluidHandler().getInventory()) {
            IAEFluidStack extracted;
            IAEFluidStack reqFluid;
            IAEFluidStack exceedFluid = aeTank.exceedStack();
            if (exceedFluid != null) {
                long total = exceedFluid.getStackSize();
                IAEFluidStack notInserted = (IAEFluidStack)monitor.injectItems((IAEStack)exceedFluid, Actionable.MODULATE, this.getActionSource());
                if (notInserted != null && notInserted.getStackSize() > 0L) {
                    aeTank.drain((int)(total - notInserted.getStackSize()), true);
                    continue;
                }
                aeTank.drain((int)total, true);
            }
            if ((reqFluid = aeTank.requestStack()) == null || (extracted = (IAEFluidStack)monitor.extractItems((IAEStack)reqFluid, Actionable.MODULATE, this.getActionSource())) == null) continue;
            aeTank.addStack(extracted);
        }
    }

    @Override
    public void onRemoval() {
        this.flushInventory();
        super.onRemoval();
    }

    protected void flushInventory() {
        IMEMonitor monitor = this.getMonitor();
        if (monitor == null) {
            return;
        }
        for (ExportOnlyAEFluidSlot aeTank : this.getAEFluidHandler().getInventory()) {
            IAEFluidStack stock = (IAEFluidStack)aeTank.getStock();
            if (stock instanceof WrappedFluidStack) {
                stock = ((WrappedFluidStack)stock).getAEStack();
            }
            if (stock == null) continue;
            monitor.injectItems((IAEStack)stock, Actionable.MODULATE, this.getActionSource());
        }
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityMEInputHatch(this.metaTileEntityId);
    }

    @Override
    protected final ModularUI createUI(EntityPlayer player) {
        ModularUI.Builder builder = this.createUITemplate(player);
        return builder.build(this.getHolder(), player);
    }

    protected ModularUI.Builder createUITemplate(EntityPlayer player) {
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 184).label(10, 5, this.getMetaFullName());
        builder.dynamicLabel(10, 15, () -> this.isOnline ? I18n.func_135052_a((String)"gregtech.gui.me_network.online", (Object[])new Object[0]) : I18n.func_135052_a((String)"gregtech.gui.me_network.offline", (Object[])new Object[0]), 0x404040);
        builder.widget(new AEFluidConfigWidget(7, 25, this.getAEFluidHandler()));
        builder.image(79, 43, 18, 18, GuiTextures.ARROW_DOUBLE);
        builder.widget(new ImageWidget(79, 79, 17, 17, GTValues.XMAS.get() != false ? GuiTextures.GREGTECH_LOGO_XMAS : GuiTextures.GREGTECH_LOGO).setIgnoreColor(true));
        builder.bindPlayerInventory(player.field_71071_by, GuiTextures.SLOT, 7, 102);
        return builder;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.workingEnabled = workingEnabled;
        World world = this.getWorld();
        if (world != null && !world.field_72995_K) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(workingEnabled));
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.workingEnabled);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.workingEnabled = buf.readBoolean();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a(WORKING_TAG, this.workingEnabled);
        NBTTagList tanks = new NBTTagList();
        for (int i = 0; i < 16; ++i) {
            ExportOnlyAEFluidSlot tank = this.getAEFluidHandler().getInventory()[i];
            NBTTagCompound tankTag = new NBTTagCompound();
            tankTag.func_74768_a("slot", i);
            tankTag.func_74782_a("tank", (NBTBase)tank.serializeNBT());
            tanks.func_74742_a((NBTBase)tankTag);
        }
        data.func_74782_a(FLUID_BUFFER_TAG, (NBTBase)tanks);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(WORKING_TAG)) {
            this.workingEnabled = data.func_74767_n(WORKING_TAG);
        }
        if (data.func_150297_b(FLUID_BUFFER_TAG, 9)) {
            NBTTagList tanks = (NBTTagList)data.func_74781_a(FLUID_BUFFER_TAG);
            for (NBTBase nbtBase : tanks) {
                NBTTagCompound tankTag = (NBTTagCompound)nbtBase;
                ExportOnlyAEFluidSlot tank = this.getAEFluidHandler().getInventory()[tankTag.func_74762_e("slot")];
                tank.deserializeNBT(tankTag.func_74775_l("tank"));
            }
        }
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            if (this.isOnline) {
                Textures.ME_INPUT_HATCH_ACTIVE.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            } else {
                Textures.ME_INPUT_HATCH.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            }
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_hatch.import.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.fluid_import.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me_import_fluid_hatch.configs.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.copy_paste.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.extra_connections.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    @Override
    public MultiblockAbility<IFluidTank> getAbility() {
        return MultiblockAbility.IMPORT_FLUIDS;
    }

    @Override
    public void registerAbilities(@NotNull AbilityInstances abilityInstances) {
        abilityInstances.addAll(Arrays.asList(this.getAEFluidHandler().getInventory()));
    }

    @Override
    public final void onDataStickLeftClick(EntityPlayer player, ItemStack dataStick) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("MEInputHatch", (NBTBase)this.writeConfigToTag());
        dataStick.func_77982_d(tag);
        dataStick.func_190924_f("gregtech.machine.me.fluid_import.data_stick.name");
        player.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.me.import_copy_settings", new Object[0]), true);
    }

    protected NBTTagCompound writeConfigToTag() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound configStacks = new NBTTagCompound();
        tag.func_74782_a("ConfigStacks", (NBTBase)configStacks);
        for (int i = 0; i < 16; ++i) {
            ExportOnlyAEFluidSlot slot = this.aeFluidHandler.getInventory()[i];
            IAEFluidStack config = (IAEFluidStack)slot.getConfig();
            if (config == null) continue;
            NBTTagCompound stackNbt = new NBTTagCompound();
            config.writeToNBT(stackNbt);
            configStacks.func_74782_a(Integer.toString(i), (NBTBase)stackNbt);
        }
        return tag;
    }

    @Override
    public final boolean onDataStickRightClick(EntityPlayer player, ItemStack dataStick) {
        NBTTagCompound tag = dataStick.func_77978_p();
        if (tag == null || !tag.func_74764_b("MEInputHatch")) {
            return false;
        }
        this.readConfigFromTag(tag.func_74775_l("MEInputHatch"));
        this.syncME();
        player.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.me.import_paste_settings", new Object[0]), true);
        return true;
    }

    protected void readConfigFromTag(NBTTagCompound tag) {
        if (tag.func_74764_b("ConfigStacks")) {
            NBTTagCompound configStacks = tag.func_74775_l("ConfigStacks");
            for (int i = 0; i < 16; ++i) {
                String key = Integer.toString(i);
                if (configStacks.func_74764_b(key)) {
                    NBTTagCompound configTag = configStacks.func_74775_l(key);
                    this.aeFluidHandler.getInventory()[i].setConfig(WrappedFluidStack.fromNBT(configTag));
                    continue;
                }
                this.aeFluidHandler.getInventory()[i].setConfig(null);
            }
        }
    }
}

