/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.appeng;

import appeng.api.config.Actionable;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IDataStickIntractable;
import gregtech.api.capability.IGhostSlotConfigurable;
import gregtech.api.capability.INotifiableHandler;
import gregtech.api.capability.impl.GhostCircuitItemStackHandler;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.GhostCircuitSlotWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.gui.widget.appeng.AEItemConfigWidget;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.MetaTileEntityAEHostablePart;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.ExportOnlyAEItemList;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.ExportOnlyAEItemSlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.stack.WrappedItemStack;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityMEInputBus
extends MetaTileEntityAEHostablePart<IAEItemStack>
implements IMultiblockAbilityPart<IItemHandlerModifiable>,
IGhostSlotConfigurable,
IDataStickIntractable {
    public static final String ITEM_BUFFER_TAG = "ItemSlots";
    public static final String WORKING_TAG = "WorkingEnabled";
    private static final int CONFIG_SIZE = 16;
    private boolean workingEnabled = true;
    protected ExportOnlyAEItemList aeItemHandler;
    protected GhostCircuitItemStackHandler circuitInventory;
    protected NotifiableItemStackHandler extraSlotInventory;
    private ItemHandlerList actualImportItems;

    public MetaTileEntityMEInputBus(ResourceLocation metaTileEntityId) {
        this(metaTileEntityId, 4);
    }

    protected MetaTileEntityMEInputBus(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier, false, IItemStorageChannel.class);
    }

    protected ExportOnlyAEItemList getAEItemHandler() {
        if (this.aeItemHandler == null) {
            this.aeItemHandler = new ExportOnlyAEItemList(this, 16, this.getController());
        }
        return this.aeItemHandler;
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        this.aeItemHandler = this.getAEItemHandler();
        this.circuitInventory = new GhostCircuitItemStackHandler(this);
        this.circuitInventory.addNotifiableMetaTileEntity(this);
        this.extraSlotInventory = new NotifiableItemStackHandler(this, 1, this, false);
        this.extraSlotInventory.addNotifiableMetaTileEntity(this);
        this.actualImportItems = new ItemHandlerList(Arrays.asList(this.aeItemHandler, this.circuitInventory, this.extraSlotInventory));
        this.importItems = this.actualImportItems;
    }

    @Override
    public IItemHandlerModifiable getImportItems() {
        return this.actualImportItems;
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.workingEnabled && this.updateMEStatus() && this.shouldSyncME()) {
            this.syncME();
        }
    }

    protected void syncME() {
        IMEMonitor monitor = this.getMonitor();
        if (monitor == null) {
            return;
        }
        for (ExportOnlyAEItemSlot aeSlot : this.getAEItemHandler().getInventory()) {
            IAEItemStack extracted;
            IAEItemStack reqItem;
            IAEItemStack exceedItem = aeSlot.exceedStack();
            if (exceedItem != null) {
                long total = exceedItem.getStackSize();
                IAEItemStack notInserted = (IAEItemStack)monitor.injectItems((IAEStack)exceedItem, Actionable.MODULATE, this.getActionSource());
                if (notInserted != null && notInserted.getStackSize() > 0L) {
                    aeSlot.extractItem(0, (int)(total - notInserted.getStackSize()), false);
                    continue;
                }
                aeSlot.extractItem(0, (int)total, false);
            }
            if ((reqItem = aeSlot.requestStack()) == null || (extracted = (IAEItemStack)monitor.extractItems((IAEStack)reqItem, Actionable.MODULATE, this.getActionSource())) == null) continue;
            aeSlot.addStack(extracted);
        }
    }

    @Override
    public void onRemoval() {
        this.flushInventory();
        super.onRemoval();
    }

    protected void flushInventory() {
        IMEMonitor monitor = this.getMonitor();
        if (monitor == null) {
            return;
        }
        for (ExportOnlyAEItemSlot aeSlot : this.getAEItemHandler().getInventory()) {
            IAEItemStack stock = (IAEItemStack)aeSlot.getStock();
            if (stock instanceof WrappedItemStack) {
                stock = ((WrappedItemStack)stock).getAEStack();
            }
            if (stock == null) continue;
            monitor.injectItems((IAEStack)stock, Actionable.MODULATE, this.getActionSource());
        }
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityMEInputBus(this.metaTileEntityId);
    }

    @Override
    public void addToMultiBlock(MultiblockControllerBase controllerBase) {
        super.addToMultiBlock(controllerBase);
        for (IItemHandler handler : this.actualImportItems.getBackingHandlers()) {
            if (!(handler instanceof INotifiableHandler)) continue;
            INotifiableHandler notifiable = (INotifiableHandler)handler;
            notifiable.addNotifiableMetaTileEntity(controllerBase);
            notifiable.addToNotifiedList(this, handler, false);
        }
    }

    @Override
    public void removeFromMultiBlock(MultiblockControllerBase controllerBase) {
        super.removeFromMultiBlock(controllerBase);
        for (IItemHandler handler : this.actualImportItems.getBackingHandlers()) {
            if (!(handler instanceof INotifiableHandler)) continue;
            INotifiableHandler notifiable = (INotifiableHandler)handler;
            notifiable.removeNotifiableMetaTileEntity(controllerBase);
        }
    }

    @Override
    protected final ModularUI createUI(EntityPlayer player) {
        ModularUI.Builder builder = this.createUITemplate(player);
        return builder.build(this.getHolder(), player);
    }

    protected ModularUI.Builder createUITemplate(EntityPlayer player) {
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 184).label(10, 5, this.getMetaFullName());
        builder.dynamicLabel(10, 15, () -> this.isOnline ? I18n.func_135052_a((String)"gregtech.gui.me_network.online", (Object[])new Object[0]) : I18n.func_135052_a((String)"gregtech.gui.me_network.offline", (Object[])new Object[0]), 0x404040);
        builder.widget(new AEItemConfigWidget(7, 25, this.getAEItemHandler()));
        SlotWidget circuitSlot = new GhostCircuitSlotWidget(this.circuitInventory, 0, 79, 79).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.INT_CIRCUIT_OVERLAY);
        builder.widget(circuitSlot.setConsumer(w -> {
            String configString = this.circuitInventory == null || this.circuitInventory.getCircuitValue() == -1 ? new TextComponentTranslation("gregtech.gui.configurator_slot.no_value", new Object[0]).func_150254_d() : String.valueOf(this.circuitInventory.getCircuitValue());
            w.setTooltipText("gregtech.gui.configurator_slot.tooltip", configString);
        }));
        builder.widget(new SlotWidget(this.extraSlotInventory, 0, 79, 61).setBackgroundTexture(GuiTextures.SLOT).setTooltipText("gregtech.gui.me_bus.extra_slot", new Object[0]));
        builder.image(79, 43, 18, 18, GuiTextures.ARROW_DOUBLE);
        builder.bindPlayerInventory(player.field_71071_by, GuiTextures.SLOT, 7, 102);
        return builder;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.workingEnabled = workingEnabled;
        World world = this.getWorld();
        if (world != null && !world.field_72995_K) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(workingEnabled));
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.workingEnabled);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.workingEnabled = buf.readBoolean();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a(WORKING_TAG, this.workingEnabled);
        NBTTagList slots = new NBTTagList();
        for (int i = 0; i < 16; ++i) {
            ExportOnlyAEItemSlot slot = this.getAEItemHandler().getInventory()[i];
            NBTTagCompound slotTag = new NBTTagCompound();
            slotTag.func_74768_a("slot", i);
            slotTag.func_74782_a("stack", (NBTBase)slot.serializeNBT());
            slots.func_74742_a((NBTBase)slotTag);
        }
        data.func_74782_a(ITEM_BUFFER_TAG, (NBTBase)slots);
        this.circuitInventory.write(data);
        GTUtility.writeItems((IItemHandler)this.extraSlotInventory, "ExtraInventory", data);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(WORKING_TAG)) {
            this.workingEnabled = data.func_74767_n(WORKING_TAG);
        }
        if (data.func_150297_b(ITEM_BUFFER_TAG, 9)) {
            NBTTagList slots = (NBTTagList)data.func_74781_a(ITEM_BUFFER_TAG);
            for (NBTBase nbtBase : slots) {
                NBTTagCompound slotTag = (NBTTagCompound)nbtBase;
                ExportOnlyAEItemSlot slot = this.getAEItemHandler().getInventory()[slotTag.func_74762_e("slot")];
                slot.deserializeNBT(slotTag.func_74775_l("stack"));
            }
        }
        this.circuitInventory.read(data);
        GTUtility.readItems(this.extraSlotInventory, "ExtraInventory", data);
        this.importItems = this.createImportItemHandler();
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            if (this.isOnline) {
                Textures.ME_INPUT_BUS_ACTIVE.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            } else {
                Textures.ME_INPUT_BUS.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            }
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.item_bus.import.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.item_import.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me_import_item_hatch.configs.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.copy_paste.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.extra_connections.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    @Override
    public MultiblockAbility<IItemHandlerModifiable> getAbility() {
        return MultiblockAbility.IMPORT_ITEMS;
    }

    @Override
    public void registerAbilities(@NotNull AbilityInstances abilityInstances) {
        abilityInstances.add(this.actualImportItems);
    }

    @Override
    public boolean hasGhostCircuitInventory() {
        return true;
    }

    @Override
    public void setGhostCircuitConfig(int config) {
        if (this.circuitInventory.getCircuitValue() == config) {
            return;
        }
        this.circuitInventory.setCircuitValue(config);
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    @Override
    public final void onDataStickLeftClick(EntityPlayer player, ItemStack dataStick) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("MEInputBus", (NBTBase)this.writeConfigToTag());
        dataStick.func_77982_d(tag);
        dataStick.func_190924_f("gregtech.machine.me.item_import.data_stick.name");
        player.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.me.import_copy_settings", new Object[0]), true);
    }

    protected NBTTagCompound writeConfigToTag() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound configStacks = new NBTTagCompound();
        tag.func_74782_a("ConfigStacks", (NBTBase)configStacks);
        for (int i = 0; i < 16; ++i) {
            ExportOnlyAEItemSlot slot = this.aeItemHandler.getInventory()[i];
            IAEItemStack config = (IAEItemStack)slot.getConfig();
            if (config == null) continue;
            NBTTagCompound stackNbt = new NBTTagCompound();
            config.getDefinition().func_77955_b(stackNbt);
            configStacks.func_74782_a(Integer.toString(i), (NBTBase)stackNbt);
        }
        tag.func_74774_a("GhostCircuit", (byte)this.circuitInventory.getCircuitValue());
        return tag;
    }

    @Override
    public final boolean onDataStickRightClick(EntityPlayer player, ItemStack dataStick) {
        NBTTagCompound tag = dataStick.func_77978_p();
        if (tag == null || !tag.func_74764_b("MEInputBus")) {
            return false;
        }
        this.readConfigFromTag(tag.func_74775_l("MEInputBus"));
        this.syncME();
        player.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.me.import_paste_settings", new Object[0]), true);
        return true;
    }

    protected void readConfigFromTag(NBTTagCompound tag) {
        if (tag.func_74764_b("ConfigStacks")) {
            NBTTagCompound configStacks = tag.func_74775_l("ConfigStacks");
            for (int i = 0; i < 16; ++i) {
                String key = Integer.toString(i);
                if (configStacks.func_74764_b(key)) {
                    NBTTagCompound configTag = configStacks.func_74775_l(key);
                    this.aeItemHandler.getInventory()[i].setConfig(WrappedItemStack.fromNBT(configTag));
                    continue;
                }
                this.aeItemHandler.getInventory()[i].setConfig(null);
            }
        }
        if (tag.func_74764_b("GhostCircuit")) {
            this.setGhostCircuitConfig(tag.func_74771_c("GhostCircuit"));
        }
    }
}

