/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.appeng;

import appeng.api.AEApi;
import appeng.api.networking.GridFlags;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.BaseActionSource;
import appeng.me.helpers.IGridProxyable;
import appeng.me.helpers.MachineSource;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IControllable;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.common.ConfigHolder;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockNotifiablePart;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MetaTileEntityAEHostablePart<T extends IAEStack<T>>
extends MetaTileEntityMultiblockNotifiablePart
implements IControllable {
    private final Class<? extends IStorageChannel<T>> storageChannel;
    private AENetworkProxy aeProxy;
    private int meUpdateTick = 0;
    protected boolean isOnline;
    private boolean allowExtraConnections;
    protected boolean meStatusChanged = false;

    public MetaTileEntityAEHostablePart(ResourceLocation metaTileEntityId, int tier, boolean isExportHatch, Class<? extends IStorageChannel<T>> storageChannel) {
        super(metaTileEntityId, tier, isExportHatch);
        this.storageChannel = storageChannel;
        this.allowExtraConnections = false;
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            ++this.meUpdateTick;
        }
    }

    @Override
    public void clearMachineInventory(@NotNull @NotNull List<@NotNull ItemStack> itemBuffer) {
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        if (this.aeProxy != null) {
            buf.writeBoolean(true);
            NBTTagCompound proxy = new NBTTagCompound();
            this.aeProxy.writeToNBT(proxy);
            buf.func_150786_a(proxy);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(this.meUpdateTick);
        buf.writeBoolean(this.isOnline);
        buf.writeBoolean(this.allowExtraConnections);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        if (buf.readBoolean()) {
            NBTTagCompound nbtTagCompound;
            try {
                nbtTagCompound = buf.func_150793_b();
            }
            catch (IOException ignored) {
                nbtTagCompound = null;
            }
            if (this.aeProxy != null && nbtTagCompound != null) {
                this.aeProxy.readFromNBT(nbtTagCompound);
            }
        }
        this.meUpdateTick = buf.readInt();
        this.isOnline = buf.readBoolean();
        this.allowExtraConnections = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        boolean isOnline;
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_ONLINE_STATUS && this.isOnline != (isOnline = buf.readBoolean())) {
            this.isOnline = isOnline;
            this.scheduleRenderUpdate();
        }
    }

    @Override
    @NotNull
    public AECableType getCableConnectionType(@NotNull AEPartLocation part) {
        if (part.getFacing() != this.frontFacing && !this.allowExtraConnections) {
            return AECableType.NONE;
        }
        return AECableType.SMART;
    }

    @Override
    @Nullable
    public AENetworkProxy getProxy() {
        if (this.aeProxy == null) {
            this.aeProxy = this.createProxy();
            return this.aeProxy;
        }
        if (!this.aeProxy.isReady() && this.getWorld() != null) {
            this.aeProxy.onReady();
        }
        return this.aeProxy;
    }

    @Override
    public void setFrontFacing(EnumFacing frontFacing) {
        super.setFrontFacing(frontFacing);
        this.updateConnectableSides();
    }

    @Override
    public void gridChanged() {
    }

    public boolean updateMEStatus() {
        if (!this.getWorld().field_72995_K) {
            boolean isOnline;
            boolean bl = isOnline = this.aeProxy != null && this.aeProxy.isActive() && this.aeProxy.isPowered();
            if (this.isOnline != isOnline) {
                this.writeCustomData(GregtechDataCodes.UPDATE_ONLINE_STATUS, buf -> buf.writeBoolean(isOnline));
                this.isOnline = isOnline;
                this.meStatusChanged = true;
            } else {
                this.meStatusChanged = false;
            }
        }
        return this.isOnline;
    }

    protected boolean shouldSyncME() {
        return this.meUpdateTick % ConfigHolder.compat.ae2.updateIntervals == 0;
    }

    protected IActionSource getActionSource() {
        IGregTechTileEntity iGregTechTileEntity = this.getHolder();
        if (iGregTechTileEntity instanceof IActionHost) {
            IActionHost holder = (IActionHost)iGregTechTileEntity;
            return new MachineSource(holder);
        }
        return new BaseActionSource();
    }

    @Nullable
    private AENetworkProxy createProxy() {
        IGregTechTileEntity iGregTechTileEntity = this.getHolder();
        if (iGregTechTileEntity instanceof IGridProxyable) {
            IGridProxyable holder = (IGridProxyable)iGregTechTileEntity;
            AENetworkProxy proxy = new AENetworkProxy(holder, "mte_proxy", this.getStackForm(), true);
            proxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            proxy.setIdlePowerUsage(ConfigHolder.compat.ae2.meHatchEnergyUsage);
            proxy.setValidSides(this.getConnectableSides());
            return proxy;
        }
        return null;
    }

    @NotNull
    protected IStorageChannel<T> getStorageChannel() {
        return AEApi.instance().storage().getStorageChannel(this.storageChannel);
    }

    @Nullable
    protected IMEMonitor<T> getMonitor() {
        AENetworkProxy proxy = this.getProxy();
        if (proxy == null) {
            return null;
        }
        IStorageChannel<T> channel = this.getStorageChannel();
        try {
            return proxy.getStorage().getInventory(channel);
        }
        catch (GridAccessException ignored) {
            return null;
        }
    }

    public EnumSet<EnumFacing> getConnectableSides() {
        return this.allowExtraConnections ? EnumSet.allOf(EnumFacing.class) : EnumSet.of(this.getFrontFacing());
    }

    public void updateConnectableSides() {
        if (this.aeProxy != null) {
            this.aeProxy.setValidSides(this.getConnectableSides());
        }
    }

    @Override
    public boolean onWireCutterClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        this.allowExtraConnections = !this.allowExtraConnections;
        this.updateConnectableSides();
        if (!this.getWorld().field_72995_K) {
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(this.allowExtraConnections ? "gregtech.machine.me.extra_connections.enabled" : "gregtech.machine.me.extra_connections.disabled", new Object[0]), true);
        }
        return true;
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("AllowExtraConnections", this.allowExtraConnections);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.allowExtraConnections = data.func_74767_n("AllowExtraConnections");
    }
}

