/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.RichTextWidget;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import gregtech.api.capability.IGhostSlotConfigurable;
import gregtech.api.capability.impl.FilteredItemHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.GhostCircuitItemStackHandler;
import gregtech.api.capability.impl.NotifiableFluidTank;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.api.mui.sync.GTFluidSyncHandler;
import gregtech.api.mui.widget.GhostCircuitSlotWidget;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockNotifiablePart;
import gregtech.common.mui.widget.GTFluidSlot;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityReservoirHatch
extends MetaTileEntityMultiblockNotifiablePart
implements IMultiblockAbilityPart<IFluidTank>,
IGhostSlotConfigurable {
    private static final int FLUID_AMOUNT = 2000000000;
    private final InfiniteWaterTank fluidTank = new InfiniteWaterTank(this.getInventorySize(), this);
    private GhostCircuitItemStackHandler circuitInventory;

    public MetaTileEntityReservoirHatch(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, 4, false);
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityReservoirHatch(this.metaTileEntityId);
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        this.circuitInventory = new GhostCircuitItemStackHandler(this);
        this.circuitInventory.addNotifiableMetaTileEntity(this);
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            this.fillContainerFromInternalTank((IFluidHandler)this.fluidTank);
            if (this.getOffsetTimer() % 20L == 0L) {
                this.fluidTank.refillWater();
            }
        }
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            Textures.WATER_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidTank);
        }
        return super.getCapability(capability, side);
    }

    private int getInventorySize() {
        return 2000000000;
    }

    @Override
    protected FluidTankList createImportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[]{this.fluidTank});
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new FilteredItemHandler(this).setFillPredicate(FilteredItemHandler.getCapabilityFilter(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY));
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new ItemStackHandler(1);
    }

    @Override
    @NotNull
    public List<MultiblockAbility<?>> getAbilities() {
        return Arrays.asList(MultiblockAbility.IMPORT_FLUIDS, MultiblockAbility.IMPORT_ITEMS);
    }

    @Override
    public void registerAbilities(@NotNull AbilityInstances abilityInstances) {
        if (abilityInstances.isKey(MultiblockAbility.IMPORT_FLUIDS)) {
            abilityInstances.add(this.fluidTank);
        } else if (abilityInstances.isKey(MultiblockAbility.IMPORT_ITEMS)) {
            abilityInstances.add(this.circuitInventory);
        }
    }

    @Override
    public boolean usesMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(PosGuiData guiData, PanelSyncManager guiSyncManager) {
        guiSyncManager.registerSlotGroup("item_inv", 2);
        GTFluidSyncHandler tankSyncHandler = GTFluidSlot.sync((IFluidTank)this.fluidTank).showAmountOnSlot(false).accessibility(true, false);
        return (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)GTGuis.createPanel(this, 176, 166).child((IWidget)IKey.lang((String)this.getMetaFullName()).asWidget().pos(5, 5))).child((IWidget)((SlotGroupWidget)SlotGroupWidget.playerInventory().left(7)).bottom(7))).child((IWidget)((Widget)((Widget)GTGuiTextures.DISPLAY.asWidget().left(7)).top(16)).size(81, 55))).child((IWidget)((Widget)((Widget)GTGuiTextures.TANK_ICON.asWidget().left(92)).top(36)).size(14, 15))).child((IWidget)((RichTextWidget)((RichTextWidget)((RichTextWidget)((RichTextWidget)new RichTextWidget().size(75, 47)).pos(10, 20)).textColor(Color.WHITE.main)).alignment(Alignment.TopLeft)).autoUpdate(true).textBuilder(richText -> {
            richText.addLine((IDrawable)IKey.lang((String)"gregtech.gui.fluid_amount"));
            String name = tankSyncHandler.getFluidLocalizedName();
            if (name == null) {
                return;
            }
            richText.addLine((IDrawable)IKey.str((String)name));
            richText.addLine((IDrawable)IKey.str((String)tankSyncHandler.getFormattedFluidAmount()));
        }))).child((IWidget)((GTFluidSlot)new GTFluidSlot().syncHandler(tankSyncHandler).pos(69, 52)).disableBackground())).child((IWidget)((ItemSlot)new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this.importItems, (int)0).slotGroup("item_inv").filter(itemStack -> FluidUtil.getFluidHandler((ItemStack)itemStack) != null)).background(new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.IN_SLOT_OVERLAY})).pos(90, 16))).child((IWidget)((ItemSlot)new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this.exportItems, (int)0).slotGroup("item_inv").accessibility(false, true)).background(new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.OUT_SLOT_OVERLAY})).pos(90, 53))).child((IWidget)((ItemSlot)new GhostCircuitSlotWidget().slot(this.circuitInventory, 0).background(new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.INT_CIRCUIT_OVERLAY})).pos(124, 62));
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{this.getInventorySize()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    public boolean hasGhostCircuitInventory() {
        return true;
    }

    @Override
    public void setGhostCircuitConfig(int config) {
        if (this.circuitInventory.getCircuitValue() == config) {
            return;
        }
        this.circuitInventory.setCircuitValue(config);
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        this.circuitInventory.write(data);
        return super.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.circuitInventory.read(data);
        super.readFromNBT(data);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.func_150787_b(this.circuitInventory.getCircuitValue());
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.setGhostCircuitConfig(buf.func_150792_a());
    }

    @Override
    public void addToMultiBlock(MultiblockControllerBase controllerBase) {
        super.addToMultiBlock(controllerBase);
        this.circuitInventory.addNotifiableMetaTileEntity(controllerBase);
    }

    @Override
    public void removeFromMultiBlock(MultiblockControllerBase controllerBase) {
        super.removeFromMultiBlock(controllerBase);
        this.circuitInventory.removeNotifiableMetaTileEntity(controllerBase);
    }

    private static class InfiniteWaterTank
    extends NotifiableFluidTank {
        public InfiniteWaterTank(int capacity, MetaTileEntity entityToNotify) {
            super(capacity, entityToNotify, false);
            this.setFluid(new FluidStack(FluidRegistry.WATER, 2000000000));
            this.setCanFill(false);
        }

        private void refillWater() {
            int fillAmount = Math.max(0, 2000000000 - this.getFluidAmount());
            if (fillAmount > 0) {
                super.fillInternal(new FluidStack(FluidRegistry.WATER, fillAmount), true);
            }
        }

        public boolean canDrainFluidType(@Nullable FluidStack fluid) {
            return fluid != null && fluid.getFluid() == FluidRegistry.WATER;
        }

        public int fillInternal(FluidStack resource, boolean doFill) {
            return 0;
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return false;
        }

        public FluidTank readFromNBT(NBTTagCompound nbt) {
            return this;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            return nbt;
        }
    }
}

