/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.layout.Grid;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.impl.ItemHandlerProxy;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.IPassthroughHatch;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityPassthroughHatchItem
extends MetaTileEntityMultiblockPart
implements IPassthroughHatch,
IMultiblockAbilityPart<IPassthroughHatch>,
IControllable {
    private ItemStackHandler itemStackHandler;
    private IItemHandler importHandler;
    private IItemHandler exportHandler;
    private boolean workingEnabled = true;

    public MetaTileEntityPassthroughHatchItem(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityPassthroughHatchItem(this.metaTileEntityId, this.getTier());
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        this.itemStackHandler = new GTItemStackHandler((MetaTileEntity)this, this.getInventorySize());
        this.itemInventory = this.itemStackHandler;
        this.importHandler = new ItemHandlerProxy((IItemHandler)this.itemStackHandler, (IItemHandler)new GTItemStackHandler((MetaTileEntity)this, 0));
        this.exportHandler = new ItemHandlerProxy((IItemHandler)new GTItemStackHandler((MetaTileEntity)this, 0), (IItemHandler)this.itemStackHandler);
    }

    private int getInventorySize() {
        int sizeRoot = 1 + Math.min(9, this.getTier());
        return sizeRoot * sizeRoot;
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.getOffsetTimer() % 5L == 0L && this.workingEnabled) {
            this.pushItemsIntoNearbyHandlers(this.getFrontFacing().func_176734_d());
            this.pullItemsFromNearbyHandlers(this.getFrontFacing());
        }
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.workingEnabled = workingEnabled;
        World world = this.getWorld();
        if (world != null && !world.field_72995_K) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(workingEnabled));
        }
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            Textures.PIPE_IN_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            Textures.ITEM_HATCH_INPUT_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            Textures.PIPE_OUT_OVERLAY.renderSided(this.getFrontFacing().func_176734_d(), renderState, translation, pipeline);
            Textures.ITEM_HATCH_OUTPUT_OVERLAY.renderSided(this.getFrontFacing().func_176734_d(), renderState, translation, pipeline);
        }
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new NotifiableItemStackHandler(this, this.getInventorySize(), this.getController(), true);
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new NotifiableItemStackHandler(this, this.getInventorySize(), this.getController(), false);
    }

    @Override
    public boolean usesMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(PosGuiData guiData, PanelSyncManager guiSyncManager) {
        int rowSize = (int)Math.sqrt(this.getInventorySize());
        guiSyncManager.registerSlotGroup("item_inv", rowSize);
        int backgroundWidth = 176;
        int backgroundHeight = 18 + 18 * rowSize + 94;
        ArrayList widgets = new ArrayList();
        for (int i = 0; i < rowSize; ++i) {
            widgets.add(new ArrayList());
            for (int j = 0; j < rowSize; ++j) {
                ((List)widgets.get(i)).add(new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this.itemStackHandler, (int)(i * rowSize + j)).slotGroup("item_inv").accessibility(true, true)));
            }
        }
        BooleanSyncValue workingStateValue = new BooleanSyncValue(() -> this.workingEnabled, val -> {
            this.workingEnabled = val;
        });
        return (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)GTGuis.createPanel(this, backgroundWidth, backgroundHeight).child((IWidget)IKey.lang((String)this.getMetaFullName()).asWidget().pos(5, 5))).child((IWidget)((SlotGroupWidget)SlotGroupWidget.playerInventory().left(7)).bottom(7))).child((IWidget)((Grid)((Grid)((Grid)new Grid().top(18)).height(rowSize * 18)).minElementMargin(0, 0).minColWidth(18).minRowHeight(18).alignX(0.5f)).matrix(widgets))).child((IWidget)((ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().top(72)).left(151)).value((IBoolValue)workingStateValue).overlay(new IDrawable[]{GTGuiTextures.BUTTON_ITEM_OUTPUT})).tooltip(t -> t.setAutoUpdate(true))).tooltipBuilder(t -> t.addLine((IDrawable)(workingStateValue.getBoolValue() ? IKey.lang((String)"gregtech.gui.item_passthrough.enabled") : IKey.lang((String)"gregtech.gui.item_passthrough.disabled")))));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74782_a("Inventory", (NBTBase)this.itemStackHandler.serializeNBT());
        tag.func_74757_a("WorkingEnabled", this.workingEnabled);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.itemStackHandler.deserializeNBT(tag.func_74775_l("Inventory"));
        if (tag.func_74764_b("WorkingEnabled")) {
            this.workingEnabled = tag.func_74767_n("WorkingEnabled");
        }
    }

    @Override
    protected boolean shouldSerializeInventories() {
        return false;
    }

    @Override
    public void clearMachineInventory(@NotNull @NotNull List<@NotNull ItemStack> itemBuffer) {
        MetaTileEntityPassthroughHatchItem.clearInventory(itemBuffer, (IItemHandlerModifiable)this.itemStackHandler);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.item_storage_capacity", (Object[])new Object[]{this.getInventorySize()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    @Override
    public MultiblockAbility<IPassthroughHatch> getAbility() {
        return MultiblockAbility.PASSTHROUGH_HATCH;
    }

    @Override
    public void registerAbilities(@NotNull AbilityInstances abilityInstances) {
        abilityInstances.add(this);
    }

    @NotNull
    public Class<IItemHandlerModifiable> getPassthroughType() {
        return IItemHandlerModifiable.class;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == this.getFrontFacing()) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.importHandler);
            }
            if (side == this.getFrontFacing().func_176734_d()) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.exportHandler);
            }
            return null;
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.workingEnabled);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.workingEnabled = buf.readBoolean();
    }
}

