/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.layout.Grid;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.impl.FilteredFluidHandler;
import gregtech.api.capability.impl.FluidHandlerProxy;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.IPassthroughHatch;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import gregtech.common.mui.widget.GTFluidSlot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityPassthroughHatchFluid
extends MetaTileEntityMultiblockPart
implements IPassthroughHatch,
IMultiblockAbilityPart<IPassthroughHatch>,
IControllable {
    private static final int TANK_SIZE = 16000;
    private FluidTankList fluidTankList;
    private IFluidHandler importHandler;
    private IFluidHandler exportHandler;
    private boolean workingEnabled = true;

    public MetaTileEntityPassthroughHatchFluid(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityPassthroughHatchFluid(this.metaTileEntityId, this.getTier());
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        FilteredFluidHandler[] fluidHandlers = new FilteredFluidHandler[this.getTier() + 1];
        for (int i = 0; i < fluidHandlers.length; ++i) {
            fluidHandlers[i] = new FilteredFluidHandler(16000);
        }
        this.fluidTankList = new FluidTankList(false, (IFluidTank[])fluidHandlers);
        this.fluidInventory = this.fluidTankList;
        this.importHandler = new FluidHandlerProxy(this.fluidTankList, new FluidTankList(false, new IFluidTank[0]));
        this.exportHandler = new FluidHandlerProxy(new FluidTankList(false, new IFluidTank[0]), this.fluidTankList);
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.getOffsetTimer() % 5L == 0L && this.workingEnabled) {
            this.pushFluidsIntoNearbyHandlers(this.getFrontFacing().func_176734_d());
            this.pullFluidsFromNearbyHandlers(this.getFrontFacing());
        }
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.workingEnabled = workingEnabled;
        World world = this.getWorld();
        if (world != null && !world.field_72995_K) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(workingEnabled));
        }
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            Textures.PIPE_IN_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            Textures.FLUID_HATCH_INPUT_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            Textures.PIPE_OUT_OVERLAY.renderSided(this.getFrontFacing().func_176734_d(), renderState, translation, pipeline);
            Textures.FLUID_HATCH_OUTPUT_OVERLAY.renderSided(this.getFrontFacing().func_176734_d(), renderState, translation, pipeline);
        }
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new NotifiableItemStackHandler(this, 16000, this.getController(), true);
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new NotifiableItemStackHandler(this, 16000, this.getController(), false);
    }

    @Override
    public boolean usesMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(PosGuiData guiData, PanelSyncManager guiSyncManager) {
        int rowSize = (int)Math.sqrt(this.getTier() + 1);
        int backgroundWidth = 176;
        int backgroundHeight = 18 + 18 * rowSize + 94;
        ArrayList widgets = new ArrayList();
        for (int i = 0; i < rowSize; ++i) {
            widgets.add(new ArrayList());
            for (int j = 0; j < rowSize; ++j) {
                ((List)widgets.get(i)).add(new GTFluidSlot().syncHandler(this.fluidTankList.getTankAt(i * rowSize + j)).background(new IDrawable[]{GTGuiTextures.FLUID_SLOT}));
            }
        }
        BooleanSyncValue workingStateValue = new BooleanSyncValue(() -> this.workingEnabled, val -> {
            this.workingEnabled = val;
        });
        return (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)GTGuis.createPanel(this, backgroundWidth, backgroundHeight).child((IWidget)IKey.lang((String)this.getMetaFullName()).asWidget().pos(5, 5))).child((IWidget)((SlotGroupWidget)SlotGroupWidget.playerInventory().left(7)).bottom(7))).child((IWidget)((Grid)((Grid)((Grid)new Grid().top(18)).height(rowSize * 18)).minElementMargin(0, 0).minColWidth(18).minRowHeight(18).alignX(0.5f)).matrix(widgets))).child((IWidget)((ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().top(36)).left(151)).value((IBoolValue)workingStateValue).overlay(new IDrawable[]{GTGuiTextures.BUTTON_FLUID_OUTPUT})).tooltip(t -> t.setAutoUpdate(true))).tooltipBuilder(t -> t.addLine((IDrawable)(workingStateValue.getBoolValue() ? IKey.lang((String)"gregtech.gui.fluid_passthrough.enabled") : IKey.lang((String)"gregtech.gui.fluid_passthrough.disabled")))));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74782_a("FluidInventory", (NBTBase)this.fluidTankList.serializeNBT());
        tag.func_74757_a("WorkingEnabled", this.workingEnabled);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.fluidTankList.deserializeNBT(tag.func_74775_l("FluidInventory"));
        if (tag.func_74764_b("WorkingEnabled")) {
            this.workingEnabled = tag.func_74767_n("WorkingEnabled");
        }
    }

    @Override
    protected boolean shouldSerializeInventories() {
        return false;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity_mult", (Object[])new Object[]{this.getTier() + 1, 16000}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    @Override
    public MultiblockAbility<IPassthroughHatch> getAbility() {
        return MultiblockAbility.PASSTHROUGH_HATCH;
    }

    @Override
    public void registerAbilities(@NotNull AbilityInstances abilityInstances) {
        abilityInstances.add(this);
    }

    @NotNull
    public Class<IFluidHandler> getPassthroughType() {
        return IFluidHandler.class;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (side == this.getFrontFacing()) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.importHandler);
            }
            if (side == this.getFrontFacing().func_176734_d()) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.exportHandler);
            }
            return null;
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.workingEnabled);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.workingEnabled = buf.readBoolean();
    }
}

