/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.INotifiableHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class MetaTileEntityMultiblockNotifiablePart
extends MetaTileEntityMultiblockPart {
    protected final boolean isExportHatch;

    public MetaTileEntityMultiblockNotifiablePart(ResourceLocation metaTileEntityId, int tier, boolean isExportHatch) {
        super(metaTileEntityId, tier);
        this.isExportHatch = isExportHatch;
    }

    private List<INotifiableHandler> getItemHandlers() {
        INotifiableHandler notifiable;
        IItemHandlerModifiable mteHandler;
        ArrayList<INotifiableHandler> notifiables = new ArrayList<INotifiableHandler>();
        IItemHandlerModifiable iItemHandlerModifiable = mteHandler = this.isExportHatch ? this.getExportItems() : this.getImportItems();
        if (mteHandler instanceof INotifiableHandler) {
            notifiable = (INotifiableHandler)mteHandler;
            notifiables.add(notifiable);
        } else if (mteHandler instanceof ItemHandlerList) {
            ItemHandlerList list = (ItemHandlerList)mteHandler;
            for (IItemHandler handler : list.getBackingHandlers()) {
                if (!(handler instanceof INotifiableHandler)) continue;
                INotifiableHandler notifiable2 = (INotifiableHandler)handler;
                notifiables.add(notifiable2);
            }
        }
        IItemHandler iItemHandler = this.getItemInventory();
        if (iItemHandler instanceof INotifiableHandler) {
            notifiable = (INotifiableHandler)iItemHandler;
            notifiables.add(notifiable);
        }
        return notifiables;
    }

    private FluidTankList getFluidHandlers() {
        FluidTankList handler = null;
        if (this.isExportHatch && this.getExportFluids().getFluidTanks().size() > 0) {
            handler = this.getExportFluids();
        } else if (!this.isExportHatch && this.getImportFluids().getFluidTanks().size() > 0) {
            handler = this.getImportFluids();
        }
        return handler;
    }

    private List<INotifiableHandler> getPartHandlers() {
        FluidTankList fluidTankList;
        ArrayList<INotifiableHandler> handlerList = new ArrayList<INotifiableHandler>();
        for (INotifiableHandler notif : this.getItemHandlers()) {
            if (notif.size() <= 0) continue;
            handlerList.add(notif);
        }
        if (this.fluidInventory.getTankProperties().length > 0 && (fluidTankList = this.getFluidHandlers()) != null) {
            for (IFluidTank fluidTank : fluidTankList) {
                if (fluidTank instanceof IMultipleTankHandler.ITankEntry) {
                    IMultipleTankHandler.ITankEntry entry = (IMultipleTankHandler.ITankEntry)fluidTank;
                    fluidTank = entry.getDelegate();
                }
                if (!(fluidTank instanceof INotifiableHandler)) continue;
                handlerList.add((INotifiableHandler)fluidTank);
            }
        }
        return handlerList;
    }

    @Override
    public void addToMultiBlock(MultiblockControllerBase controllerBase) {
        super.addToMultiBlock(controllerBase);
        List<INotifiableHandler> handlerList = this.getPartHandlers();
        for (INotifiableHandler handler : handlerList) {
            handler.addNotifiableMetaTileEntity(controllerBase);
            handler.addToNotifiedList(this, handler, this.isExportHatch);
        }
    }

    @Override
    public void removeFromMultiBlock(MultiblockControllerBase controllerBase) {
        super.removeFromMultiBlock(controllerBase);
        List<INotifiableHandler> handlerList = this.getPartHandlers();
        for (INotifiableHandler handler : handlerList) {
            handler.removeNotifiableMetaTileEntity(controllerBase);
        }
    }
}

