/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IMufflerHatch;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.util.GTUtility;
import gregtech.client.particle.VanillaParticleEffects;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityMufflerHatch
extends MetaTileEntityMultiblockPart
implements IMultiblockAbilityPart<IMufflerHatch>,
ITieredMetaTileEntity,
IMufflerHatch {
    private boolean frontFaceFree;

    public MetaTileEntityMufflerHatch(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityMufflerHatch(this.metaTileEntityId, this.getTier());
    }

    @Override
    public void update() {
        boolean frontFaceFree;
        super.update();
        if (this.getWorld().field_72995_K) {
            MultiblockWithDisplayBase controller;
            MultiblockControllerBase multiblockControllerBase = this.getController();
            if (multiblockControllerBase instanceof MultiblockWithDisplayBase && (controller = (MultiblockWithDisplayBase)multiblockControllerBase).isActive()) {
                VanillaParticleEffects.mufflerEffect(this, controller.getMufflerParticle());
            }
        } else if (this.getOffsetTimer() % 10L == 0L && (frontFaceFree = this.checkFrontFaceFree()) != this.frontFaceFree) {
            this.frontFaceFree = frontFaceFree;
            this.writeCustomData(GregtechDataCodes.MUFFLER_OBSTRUCTED, buffer -> buffer.writeBoolean(this.frontFaceFree));
        }
    }

    @Override
    public boolean isFrontFaceFree() {
        return this.frontFaceFree;
    }

    private boolean checkFrontFaceFree() {
        MultiblockWithDisplayBase controller;
        BlockPos frontPos = this.getPos().func_177972_a(this.getFrontFacing());
        IBlockState blockState = this.getWorld().func_180495_p(frontPos);
        MultiblockControllerBase multiblockControllerBase = this.getController();
        if (multiblockControllerBase instanceof MultiblockWithDisplayBase && (controller = (MultiblockWithDisplayBase)multiblockControllerBase).isActive()) {
            if (GTUtility.tryBreakSnow(this.getWorld(), frontPos, blockState, true)) {
                return true;
            }
            return blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.getWorld(), frontPos);
        }
        return blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.getWorld(), frontPos) || GTUtility.isBlockSnow(blockState);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.frontFaceFree);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.frontFaceFree = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.MUFFLER_OBSTRUCTED) {
            this.frontFaceFree = buf.readBoolean();
        }
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            Textures.MUFFLER_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.muffler_hatch.tooltip1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
        tooltip.add(TooltipHelper.BLINKING_RED + I18n.func_135052_a((String)"gregtech.machine.muffler_hatch.tooltip2", (Object[])new Object[0]));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    public MultiblockAbility<IMufflerHatch> getAbility() {
        return MultiblockAbility.MUFFLER_HATCH;
    }

    @Override
    public void registerAbilities(@NotNull AbilityInstances abilityInstances) {
        abilityInstances.add(this);
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }
}

