/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IMaintenanceHatch;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.AdvancedTextWidget;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.items.toolitem.ItemGTToolbelt;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMaintenance;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.ConfigHolder;
import gregtech.common.gui.widget.among_us.FixWiringTaskWidget;
import gregtech.common.inventory.handlers.TapeItemStackHandler;
import gregtech.common.items.MetaItems;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityMaintenanceHatch
extends MetaTileEntityMultiblockPart
implements IMultiblockAbilityPart<IMaintenanceHatch>,
IMaintenanceHatch {
    private final boolean isConfigurable;
    private GTItemStackHandler itemStackHandler;
    private boolean isTaped;
    private byte maintenanceProblems = (byte)-1;
    private int timeActive = -1;
    private BigDecimal durationMultiplier = BigDecimal.ONE;
    private static final BigDecimal MAX_DURATION_MULTIPLIER = BigDecimal.valueOf(1.1);
    private static final BigDecimal MIN_DURATION_MULTIPLIER = BigDecimal.valueOf(0.9);
    private static final BigDecimal DURATION_ACTION_AMOUNT = BigDecimal.valueOf(0.01);
    private static final Function<Double, Double> TIME_ACTION = d -> {
        if (d < 1.0) {
            return -20.0 * d + 21.0;
        }
        return -8.0 * d + 9.0;
    };

    public MetaTileEntityMaintenanceHatch(ResourceLocation metaTileEntityId, boolean isConfigurable) {
        super(metaTileEntityId, isConfigurable ? 3 : 1);
        this.isConfigurable = isConfigurable;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity metaTileEntityHolder) {
        return new MetaTileEntityMaintenanceHatch(this.metaTileEntityId, this.isConfigurable);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            (this.isConfigurable ? Textures.MAINTENANCE_OVERLAY_CONFIGURABLE : (this.isTaped ? Textures.MAINTENANCE_OVERLAY_TAPED : Textures.MAINTENANCE_OVERLAY)).renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        }
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        this.itemStackHandler = new TapeItemStackHandler((MetaTileEntity)this, 1);
        this.itemInventory = this.itemStackHandler;
    }

    @Override
    public void clearMachineInventory(@NotNull @NotNull List<@NotNull ItemStack> itemBuffer) {
        super.clearMachineInventory(itemBuffer);
        MetaTileEntityMaintenanceHatch.clearInventory(itemBuffer, (IItemHandlerModifiable)this.itemStackHandler);
    }

    @Override
    public void setTaped(boolean isTaped) {
        this.isTaped = isTaped;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.IS_TAPED, buf -> buf.writeBoolean(isTaped));
            this.markDirty();
        }
    }

    @Override
    public void storeMaintenanceData(byte maintenanceProblems, int timeActive) {
        this.maintenanceProblems = maintenanceProblems;
        this.timeActive = timeActive;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.STORE_MAINTENANCE, buf -> {
                buf.writeByte((int)maintenanceProblems);
                buf.writeInt(timeActive);
            });
        }
    }

    @Override
    public boolean hasMaintenanceData() {
        return this.maintenanceProblems != -1;
    }

    @Override
    public Tuple<Byte, Integer> readMaintenanceData() {
        Tuple data = new Tuple((Object)this.maintenanceProblems, (Object)this.timeActive);
        this.storeMaintenanceData((byte)-1, -1);
        return data;
    }

    @Override
    public boolean startWithoutProblems() {
        return this.isConfigurable;
    }

    @Override
    public void update() {
        MultiblockControllerBase controller;
        super.update();
        if (!this.getWorld().field_72995_K && this.getOffsetTimer() % 20L == 0L && (controller = this.getController()) instanceof IMaintenance && ((IMaintenance)((Object)controller)).hasMaintenanceProblems() && this.consumeDuctTape(this.itemInventory, 0)) {
            this.fixAllMaintenanceProblems();
            this.setTaped(true);
        }
    }

    private void fixMaintenanceProblems(@Nullable EntityPlayer entityPlayer) {
        if (!(this.getController() instanceof IMaintenance)) {
            return;
        }
        if (!((IMaintenance)((Object)this.getController())).hasMaintenanceProblems()) {
            return;
        }
        if (entityPlayer != null) {
            if (entityPlayer.field_71075_bZ.field_75098_d) {
                this.fixAllMaintenanceProblems();
                return;
            }
            for (int i = 0; i < entityPlayer.field_71071_by.field_70462_a.size(); ++i) {
                if (!this.consumeDuctTape((IItemHandler)new ItemStackHandler(entityPlayer.field_71071_by.field_70462_a), i)) continue;
                this.fixAllMaintenanceProblems();
                this.setTaped(true);
                return;
            }
            this.fixProblemsWithTools(((IMaintenance)((Object)this.getController())).getMaintenanceProblems(), entityPlayer);
        }
    }

    private boolean consumeDuctTape(@Nullable IItemHandler handler, int slot) {
        if (handler == null) {
            return false;
        }
        return this.consumeDuctTape(null, handler.getStackInSlot(slot));
    }

    private boolean consumeDuctTape(@Nullable EntityPlayer player, ItemStack itemStack) {
        if (!itemStack.func_190926_b() && itemStack.func_77969_a(MetaItems.DUCT_TAPE.getStackForm())) {
            if (player == null || !player.field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    private void fixProblemsWithTools(byte problems, EntityPlayer entityPlayer) {
        List<String> toolsToMatch = Arrays.asList(new String[6]);
        boolean proceed = false;
        block8: for (int index = 0; index < 6; index = (int)((byte)(index + 1))) {
            if ((problems >> index & 1) != 0) continue;
            proceed = true;
            switch (index) {
                case 0: {
                    toolsToMatch.set(0, "wrench");
                    continue block8;
                }
                case 1: {
                    toolsToMatch.set(1, "screwdriver");
                    continue block8;
                }
                case 2: {
                    toolsToMatch.set(2, "mallet");
                    continue block8;
                }
                case 3: {
                    toolsToMatch.set(3, "hammer");
                    continue block8;
                }
                case 4: {
                    toolsToMatch.set(4, "wirecutter");
                    continue block8;
                }
                case 5: {
                    toolsToMatch.set(5, "crowbar");
                }
            }
        }
        if (!proceed) {
            return;
        }
        block9: for (int i = 0; i < toolsToMatch.size(); ++i) {
            String toolToMatch = toolsToMatch.get(i);
            if (toolToMatch == null) continue;
            ItemStack heldItem = entityPlayer.field_71071_by.func_70445_o();
            Item item = heldItem.func_77973_b();
            if (item instanceof ItemGTToolbelt) {
                ItemGTToolbelt toolbelt = (ItemGTToolbelt)item;
                if (toolbelt.damageAgainstMaintenanceProblem(heldItem, toolToMatch, entityPlayer)) {
                    ((IMaintenance)((Object)this.getController())).setMaintenanceFixed(i);
                    this.setTaped(false);
                    continue;
                }
            } else if (ToolHelper.isTool(heldItem, toolToMatch)) {
                this.fixProblemWithTool(i, heldItem, entityPlayer);
                if (!toolsToMatch.stream().allMatch(Objects::isNull)) continue;
                return;
            }
            for (ItemStack itemStack : entityPlayer.field_71071_by.field_70462_a) {
                Item item2 = itemStack.func_77973_b();
                if (item2 instanceof ItemGTToolbelt) {
                    ItemGTToolbelt toolbelt = (ItemGTToolbelt)item2;
                    if (!toolbelt.damageAgainstMaintenanceProblem(itemStack, toolToMatch, entityPlayer)) continue;
                    ((IMaintenance)((Object)this.getController())).setMaintenanceFixed(i);
                    this.setTaped(false);
                    continue block9;
                }
                if (!ToolHelper.isTool(itemStack, toolToMatch)) continue;
                this.fixProblemWithTool(i, itemStack, entityPlayer);
                if (!toolsToMatch.stream().allMatch(Objects::isNull)) continue block9;
                return;
            }
        }
    }

    @ApiStatus.Internal
    public void fixMaintenanceProblemsWithToolbelt(@NotNull EntityPlayer entityPlayer, ItemGTToolbelt toolbelt, ItemStack toolbeltStack) {
        byte problems = ((IMaintenance)((Object)this.getController())).getMaintenanceProblems();
        for (int index = 0; index < 6; index = (int)((byte)(index + 1))) {
            String toolToMatch;
            if ((problems >> index & 1) != 0) continue;
            switch (index) {
                case 0: {
                    String string = "wrench";
                    break;
                }
                case 1: {
                    String string = "screwdriver";
                    break;
                }
                case 2: {
                    String string = "mallet";
                    break;
                }
                case 3: {
                    String string = "hammer";
                    break;
                }
                case 4: {
                    String string = "wirecutter";
                    break;
                }
                case 5: {
                    String string = "crowbar";
                    break;
                }
                default: {
                    String string = toolToMatch = null;
                }
            }
            if (!toolbelt.damageAgainstMaintenanceProblem(toolbeltStack, toolToMatch, entityPlayer)) continue;
            ((IMaintenance)((Object)this.getController())).setMaintenanceFixed(index);
            this.setTaped(false);
        }
    }

    private void fixProblemWithTool(int problemIndex, ItemStack stack, EntityPlayer player) {
        ((IMaintenance)((Object)this.getController())).setMaintenanceFixed(problemIndex);
        ToolHelper.damageItemWhenCrafting(stack, (EntityLivingBase)player);
        this.setTaped(false);
    }

    public void fixAllMaintenanceProblems() {
        if (this.getController() instanceof IMaintenance) {
            for (int i = 0; i < 6; ++i) {
                ((IMaintenance)((Object)this.getController())).setMaintenanceFixed(i);
            }
        }
    }

    @Override
    public boolean isFullAuto() {
        return false;
    }

    @Override
    public double getDurationMultiplier() {
        return this.durationMultiplier.doubleValue();
    }

    @Override
    public double getTimeMultiplier() {
        return BigDecimal.valueOf(TIME_ACTION.apply(this.durationMultiplier.doubleValue())).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    private void incInternalMultiplier(Widget.ClickData data) {
        if (this.durationMultiplier.compareTo(MAX_DURATION_MULTIPLIER) == 0) {
            return;
        }
        this.durationMultiplier = this.durationMultiplier.add(DURATION_ACTION_AMOUNT);
        this.writeCustomData(GregtechDataCodes.MAINTENANCE_MULTIPLIER, b -> b.writeDouble(this.durationMultiplier.doubleValue()));
    }

    private void decInternalMultiplier(Widget.ClickData data) {
        if (this.durationMultiplier.compareTo(MIN_DURATION_MULTIPLIER) == 0) {
            return;
        }
        this.durationMultiplier = this.durationMultiplier.subtract(DURATION_ACTION_AMOUNT);
        this.writeCustomData(GregtechDataCodes.MAINTENANCE_MULTIPLIER, b -> b.writeDouble(this.durationMultiplier.doubleValue()));
    }

    @Override
    public void onRemoval() {
        if (this.getController() instanceof IMaintenance) {
            IMaintenance controller = (IMaintenance)((Object)this.getController());
            if (!this.getWorld().field_72995_K && controller != null) {
                controller.storeTaped(this.isTaped);
            }
        }
        super.onRemoval();
    }

    @Override
    public boolean onRightClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (this.getController() instanceof IMaintenance && ((IMaintenance)((Object)this.getController())).hasMaintenanceProblems() && this.consumeDuctTape(playerIn, playerIn.func_184586_b(hand))) {
            this.fixAllMaintenanceProblems();
            this.setTaped(true);
            return true;
        }
        return super.onRightClick(playerIn, hand, facing, hitResult);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 152).label(5, 5, this.getMetaFullName()).bindPlayerInventory(entityPlayer.field_71071_by, GuiTextures.SLOT, 7, 70);
        if (!this.isConfigurable && GTValues.FOOLS.get().booleanValue()) {
            builder.widget(new FixWiringTaskWidget(48, 15, 80, 50).setOnFinished(this::fixAllMaintenanceProblems).setCanInteractPredicate(this::isAttachedToMultiBlock));
        } else {
            builder.widget(new SlotWidget((IItemHandlerModifiable)this.itemStackHandler, 0, 79, 17).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.DUCT_TAPE_OVERLAY).setTooltipText("gregtech.machine.maintenance_hatch_tape_slot.tooltip", new Object[0])).widget(new ClickButtonWidget(78, 39, 20, 20, "", data -> this.fixMaintenanceProblems(entityPlayer)).setButtonTexture(GuiTextures.MAINTENANCE_ICON).setTooltipText("gregtech.machine.maintenance_hatch_tool_slot.tooltip", new Object[0]));
        }
        if (this.isConfigurable) {
            builder.widget(new AdvancedTextWidget(5, 25, MetaTileEntityMaintenanceHatch.getTextWidgetText("duration", this::getDurationMultiplier), 0x404040)).widget(new AdvancedTextWidget(5, 39, MetaTileEntityMaintenanceHatch.getTextWidgetText("time", this::getTimeMultiplier), 0x404040)).widget(new ClickButtonWidget(9, 52, 12, 12, "-", this::decInternalMultiplier)).widget(new ClickButtonWidget(45, 52, 12, 12, "+", this::incInternalMultiplier));
        }
        return builder.build(this.getHolder(), entityPlayer);
    }

    private static Consumer<List<ITextComponent>> getTextWidgetText(String type, Supplier<Double> multiplier) {
        return list -> {
            TextComponentTranslation tooltip = (Double)multiplier.get() == 1.0 ? new TextComponentTranslation("gregtech.maintenance.configurable_" + type + ".unchanged_description", new Object[0]) : new TextComponentTranslation("gregtech.maintenance.configurable_" + type + ".changed_description", new Object[]{multiplier.get()});
            list.add(new TextComponentTranslation("gregtech.maintenance.configurable_" + type, new Object[]{multiplier.get()}).func_150255_a(new Style().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)tooltip))));
        };
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("IsTaped", this.isTaped);
        data.func_74782_a("tapeInventory", (NBTBase)this.itemStackHandler.serializeNBT());
        if (this.isConfigurable) {
            data.func_74780_a("DurationMultiplier", this.durationMultiplier.doubleValue());
        }
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isTaped = data.func_74767_n("IsTaped");
        if (data.func_150297_b("tapeInventory", 10)) {
            this.itemStackHandler.deserializeNBT(data.func_74775_l("tapeInventory"));
        }
        if (this.isConfigurable) {
            this.durationMultiplier = BigDecimal.valueOf(data.func_74769_h("DurationMultiplier"));
        }
        if (data.func_150297_b("ImportInventory", 10)) {
            GTUtility.readItems((IItemHandlerModifiable)this.itemStackHandler, "ImportInventory", data);
            data.func_82580_o("ImportInventory");
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isTaped);
        if (this.isConfigurable) {
            buf.writeDouble(this.durationMultiplier.doubleValue());
        }
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isTaped = buf.readBoolean();
        if (this.isConfigurable) {
            this.durationMultiplier = BigDecimal.valueOf(buf.readDouble());
        }
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.STORE_MAINTENANCE) {
            this.maintenanceProblems = buf.readByte();
            this.timeActive = buf.readInt();
            this.markDirty();
        } else if (dataId == GregtechDataCodes.IS_TAPED) {
            this.isTaped = buf.readBoolean();
            this.scheduleRenderUpdate();
            this.markDirty();
        } else if (dataId == GregtechDataCodes.MAINTENANCE_MULTIPLIER) {
            this.durationMultiplier = BigDecimal.valueOf(buf.readDouble());
            this.markDirty();
        }
    }

    @Override
    public MultiblockAbility<IMaintenanceHatch> getAbility() {
        return MultiblockAbility.MAINTENANCE_HATCH;
    }

    @Override
    public void registerAbilities(@NotNull AbilityInstances abilityInstances) {
        abilityInstances.add(this);
    }

    @Override
    public boolean canPartShare() {
        return false;
    }

    @Override
    public void getSubItems(CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
        if (ConfigHolder.machines.enableMaintenance) {
            super.getSubItems(creativeTab, subItems);
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, world, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.disabled", (Object[])new Object[0]));
        if (this.isConfigurable) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.maintenance.configurable.tooltip_basic", (Object[])new Object[0]));
            if (!TooltipHelper.isShiftDown()) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.maintenance.configurable.tooltip_more_info", (Object[])new Object[0]));
            } else {
                tooltip.add(I18n.func_135052_a((String)"gregtech.maintenance.configurable.tooltip_pss_header", (Object[])new Object[0]));
                tooltip.add(I18n.func_135052_a((String)"gregtech.maintenance.configurable.tooltip_pss_info", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.tape", (Object[])new Object[0]));
    }
}

