/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.metatileentity.IMachineHatchMultiblock;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.mui.GTGuis;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockNotifiablePart;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityMachineHatch
extends MetaTileEntityMultiblockNotifiablePart
implements IMultiblockAbilityPart<IItemHandlerModifiable> {
    private final IItemHandlerModifiable machineHandler = new LimitedImportHandler(this);

    public MetaTileEntityMachineHatch(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier, false);
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityMachineHatch(this.metaTileEntityId, this.getTier());
    }

    @Override
    public MultiblockAbility<IItemHandlerModifiable> getAbility() {
        return MultiblockAbility.MACHINE_HATCH;
    }

    @Override
    public void registerAbilities(@NotNull AbilityInstances abilityInstances) {
        abilityInstances.add(this.machineHandler);
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return this.machineHandler;
    }

    @Override
    public boolean usesMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(PosGuiData guiData, PanelSyncManager guiSyncManager) {
        guiSyncManager.registerSlotGroup("item_inv", 1);
        return (ModularPanel)((ModularPanel)((ModularPanel)GTGuis.createPanel(this, 176, 130).child((IWidget)IKey.lang((String)this.getMetaFullName()).asWidget().pos(5, 5))).child((IWidget)((SlotGroupWidget)SlotGroupWidget.playerInventory().left(7)).bottom(7))).child((IWidget)((ItemSlot)((ItemSlot)((ItemSlot)((ItemSlot)new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this.machineHandler, (int)0).slotGroup("item_inv")).tooltip(t -> t.setAutoUpdate(false))).onUpdateListener(itemSlot -> {
            RichTooltip tooltip = itemSlot.tooltip();
            tooltip.buildTooltip();
            if (this.isSlotBlocked()) {
                tooltip.clearText();
            }
        })).overlay(new IDrawable[]{(context, x, y, width, height, widgetTheme) -> {
            if (this.isSlotBlocked()) {
                GuiDraw.drawRect((float)x, (float)y, (float)width, (float)height, (int)-2143272896);
            }
        }})).left(79)).top(18));
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        Textures.PIPE_IN_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
    }

    @Override
    public boolean canPartShare() {
        return false;
    }

    private int getMachineLimit() {
        if (this.getController() instanceof IMachineHatchMultiblock) {
            return ((IMachineHatchMultiblock)((Object)this.getController())).getMachineLimit();
        }
        return 64;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.machine_hatch.processing_array", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.disabled", (Object[])new Object[0]));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    private boolean isSlotBlocked() {
        MultiblockControllerBase multiblockControllerBase = this.getController();
        if (multiblockControllerBase instanceof RecipeMapMultiblockController) {
            RecipeMapMultiblockController controller = (RecipeMapMultiblockController)multiblockControllerBase;
            return controller.isActive();
        }
        return false;
    }

    private class LimitedImportHandler
    extends NotifiableItemStackHandler {
        public LimitedImportHandler(MetaTileEntity metaTileEntity) {
            super(metaTileEntity, 1, null, false);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            int slotLimit;
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (!ItemStackHashStrategy.comparingAllButCount().equals(stack, this.getStackInSlot(slot)) && !this.getStackInSlot(slot).func_190926_b()) {
                return stack;
            }
            int amountInSlot = this.getStackInSlot(slot).func_190916_E();
            if (amountInSlot >= (slotLimit = this.getSlotLimit(slot))) {
                return stack;
            }
            int spaceAvailable = slotLimit - amountInSlot;
            int amountToInsert = Math.min(spaceAvailable, stack.func_190916_E());
            int remainderAmount = stack.func_190916_E() - amountToInsert;
            ItemStack remainder = ItemStack.field_190927_a;
            if (remainderAmount > 0) {
                remainder = stack.func_77946_l();
                remainder.func_190920_e(remainderAmount);
            }
            if (!simulate) {
                ItemStack temp = stack.func_77946_l();
                temp.func_190920_e(amountInSlot + amountToInsert);
                this.setStackInSlot(slot, temp);
            }
            return remainder;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            boolean slotMatches = this.getStackInSlot(slot).func_190926_b() || ItemStackHashStrategy.comparingAllButCount().equals(this.getStackInSlot(slot), stack);
            MultiblockControllerBase controller = MetaTileEntityMachineHatch.this.getController();
            if (controller instanceof IMachineHatchMultiblock) {
                return slotMatches && GTUtility.isMachineValidForMachineHatch(stack, ((IMachineHatchMultiblock)((Object)controller)).getBlacklist());
            }
            return slotMatches;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (MetaTileEntityMachineHatch.this.isSlotBlocked()) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }

        @Override
        public <T> void addToNotifiedList(MetaTileEntity metaTileEntity, T handler, boolean isExport) {
            if (metaTileEntity instanceof IMachineHatchMultiblock && metaTileEntity.isValid()) {
                ((IMachineHatchMultiblock)((Object)metaTileEntity)).notifyMachineChanged();
            }
        }

        public int getSlotLimit(int slot) {
            return MetaTileEntityMachineHatch.this.getMachineLimit();
        }
    }
}

