/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.layout.Grid;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IGhostSlotConfigurable;
import gregtech.api.capability.INotifiableHandler;
import gregtech.api.capability.impl.GhostCircuitItemStackHandler;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.api.mui.widget.GhostCircuitSlotWidget;
import gregtech.api.util.GTHashMaps;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockNotifiablePart;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityItemBus
extends MetaTileEntityMultiblockNotifiablePart
implements IMultiblockAbilityPart<IItemHandlerModifiable>,
IControllable,
IGhostSlotConfigurable {
    @Nullable
    protected GhostCircuitItemStackHandler circuitInventory;
    private IItemHandlerModifiable actualImportItems;
    private boolean workingEnabled = true;
    private boolean autoCollapse;

    public MetaTileEntityItemBus(ResourceLocation metaTileEntityId, int tier, boolean isExportHatch) {
        super(metaTileEntityId, tier, isExportHatch);
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityItemBus(this.metaTileEntityId, this.getTier(), this.isExportHatch);
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        if (this.hasGhostCircuitInventory()) {
            this.circuitInventory = new GhostCircuitItemStackHandler(this);
            this.circuitInventory.addNotifiableMetaTileEntity(this);
            this.actualImportItems = new ItemHandlerList(Arrays.asList(super.getImportItems(), this.circuitInventory));
        } else {
            this.actualImportItems = null;
        }
    }

    @Override
    public IItemHandlerModifiable getImportItems() {
        return this.actualImportItems == null ? super.getImportItems() : this.actualImportItems;
    }

    @Override
    public void addToMultiBlock(MultiblockControllerBase controllerBase) {
        super.addToMultiBlock(controllerBase);
        if (this.hasGhostCircuitInventory() && this.actualImportItems instanceof ItemHandlerList) {
            for (IItemHandler handler : ((ItemHandlerList)this.actualImportItems).getBackingHandlers()) {
                if (!(handler instanceof INotifiableHandler)) continue;
                INotifiableHandler notifiable = (INotifiableHandler)handler;
                notifiable.addNotifiableMetaTileEntity(controllerBase);
                notifiable.addToNotifiedList(this, handler, this.isExportHatch);
            }
        }
    }

    @Override
    public void removeFromMultiBlock(MultiblockControllerBase controllerBase) {
        super.removeFromMultiBlock(controllerBase);
        if (this.hasGhostCircuitInventory() && this.actualImportItems instanceof ItemHandlerList) {
            for (IItemHandler handler : ((ItemHandlerList)this.actualImportItems).getBackingHandlers()) {
                if (!(handler instanceof INotifiableHandler)) continue;
                INotifiableHandler notifiable = (INotifiableHandler)handler;
                notifiable.removeNotifiableMetaTileEntity(controllerBase);
            }
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.getOffsetTimer() % 5L == 0L) {
            if (this.workingEnabled) {
                if (this.isExportHatch) {
                    this.pushItemsIntoNearbyHandlers(this.getFrontFacing());
                } else {
                    this.pullItemsFromNearbyHandlers(this.getFrontFacing());
                }
            }
            if (this.isAutoCollapse()) {
                IItemHandlerModifiable inventory;
                IItemHandlerModifiable iItemHandlerModifiable = inventory = this.isExportHatch ? this.getExportItems() : super.getImportItems();
                if (!this.isAttachedToMultiBlock() || (this.isExportHatch ? this.getNotifiedItemOutputList().contains(inventory) : this.getNotifiedItemInputList().contains(inventory))) {
                    MetaTileEntityItemBus.collapseInventorySlotContents(inventory);
                }
            }
        }
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.workingEnabled = workingEnabled;
        World world = this.getWorld();
        if (world != null && !world.field_72995_K) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(workingEnabled));
        }
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            SimpleOverlayRenderer renderer = this.isExportHatch ? Textures.PIPE_OUT_OVERLAY : Textures.PIPE_IN_OVERLAY;
            renderer.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            SimpleOverlayRenderer overlay = this.isExportHatch ? Textures.ITEM_HATCH_OUTPUT_OVERLAY : Textures.ITEM_HATCH_INPUT_OVERLAY;
            overlay.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        }
    }

    private int getInventorySize() {
        int sizeRoot = 1 + Math.min(9, this.getTier());
        return sizeRoot * sizeRoot;
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return this.isExportHatch ? new NotifiableItemStackHandler(this, this.getInventorySize(), this.getController(), true) : new GTItemStackHandler((MetaTileEntity)this, 0);
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return this.isExportHatch ? new GTItemStackHandler((MetaTileEntity)this, 0) : new NotifiableItemStackHandler(this, this.getInventorySize(), this.getController(), false);
    }

    @Override
    public MultiblockAbility<IItemHandlerModifiable> getAbility() {
        return this.isExportHatch ? MultiblockAbility.EXPORT_ITEMS : MultiblockAbility.IMPORT_ITEMS;
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.workingEnabled);
        buf.writeBoolean(this.autoCollapse);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.workingEnabled = buf.readBoolean();
        this.autoCollapse = buf.readBoolean();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("workingEnabled", this.workingEnabled);
        data.func_74757_a("autoCollapse", this.autoCollapse);
        if (this.circuitInventory != null && !this.isExportHatch) {
            this.circuitInventory.write(data);
        }
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("workingEnabled")) {
            this.workingEnabled = data.func_74767_n("workingEnabled");
        }
        if (data.func_74764_b("autoCollapse")) {
            this.autoCollapse = data.func_74767_n("autoCollapse");
        }
        if (this.circuitInventory != null && !this.isExportHatch) {
            this.circuitInventory.read(data);
        }
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.TOGGLE_COLLAPSE_ITEMS) {
            this.autoCollapse = buf.readBoolean();
        } else if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.workingEnabled = buf.readBoolean();
        }
    }

    @Override
    public void registerAbilities(@NotNull AbilityInstances abilityInstances) {
        if (this.hasGhostCircuitInventory() && this.actualImportItems != null) {
            abilityInstances.add(this.isExportHatch ? this.exportItems : this.actualImportItems);
        } else {
            abilityInstances.add(this.isExportHatch ? this.exportItems : this.importItems);
        }
    }

    @Override
    public boolean usesMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(PosGuiData guiData, PanelSyncManager panelSyncManager) {
        int rowSize = (int)Math.sqrt(this.getInventorySize());
        panelSyncManager.registerSlotGroup("item_inv", rowSize);
        int backgroundWidth = Math.max(199, rowSize * 18 + 14);
        int backgroundHeight = 18 + 18 * rowSize + 94;
        BooleanSyncValue workingStateValue = new BooleanSyncValue(() -> this.workingEnabled, val -> {
            this.workingEnabled = val;
        });
        BooleanSyncValue collapseStateValue = new BooleanSyncValue(() -> this.autoCollapse, val -> {
            this.autoCollapse = val;
        });
        IItemHandlerModifiable handler = this.isExportHatch ? this.exportItems : this.importItems;
        boolean hasGhostCircuit = this.hasGhostCircuitInventory() && this.circuitInventory != null;
        return (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)GTGuis.createPanel(this, backgroundWidth, backgroundHeight).child((IWidget)IKey.lang((String)this.getMetaFullName()).asWidget().pos(5, 5))).child((IWidget)((SlotGroupWidget)SlotGroupWidget.playerInventory().left(7)).bottom(7))).child((IWidget)((Grid)((Grid)((Grid)new Grid().top(18)).height(rowSize * 18)).minElementMargin(0, 0).minColWidth(18).minRowHeight(18).alignX(0.5f)).mapTo(rowSize, rowSize * rowSize, index -> new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)handler, (int)index).slotGroup("item_inv").changeListener((newItem, onlyAmountChanged, client, init) -> {
            if (onlyAmountChanged && handler instanceof GTItemStackHandler) {
                GTItemStackHandler gtHandler = (GTItemStackHandler)handler;
                gtHandler.onContentsChanged(index);
            }
        }).accessibility(!this.isExportHatch, true))))).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.column().pos(backgroundWidth - 7 - 18, backgroundHeight - 72 - 7 - 5)).width(18)).height(77)).child((IWidget)((Widget)GTGuiTextures.getLogo(this.getUITheme()).asWidget().size(17)).top(59))).child((IWidget)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().top(36)).value((IBoolValue)workingStateValue).overlay(new IDrawable[]{GTGuiTextures.BUTTON_ITEM_OUTPUT})).tooltipAutoUpdate(true)).tooltipBuilder(t -> t.addLine((IDrawable)(this.isExportHatch ? (workingStateValue.getBoolValue() ? IKey.lang((String)"gregtech.gui.item_auto_output.tooltip.enabled") : IKey.lang((String)"gregtech.gui.item_auto_output.tooltip.disabled")) : (workingStateValue.getBoolValue() ? IKey.lang((String)"gregtech.gui.item_auto_input.tooltip.enabled") : IKey.lang((String)"gregtech.gui.item_auto_input.tooltip.disabled"))))))).child((IWidget)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().top(18)).value((IBoolValue)collapseStateValue).overlay(new IDrawable[]{GTGuiTextures.BUTTON_AUTO_COLLAPSE})).tooltipAutoUpdate(true)).tooltipBuilder(t -> t.addLine((IDrawable)(collapseStateValue.getBoolValue() ? IKey.lang((String)"gregtech.gui.item_auto_collapse.tooltip.enabled") : IKey.lang((String)"gregtech.gui.item_auto_collapse.tooltip.disabled")))))).childIf(hasGhostCircuit, (IWidget)new GhostCircuitSlotWidget().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this.circuitInventory, (int)0)).background(new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.INT_CIRCUIT_OVERLAY}))).childIf(!hasGhostCircuit, (IWidget)new Widget().background(new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.BUTTON_X}).tooltip(t -> t.addLine((IDrawable)IKey.lang((String)"gregtech.gui.configurator_slot.unavailable.tooltip")))));
    }

    @Override
    public boolean hasGhostCircuitInventory() {
        return !this.isExportHatch;
    }

    private static void collapseInventorySlotContents(IItemHandlerModifiable inventory) {
        Object2IntMap<ItemStack> inventoryContents = GTHashMaps.fromItemHandler((IItemHandler)inventory, true);
        ArrayList<ItemStack> inventoryItemContents = new ArrayList<ItemStack>();
        for (Object2IntMap.Entry e : inventoryContents.object2IntEntrySet()) {
            ItemStack copy;
            int count;
            ItemStack stack = (ItemStack)e.getKey();
            int maxStackSize = stack.func_77976_d();
            for (count = e.getIntValue(); count >= maxStackSize; count -= maxStackSize) {
                copy = stack.func_77946_l();
                copy.func_190920_e(maxStackSize);
                inventoryItemContents.add(copy);
            }
            if (count <= 0) continue;
            copy = stack.func_77946_l();
            copy.func_190920_e(count);
            inventoryItemContents.add(copy);
        }
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stackToMove = i >= inventoryItemContents.size() ? ItemStack.field_190927_a : (ItemStack)inventoryItemContents.get(i);
            inventory.setStackInSlot(i, stackToMove);
        }
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        this.setAutoCollapse(!this.autoCollapse);
        if (!this.getWorld().field_72995_K) {
            if (this.autoCollapse) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.bus.collapse_true", new Object[0]), true);
            } else {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.bus.collapse_false", new Object[0]), true);
            }
        }
        return true;
    }

    public boolean isAutoCollapse() {
        return this.autoCollapse;
    }

    public void setAutoCollapse(boolean inverted) {
        this.autoCollapse = inverted;
        if (!this.getWorld().field_72995_K) {
            if (this.autoCollapse) {
                if (this.isExportHatch) {
                    this.addNotifiedOutput(this.getExportItems());
                } else {
                    this.addNotifiedInput(super.getImportItems());
                }
            }
            this.writeCustomData(GregtechDataCodes.TOGGLE_COLLAPSE_ITEMS, packetBuffer -> packetBuffer.writeBoolean(this.autoCollapse));
            this.notifyBlockUpdate();
            this.markDirty();
        }
    }

    @Override
    public void setGhostCircuitConfig(int config) {
        if (this.circuitInventory == null || this.circuitInventory.getCircuitValue() == config) {
            return;
        }
        this.circuitInventory.setCircuitValue(config);
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        if (this.isExportHatch) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.item_bus.export.tooltip", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.item_bus.import.tooltip", (Object[])new Object[0]));
        }
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.item_storage_capacity", (Object[])new Object[]{this.getInventorySize()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.auto_collapse", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }
}

