/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.RichTextWidget;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IFilter;
import gregtech.api.capability.IFilteredFluidContainer;
import gregtech.api.capability.IGhostSlotConfigurable;
import gregtech.api.capability.impl.FilteredItemHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.GhostCircuitItemStackHandler;
import gregtech.api.capability.impl.NotifiableFluidTank;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.api.mui.sync.GTFluidSyncHandler;
import gregtech.api.mui.widget.GhostCircuitSlotWidget;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockNotifiablePart;
import gregtech.common.metatileentities.storage.MetaTileEntityQuantumTank;
import gregtech.common.mui.widget.GTFluidSlot;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityFluidHatch
extends MetaTileEntityMultiblockNotifiablePart
implements IMultiblockAbilityPart<IFluidTank>,
IControllable,
IGhostSlotConfigurable {
    public static final int INITIAL_INVENTORY_SIZE = 8000;
    protected final HatchFluidTank fluidTank;
    protected boolean workingEnabled;
    private GhostCircuitItemStackHandler circuitInventory;
    protected boolean locked;
    @Nullable
    protected FluidStack lockedFluid;

    public MetaTileEntityFluidHatch(ResourceLocation metaTileEntityId, int tier, boolean isExportHatch) {
        super(metaTileEntityId, tier, isExportHatch);
        this.fluidTank = new HatchFluidTank(this.getInventorySize(), this, isExportHatch);
        this.initializeInventory();
        this.workingEnabled = true;
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        if (this.hasGhostCircuitInventory()) {
            this.circuitInventory = new GhostCircuitItemStackHandler(this);
            this.circuitInventory.addNotifiableMetaTileEntity(this);
        }
    }

    @Override
    public boolean hasGhostCircuitInventory() {
        return !this.isExportHatch;
    }

    @Override
    public void setGhostCircuitConfig(int config) {
        if (this.circuitInventory == null || this.circuitInventory.getCircuitValue() == config) {
            return;
        }
        this.circuitInventory.setCircuitValue(config);
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityFluidHatch(this.metaTileEntityId, this.getTier(), this.isExportHatch);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("workingEnabled", this.workingEnabled);
        if (this.isExportHatch) {
            data.func_74757_a("IsLocked", this.locked);
            if (this.locked && this.lockedFluid != null) {
                data.func_74782_a("LockedFluid", (NBTBase)this.lockedFluid.writeToNBT(new NBTTagCompound()));
            }
        } else {
            this.circuitInventory.write(data);
        }
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("workingEnabled")) {
            this.workingEnabled = data.func_74767_n("workingEnabled");
        }
        if (data.func_74764_b("ContainerInventory")) {
            MetaTileEntityQuantumTank.legacyTankItemHandlerNBTReading(this, data.func_74775_l("ContainerInventory"), 0, 1);
        }
        if (this.isExportHatch) {
            this.locked = data.func_74767_n("IsLocked");
            this.lockedFluid = this.locked ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)data.func_74775_l("LockedFluid")) : null;
        } else {
            this.circuitInventory.read(data);
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.workingEnabled) {
            this.fillContainerFromInternalTank((IFluidHandler)this.fluidTank);
            if (this.isExportHatch) {
                this.pushFluidsIntoNearbyHandlers(this.getFrontFacing());
            } else {
                this.fillInternalTankFromFluidContainer((IFluidHandler)this.fluidTank);
                this.pullFluidsFromNearbyHandlers(this.getFrontFacing());
            }
        }
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.workingEnabled = workingEnabled;
        World world = this.getWorld();
        if (world != null && !world.field_72995_K) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(workingEnabled));
        }
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.workingEnabled);
        if (this.isExportHatch) {
            buf.writeBoolean(this.locked);
            NetworkUtils.writeFluidStack((PacketBuffer)buf, (FluidStack)this.lockedFluid);
        } else {
            buf.func_150787_b(this.circuitInventory.getCircuitValue());
        }
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.workingEnabled = buf.readBoolean();
        if (this.isExportHatch) {
            this.locked = buf.readBoolean();
            this.lockedFluid = NetworkUtils.readFluidStack((PacketBuffer)buf);
        } else {
            this.setGhostCircuitConfig(buf.func_150792_a());
        }
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.workingEnabled = buf.readBoolean();
        } else if (dataId == GregtechDataCodes.LOCK_FILL) {
            this.lockedFluid = NetworkUtils.readFluidStack((PacketBuffer)buf);
        }
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            SimpleOverlayRenderer renderer = this.isExportHatch ? Textures.PIPE_OUT_OVERLAY : Textures.PIPE_IN_OVERLAY;
            renderer.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            SimpleOverlayRenderer overlay = this.isExportHatch ? Textures.FLUID_HATCH_OUTPUT_OVERLAY : Textures.FLUID_HATCH_INPUT_OVERLAY;
            overlay.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        }
    }

    protected int getInventorySize() {
        return 8000 * Math.min(Integer.MAX_VALUE, 1 << this.getTier());
    }

    @Override
    protected FluidTankList createImportFluidHandler() {
        return this.isExportHatch ? new FluidTankList(false, new IFluidTank[0]) : new FluidTankList(false, new IFluidTank[]{this.fluidTank});
    }

    @Override
    protected FluidTankList createExportFluidHandler() {
        return this.isExportHatch ? new FluidTankList(false, new IFluidTank[]{this.fluidTank}) : new FluidTankList(false, new IFluidTank[0]);
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new FilteredItemHandler((MetaTileEntity)this, 1).setFillPredicate(FilteredItemHandler.getCapabilityFilter(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY));
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new GTItemStackHandler((MetaTileEntity)this, 1);
    }

    @Override
    @NotNull
    public List<MultiblockAbility<?>> getAbilities() {
        return this.isExportHatch ? Collections.singletonList(MultiblockAbility.EXPORT_FLUIDS) : Arrays.asList(MultiblockAbility.IMPORT_FLUIDS, MultiblockAbility.IMPORT_ITEMS);
    }

    @Override
    public void registerAbilities(@NotNull AbilityInstances abilityInstances) {
        if (abilityInstances.isKey(MultiblockAbility.EXPORT_FLUIDS) || abilityInstances.isKey(MultiblockAbility.IMPORT_FLUIDS)) {
            abilityInstances.add(this.fluidTank);
        } else if (abilityInstances.isKey(MultiblockAbility.IMPORT_ITEMS)) {
            abilityInstances.add(this.circuitInventory);
        }
    }

    @Override
    public boolean usesMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(PosGuiData guiData, PanelSyncManager guiSyncManager) {
        GTFluidSyncHandler fluidSyncHandler = GTFluidSlot.sync((IFluidTank)this.fluidTank).showAmountOnSlot(false).accessibility(true, !this.isExportHatch);
        if (this.isExportHatch) {
            fluidSyncHandler.handleLocking(() -> this.lockedFluid, fluidStack -> {
                this.setLocked(fluidStack != null);
                this.lockedFluid = fluidStack;
                this.fluidTank.onContentsChanged();
            }, this::setLocked);
        }
        return ((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)GTGuis.createPanel(this, 176, 166).child((IWidget)IKey.lang((String)this.getMetaFullName()).asWidget().pos(6, 6))).childIf(this.isExportHatch, (IWidget)((ItemSlot)((ItemSlot)new ItemSlot().pos(90, 44)).background(new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.OUT_SLOT_OVERLAY})).slot(new ModularSlot((IItemHandler)this.exportItems, 0).accessibility(false, true)))).childIf(this.isExportHatch, (IWidget)((ToggleButton)((ToggleButton)new ToggleButton().pos(7, 63)).overlay(new IDrawable[]{GTGuiTextures.BUTTON_LOCK})).value((IBoolValue)new BooleanSyncValue(this::isLocked, b -> fluidSyncHandler.lockFluid(b, false))).addTooltip(true, (IDrawable)IKey.lang((String)"gregtech.gui.fluid_lock.tooltip.enabled")).addTooltip(false, (IDrawable)IKey.lang((String)"gregtech.gui.fluid_lock.tooltip.disabled")))).childIf(!this.isExportHatch, (IWidget)((Widget)GTGuiTextures.TANK_ICON.asWidget().pos(91, 36)).size(14, 15))).childIf(!this.isExportHatch, (IWidget)((ItemSlot)((ItemSlot)new ItemSlot().pos(90, 53)).background(new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.OUT_SLOT_OVERLAY})).slot(new ModularSlot((IItemHandler)this.exportItems, 0).accessibility(false, true)))).childIf(!this.isExportHatch, (IWidget)((ItemSlot)new GhostCircuitSlotWidget().slot(this.circuitInventory, 0).background(new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.INT_CIRCUIT_OVERLAY})).pos(124, 62))).child((IWidget)((RichTextWidget)((RichTextWidget)((RichTextWidget)((RichTextWidget)((RichTextWidget)new RichTextWidget().size(75, (this.isExportHatch ? 46 : 55) - 8)).background(new IDrawable[]{GTGuiTextures.DISPLAY.asIcon().size(81, this.isExportHatch ? 46 : 55)})).pos(10, 20)).textColor(Color.WHITE.main)).alignment(Alignment.TopLeft)).autoUpdate(true).textBuilder(richText -> {
            richText.addLine((IDrawable)IKey.lang((String)"gregtech.gui.fluid_amount"));
            IKey nameKey = fluidSyncHandler.getFluidNameKey();
            if (nameKey == IKey.EMPTY) {
                return;
            }
            String formatted = nameKey.getFormatted();
            if (formatted.length() > 25) {
                nameKey = IKey.str((String)(formatted.substring(0, 25) + TextFormatting.WHITE + "..."));
            }
            richText.addLine((IDrawable)nameKey);
            richText.addLine((IDrawable)IKey.str((String)fluidSyncHandler.getFormattedFluidAmount()));
        }))).child((IWidget)((GTFluidSlot)((GTFluidSlot)new GTFluidSlot().disableBackground().pos(69, this.isExportHatch ? 43 : 52)).size(18)).syncHandler(fluidSyncHandler))).child((IWidget)((ItemSlot)((ItemSlot)new ItemSlot().pos(90, 16)).background(new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.IN_SLOT_OVERLAY})).slot(new ModularSlot((IItemHandler)this.importItems, 0).singletonSlotGroup().filter(stack -> {
            if (!this.isExportHatch) {
                return true;
            }
            IFluidHandlerItem h = FluidUtil.getFluidHandler((ItemStack)stack);
            if (h == null) {
                return false;
            }
            return h.getTankProperties()[0].getContents() == null;
        }).accessibility(true, true)))).bindPlayerInventory();
    }

    @Override
    public void addToMultiBlock(MultiblockControllerBase controllerBase) {
        super.addToMultiBlock(controllerBase);
        if (this.hasGhostCircuitInventory()) {
            this.circuitInventory.addNotifiableMetaTileEntity(controllerBase);
        }
    }

    @Override
    public void removeFromMultiBlock(MultiblockControllerBase controllerBase) {
        super.removeFromMultiBlock(controllerBase);
        if (this.hasGhostCircuitInventory()) {
            this.circuitInventory.removeNotifiableMetaTileEntity(controllerBase);
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        if (this.isExportHatch) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_hatch.export.tooltip", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_hatch.import.tooltip", (Object[])new Object[0]));
        }
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{this.getInventorySize()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    private boolean isLocked() {
        return this.locked;
    }

    private void setLocked(boolean locked) {
        if (!this.isExportHatch || this.locked == locked) {
            return;
        }
        this.locked = locked;
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
        if (locked && this.fluidTank.getFluid() != null) {
            this.lockedFluid = this.fluidTank.getFluid().copy();
            this.lockedFluid.amount = 1;
            this.fluidTank.onContentsChanged();
            return;
        }
        this.lockedFluid = null;
        this.fluidTank.onContentsChanged();
    }

    protected class HatchFluidTank
    extends NotifiableFluidTank
    implements IFilteredFluidContainer,
    IFilter<FluidStack> {
        public HatchFluidTank(int capacity, MetaTileEntity entityToNotify, boolean isExport) {
            super(capacity, entityToNotify, isExport);
        }

        public int fillInternal(FluidStack resource, boolean doFill) {
            int accepted = super.fillInternal(resource, doFill);
            if (!MetaTileEntityFluidHatch.this.isExportHatch) {
                return accepted;
            }
            if (doFill && MetaTileEntityFluidHatch.this.locked && MetaTileEntityFluidHatch.this.lockedFluid == null) {
                MetaTileEntityFluidHatch.this.lockedFluid = resource.copy();
                MetaTileEntityFluidHatch.this.lockedFluid.amount = 1;
                MetaTileEntityFluidHatch.this.writeCustomData(GregtechDataCodes.LOCK_FILL, buffer -> NetworkUtils.writeFluidStack((PacketBuffer)buffer, (FluidStack)MetaTileEntityFluidHatch.this.lockedFluid));
            }
            return accepted;
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return this.test(fluid);
        }

        @Override
        public void onContentsChanged() {
            super.onContentsChanged();
        }

        @Override
        @Nullable
        public IFilter<FluidStack> getFilter() {
            return this;
        }

        @Override
        public boolean test(@NotNull FluidStack fluidStack) {
            if (!MetaTileEntityFluidHatch.this.isExportHatch) {
                return true;
            }
            return !MetaTileEntityFluidHatch.this.locked || MetaTileEntityFluidHatch.this.lockedFluid == null || fluidStack.isFluidEqual(MetaTileEntityFluidHatch.this.lockedFluid);
        }

        @Override
        public int getPriority() {
            if (!MetaTileEntityFluidHatch.this.isExportHatch) {
                return IFilter.noPriority();
            }
            return !MetaTileEntityFluidHatch.this.locked || MetaTileEntityFluidHatch.this.lockedFluid == null ? IFilter.noPriority() : IFilter.whitelistPriority(1);
        }
    }
}

