/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IQuantumController;
import gregtech.api.capability.IQuantumStorage;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.client.utils.PipelineUtil;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityEnergyHatch
extends MetaTileEntityMultiblockPart
implements IMultiblockAbilityPart<IEnergyContainer>,
IQuantumStorage<IEnergyContainer> {
    protected final boolean isExportHatch;
    protected final int amperage;
    protected final IEnergyContainer energyContainer;
    private WeakReference<IQuantumController> controller = new WeakReference<Object>(null);
    private BlockPos controllerPos;

    public MetaTileEntityEnergyHatch(ResourceLocation metaTileEntityId, int tier, int amperage, boolean isExportHatch) {
        super(metaTileEntityId, tier);
        this.isExportHatch = isExportHatch;
        this.amperage = amperage;
        if (isExportHatch) {
            this.energyContainer = EnergyContainerHandler.emitterContainer(this, GTValues.V[tier] * 64L * (long)amperage, GTValues.V[tier], amperage);
            ((EnergyContainerHandler)this.energyContainer).setSideOutputCondition(s -> s == this.getFrontFacing());
        } else {
            this.energyContainer = EnergyContainerHandler.receiverContainer(this, GTValues.V[tier] * 16L * (long)amperage, GTValues.V[tier], amperage);
        }
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityEnergyHatch(this.metaTileEntityId, this.getTier(), this.amperage, this.isExportHatch);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            this.getOverlay().renderSided(this.getFrontFacing(), renderState, translation, PipelineUtil.color(pipeline, GTValues.VC[this.getTier()]));
        }
    }

    @Override
    public void update() {
        super.update();
        this.checkWeatherOrTerrainExplosion(this.getTier(), this.getTier() * 10, this.energyContainer);
    }

    @NotNull
    private SimpleOverlayRenderer getOverlay() {
        if (this.isExportHatch) {
            if (this.amperage <= 2) {
                return Textures.ENERGY_OUT_MULTI;
            }
            if (this.amperage <= 4) {
                return Textures.ENERGY_OUT_HI;
            }
            if (this.amperage <= 16) {
                return Textures.ENERGY_OUT_ULTRA;
            }
            return Textures.ENERGY_OUT_MAX;
        }
        if (this.amperage <= 2) {
            return Textures.ENERGY_IN_MULTI;
        }
        if (this.amperage <= 4) {
            return Textures.ENERGY_IN_HI;
        }
        if (this.amperage <= 16) {
            return Textures.ENERGY_IN_ULTRA;
        }
        return Textures.ENERGY_IN_MAX;
    }

    @Override
    public MultiblockAbility<IEnergyContainer> getAbility() {
        return this.isExportHatch ? MultiblockAbility.OUTPUT_ENERGY : MultiblockAbility.INPUT_ENERGY;
    }

    @Override
    public void registerAbilities(@NotNull AbilityInstances abilityInstances) {
        abilityInstances.add(this.energyContainer);
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        String tierName = GTValues.VNF[this.getTier()];
        this.addDescriptorTooltip(stack, world, tooltip, advanced);
        if (this.isExportHatch) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_out", (Object[])new Object[]{this.energyContainer.getOutputVoltage(), tierName}));
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.amperage_out_till", (Object[])new Object[]{this.energyContainer.getOutputAmperage()}));
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.throughput", (Object[])new Object[]{this.energyContainer.getOutputVoltage() * this.energyContainer.getOutputAmperage()}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in", (Object[])new Object[]{this.energyContainer.getInputVoltage(), tierName}));
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.amperage_in_till", (Object[])new Object[]{this.energyContainer.getInputAmperage()}));
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.throughput", (Object[])new Object[]{this.energyContainer.getInputVoltage() * this.energyContainer.getInputAmperage()}));
        }
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    protected void addDescriptorTooltip(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        if (this.isExportHatch) {
            if (this.amperage > 2) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.machine.energy_hatch.output_hi_amp.tooltip", (Object[])new Object[0]));
            } else {
                tooltip.add(I18n.func_135052_a((String)"gregtech.machine.energy_hatch.output.tooltip", (Object[])new Object[0]));
            }
        } else if (this.amperage > 2) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.energy_hatch.input_hi_amp.tooltip", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.energy_hatch.input.tooltip", (Object[])new Object[0]));
        }
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    public boolean canRenderFrontFaceX() {
        return this.isExportHatch;
    }

    @Override
    public void doExplosion(float explosionPower) {
        if (this.getController() != null) {
            this.getController().explodeMultiblock(explosionPower);
        } else {
            super.doExplosion(explosionPower);
        }
    }

    @Override
    public void onRemoval() {
        IQuantumController controller;
        if (!this.getWorld().field_72995_K && this.isConnected() && (controller = this.getQuantumController()) != null) {
            controller.rebuildNetwork();
        }
    }

    @Override
    public void onPlacement(@Nullable EntityLivingBase placer) {
        super.onPlacement(placer);
        if (this.getWorld() == null || this.getWorld().field_72995_K || this.isExportHatch) {
            return;
        }
        this.tryFindNetwork();
    }

    @Override
    public IQuantumStorage.Type getType() {
        return IQuantumStorage.Type.ENERGY;
    }

    @Override
    public ICubeRenderer getBaseTexture() {
        if (this.isConnected()) {
            return Textures.QUANTUM_CASING;
        }
        return super.getBaseTexture();
    }

    @Override
    public void setConnected(IQuantumController controller) {
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (this.isExportHatch) {
            return;
        }
        if (!controller.getPos().equals((Object)this.controllerPos)) {
            this.controller = new WeakReference<IQuantumController>(controller);
            this.controllerPos = controller.getPos();
            this.writeCustomData(GregtechDataCodes.UPDATE_CONTROLLER_POS, buf -> buf.func_179255_a(this.controllerPos));
            this.markDirty();
        }
    }

    @Override
    public void setDisconnected() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        this.controller.clear();
        this.controllerPos = null;
        this.writeCustomData(GregtechDataCodes.REMOVE_CONTROLLER, buf -> {});
        this.markDirty();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_CONTROLLER_POS) {
            this.controllerPos = buf.func_179259_c();
            this.controller.clear();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.REMOVE_CONTROLLER) {
            this.controllerPos = null;
            this.controller.clear();
            this.scheduleRenderUpdate();
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.controllerPos != null);
        if (this.controllerPos != null) {
            buf.func_179255_a(this.controllerPos);
        }
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        if (buf.readBoolean()) {
            this.controllerPos = buf.func_179259_c();
            this.scheduleRenderUpdate();
        }
    }

    @Override
    public final IQuantumController getQuantumController() {
        if (this.isConnected()) {
            if (this.controller.get() != null) {
                return (IQuantumController)this.controller.get();
            }
            MetaTileEntity mte = GTUtility.getMetaTileEntity((IBlockAccess)this.getWorld(), this.controllerPos);
            if (mte instanceof IQuantumController) {
                IQuantumController quantumController = (IQuantumController)((Object)mte);
                this.controller = new WeakReference<IQuantumController>(quantumController);
                return quantumController;
            }
            this.setDisconnected();
            this.tryFindNetwork();
        }
        return null;
    }

    @Override
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    @Override
    public IEnergyContainer getTypeValue() {
        return this.energyContainer;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        NBTTagCompound tagCompound = super.writeToNBT(data);
        tagCompound.func_74757_a("HasController", this.controllerPos != null);
        if (this.controllerPos != null) {
            tagCompound.func_74772_a("ControllerPos", this.controllerPos.func_177986_g());
        }
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74767_n("HasController")) {
            this.controllerPos = BlockPos.func_177969_a((long)data.func_74763_f("ControllerPos"));
        }
    }
}

