/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.IDataAccessHatch;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.metatileentity.IDataInfoProvider;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.machines.IResearchRecipeMap;
import gregtech.api.util.AssemblyLineManager;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.api.util.LocalizationUtils;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.ConfigHolder;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityDataBank;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockNotifiablePart;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityDataAccessHatch
extends MetaTileEntityMultiblockNotifiablePart
implements IMultiblockAbilityPart<IDataAccessHatch>,
IDataAccessHatch,
IDataInfoProvider {
    private final Set<Recipe> recipes;
    private final boolean isCreative;

    public MetaTileEntityDataAccessHatch(ResourceLocation metaTileEntityId, int tier, boolean isCreative) {
        super(metaTileEntityId, tier, false);
        this.isCreative = isCreative;
        this.recipes = isCreative ? Collections.emptySet() : new ObjectOpenHashSet();
        this.rebuildData(this.getController() instanceof MetaTileEntityDataBank);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityDataAccessHatch(this.metaTileEntityId, this.getTier(), this.isCreative());
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        if (this.isCreative) {
            return super.createImportItemHandler();
        }
        return new NotifiableItemStackHandler(this, this.getInventorySize(), this.getController(), false){

            @Override
            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                MetaTileEntityDataAccessHatch.this.rebuildData(MetaTileEntityDataAccessHatch.this.getController() instanceof MetaTileEntityDataBank);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                MultiblockControllerBase controller = MetaTileEntityDataAccessHatch.this.getController();
                boolean isDataBank = controller instanceof MetaTileEntityDataBank;
                if (AssemblyLineManager.isStackDataItem(stack, isDataBank) && AssemblyLineManager.hasResearchTag(stack)) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }
        };
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            if (this.isCreative) {
                Textures.CREATIVE_DATA_ACCESS_HATCH.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            } else {
                Textures.DATA_ACCESS_HATCH.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            }
        }
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        if (this.isCreative) {
            return null;
        }
        int rowSize = (int)Math.sqrt(this.getInventorySize());
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 18 + 18 * rowSize + 94).label(6, 6, this.getMetaFullName());
        for (int y = 0; y < rowSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                int index = y * rowSize + x;
                builder.widget(new SlotWidget((IItemHandler)(this.isExportHatch ? this.exportItems : this.importItems), index, 88 - rowSize * 9 + x * 18, 18 + y * 18, true, !this.isExportHatch).setBackgroundTexture(GuiTextures.SLOT));
            }
        }
        return builder.bindPlayerInventory(entityPlayer.field_71071_by, GuiTextures.SLOT, 7, 18 + 18 * rowSize + 12).build(this.getHolder(), entityPlayer);
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return !this.isCreative;
    }

    protected int getInventorySize() {
        return this.getTier() == 6 ? 16 : 9;
    }

    private void rebuildData(boolean isDataBank) {
        if (this.isCreative || this.getWorld() == null || this.getWorld().field_72995_K) {
            return;
        }
        this.recipes.clear();
        for (int i = 0; i < this.importItems.getSlots(); ++i) {
            Collection<Recipe> collection;
            ItemStack stack = this.importItems.getStackInSlot(i);
            String researchId = AssemblyLineManager.readResearchId(stack);
            boolean isValid = AssemblyLineManager.isStackDataItem(stack, isDataBank);
            if (researchId == null || !isValid || (collection = ((IResearchRecipeMap)((Object)RecipeMaps.ASSEMBLY_LINE_RECIPES)).getDataStickEntry(researchId)) == null) continue;
            this.recipes.addAll(collection);
        }
    }

    @Override
    public boolean isRecipeAvailable(@NotNull Recipe recipe, @NotNull Collection<IDataAccessHatch> seen) {
        seen.add(this);
        return this.recipes.contains(recipe);
    }

    @Override
    public boolean isCreative() {
        return this.isCreative;
    }

    @Override
    public void getSubItems(CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
        if (ConfigHolder.machines.enableResearch) {
            super.getSubItems(creativeTab, subItems);
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, world, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.data_access_hatch.tooltip.1", (Object[])new Object[0]));
        if (this.isCreative) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.creative_tooltip.1", (Object[])new Object[0]) + TooltipHelper.RAINBOW + I18n.func_135052_a((String)"gregtech.creative_tooltip.2", (Object[])new Object[0]) + I18n.func_135052_a((String)"gregtech.creative_tooltip.3", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.data_access_hatch.tooltip.2", (Object[])new Object[]{this.getInventorySize()}));
        }
        if (this.canPartShare()) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.disabled", (Object[])new Object[0]));
        }
    }

    @Override
    @NotNull
    public List<ITextComponent> getDataInfo() {
        if (this.recipes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new TextComponentTranslation("behavior.data_item.assemblyline.title", new Object[0]));
        list.add((ITextComponent)new TextComponentString(""));
        ObjectOpenCustomHashSet itemsAdded = new ObjectOpenCustomHashSet((Hash.Strategy)ItemStackHashStrategy.comparingAll());
        for (Recipe recipe : this.recipes) {
            ItemStack stack = recipe.getOutputs().get(0);
            if (itemsAdded.contains(stack)) continue;
            itemsAdded.add(stack);
            list.add((ITextComponent)new TextComponentTranslation("behavior.data_item.assemblyline.data", new Object[]{LocalizationUtils.format(stack.func_77977_a(), new Object[0])}));
        }
        return list;
    }

    @Override
    public boolean canPartShare() {
        return this.isCreative;
    }

    @Override
    public MultiblockAbility<IDataAccessHatch> getAbility() {
        return MultiblockAbility.DATA_ACCESS_HATCH;
    }

    @Override
    public void registerAbilities(@NotNull AbilityInstances abilityInstances) {
        abilityInstances.add(this);
    }

    @Override
    public void addToMultiBlock(MultiblockControllerBase controllerBase) {
        this.rebuildData(controllerBase instanceof MetaTileEntityDataBank);
        super.addToMultiBlock(controllerBase);
    }
}

